from __future__ import absolute_import
import cherrypy
import cgi
import datetime
import logging
import os
import platform
import time

import splunk
import splunk.appserver.mrsparkle.lib.util as util
import xml.sax.saxutils as su

logger = logging.getLogger('splunk.appserver.mrsparkle.lib.error')

# oldest crash log to present to the user, in minutes
CRASH_WINDOW = 10

HTML_TEMPLATE = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<!-- 
    This is a static HTML string template to render errors.  To edit this
    template, see appserver/mrsparkle/lib/error.py. 
-->
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:splunk="http://www.splunk.com/xhtml-extensions/1.0" xml:lang="en">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta name="referrer" content="never" />
    <meta name="referrer" content="no-referrer" />
    <link rel="shortcut icon" href="%(favicon)s" />
    <title>%(message)s - Splunk</title>
    <style>
        @font-face {
            font-family: "Splunk Sans";
            src: url('/static/fonts/proxima-regular-webfont.woff') format('woff');
            font-weight: 400;
            font-style: normal;
        }
        @font-face {
            font-family: "Splunk Mono";
            src: url('/static/fonts/inconsolata-regular.woff') format('woff');
            font-weight: 400;
            font-style: normal;
        }
        *       { margin: 0; padding: 0; }
        body    { font-family: "Splunk Sans", "Proxima Nova", Roboto, Droid, "Helvetica Neue", Helvetica, Arial, sans-serif; color: #3C444D; background-color: #F2F4F5; position: absolute; top: 0; right: 0; bottom: 0; left: 0; }
        a       { color: #007ABD; text-decoration: none; }
        a:hover { text-decoration: underline; }
        p,pre   { margin-bottom: 1em; }
        .status { color: #818D99; margin: 20px; }
        .msg    { margin-bottom: 1em; font-size: 1.4em;}
        pre     { font-family: Monaco,Courier Bold,Courier New,monospace; font-size: .7em;background-color: #eee;  padding: 5px;}
        #toggle { font-size: .8em; margin-bottom: 1em; }
        .byline { color: #555; }
        .byline span { font-weight: bold; line-height: 1.4em; }
        hr      { height: 1px; background-color: #c3cbd4; border: 0; margin: 20px 0 10px; }
        h1      { font-size: 100px; margin-bottom: 10px; }
        h2      { font-size: 1em; margin-bottom: 1em; }
        table   { border-collapse: collapse; }
        td      { padding: 2px; }
        td.k    { font-family: helvetica neue, helvetica, arial, sans-serif; font-weight: bold; }
        #debug  { display: %(visibility)s; }
        #crashes { margin: 20px 0; padding: 10px; border: 1px solid #800; }
        #crashes dt { font-size: 12px; margin-bottom: 5px; }
        #crashes dd { white-space: pre; background: #f2f2f2; padding: 10px; margin-left: 20px; display: none; font-size: 11px; font-family: "Splunk Mono", Inconsolata, Consolas, "Droid Sans Mono", Monaco, "Courier New", Courier, monospace; }
        .fixed-width        { width: 960px; margin: auto; }
        .error-wrapper      { height: 60%%; min-height: 400px; margin-top: 10vh; }
        .error-container    { z-index: 10; display: table; }
        .error-image        { float: left; margin-left: 80px; }
        .error-message      { display: inline-block; margin: 60px 0 0 100px; width: 600px; }
        .error-message p    { font-size: 18px; }
        .error-background   { color: #B8C2CC; position: absolute; margin-top: 260px; height: 96px; z-index: -10; line-height: 16px; user-select: none; font-size: 11px; font-family: "Splunk Mono", Inconsolata, Consolas, "Droid Sans Mono", Monaco, "Courier New", Courier, monospace; }
        .main-error-background    { height: 80px; width: 76%%; overflow: hidden; text-overflow: clip; }
        .error-offset-background  { position: absolute; top: 0; left: 65%%; width: 150px; }
        .offset-background  { position: absolute; white-space: nowrap; }
        .offset-1           { top: 19px; left: 50px; transform: rotate(12deg); -webkit-transform: rotate(12deg); -ms-transform: rotate(12deg); }
        .offset-2           { top: 10px; left: 20px; transform: rotate(41deg); -webkit-transform: rotate(41deg); -ms-transform: rotate(41deg); }
        .offset-3           { top: 4px; left: 40px; transform: rotate(-3deg); -webkit-transform: rotate(-3deg); -ms-transform: rotate(-3deg); }
        .offset-4           { top: 30px; left: 106px; transform: rotate(-13deg); -webkit-transform: rotate(-13deg); -ms-transform: rotate(-13deg); }
        .offset-5           { top: 29px; left: 125px; }
        .offset-6           { top: 21px; left: 239px; }
        .offset-7           { top: 37px; left: 198px; }
        .offset-8           { top: 58px; left: 237px; }
        .offset-9           { top: 46px; left: 194px; transform: rotate(-18deg); -webkit-transform: rotate(-18deg); -ms-transform: rotate(-18deg); }
        .offset-10          { top: 52px; left: 203px; transform: rotate(41deg); -webkit-transform: rotate(41deg); -ms-transform: rotate(41deg); }
        .offset-11          { top: 63px; left: 239px; transform: rotate(-3deg); -webkit-transform: rotate(-3deg); -ms-transform: rotate(-3deg); }
        .offset-12          { top: 56px; left: 61px; transform: rotate(-3deg); -webkit-transform: rotate(-3deg); -ms-transform: rotate(-3deg); }
        .offset-13          { top: 88px; left: 65px; transform: rotate(41deg); -webkit-transform: rotate(41deg); -ms-transform: rotate(41deg); }
        .offset-14          { top: 100px; left: 0px; transform: rotate(-30deg); -webkit-transform: rotate(-30deg); -ms-transform: rotate(-30deg); }
        .message-wrapper    { padding: 20px; margin-top: 20px; clear: both; border-top: 1px solid #C3CBD4; }
        .message-container  { padding: 0 0 10px 0; }
        .message-container:empty { padding: 0; }
    </style>
    <script>
        function toggle(what) {
            what = document.getElementById(what);
            if (what.style.display == 'block') {
                what.style.display = 'none';
            } else {
                what.style.display = 'block';
            }
        }
    </script>
</head>
<body>
    <p class="status" data-role="page-status">%(status)s</p>
    <div class="error-wrapper">
        <div class="error-background">
            <div class="main-error-background">
                12.130.60.4 - - [05/Mar/2014 18:10:57:153] "GET /category.screen?category_id=GIFTS&JSESSIONID=SD1SL4FF10ADFF10 HTTP 1.1" 404 720 "http://buttercup-shopping.com/cart.do?action=view&itemId=EST-6&product_id=FI-SW-01" "Opera/9.20 (Windows NT 6.0; U; en)" 559 128.241.220.82 - - [05/Mar/2014 18:10:57:123] "GET /product.screen?product_id=FL-DSH-01&JSESSIONID=SD5SL7FF6ADFF9 HTTP 1.1" 404 3322 "http://buttercup-shopping.com/category.screen?category_id=GIFTS" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)" 317 27.160.0.0 - - [05/Mar/2014 18:10:56:156] "GET /oldlink?item_id=EST-26&JSESSIONID=SD5SL9FF1ADFF3 HTTP 1.1" 200 1318 "http://buttercup-shopping.com/cart.do?action=purchase&itemId=EST-26&product_id=K9-CW-01" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)" 468 12.130.60.4 - - [05/Mar/2014 18:10:57:153] "GET /category.screen?category_id=GIFTS&JSESSIONID=SD1SL4FF10ADFF10 HTTP 1.1" 404 720 "http://buttercup-shopping.com/cart.do?action=view&itemId=EST-6&product_id=FI-SW-01" "Opera/9.20 (Windows NT 6.0; U; en)" 559 128.241.220.82 - - [05/Mar/2014 18:10:57:123] "GET /product.screen?product_id=FL-DSH-01&JSESSIONID=SD5SL7FF6ADFF9 HTTP 1.1" 404 3322 "http://buttercup-shopping.com/category.screen?category_id=GIFTS" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)" 317 27.160.0.0 - - [05/Mar/2014 18:10:56:156] "GET /oldlink?item_id=EST-26&JSESSIONID=SD5SL9FF1ADFF3 HTTP 1.1" 200 1318 "http://buttercup-shopping.com/cart.do?action=purchase&itemId=EST-26&product_id=K9-CW-01" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)" 468 12.130.60.4 - - [05/Mar/2014 18:10:57:153] "GET /category.screen?category_id=GIFTS&JSESSIONID=SD1SL4FF10ADFF10 HTTP 1.1" 404 720 "http://buttercup-shopping.com/cart.do?action=view&itemId=EST-6&product_id=FI-SW-01" "Opera/9.20 (Windows NT 6.0; U; en)" 559 128.241.220.82 - - [05/Mar/2014 18:10:57:123] "GET /product.screen?product_id=FL-DSH-01&JSESSIONID=SD5SL7FF6ADFF9 HTTP 1.1" 404 3322 "http://buttercup-shopping.com/category.screen?category_id=GIFTS" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)" 317 27.160.0.0 - - [05/Mar/2014 18:10:56:156] "GET /oldlink?item_id=EST-26&JSESSIONID=SD5SL9FF1ADFF3 HTTP 1.1" 200 1318 "http://buttercup-shopping.com/cart.do?action=purchase&itemId=EST-26&product_id=K9-CW-01" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)" 468
            </div>
            <div class="error-offset-background">
                <div class="offset-1 offset-background">
                     "http://buttercup-shopping.com/cart.do?actio
                </div>
                <div class="offset-2 offset-background">
                     view&itemId=EST-6
                </div>
                <div class="offset-3 offset-background">
                     reen?category_id=GIFTS&JSESSIONID
                </div>
                <div class="offset-4 offset-background">
                     JSESSIONID
                </div>
                <div class="offset-5 offset-background">
                     18:10:57:153
                </div>
                <div class="offset-6 offset-background">
                     action
                </div>
                <div class="offset-7 offset-background">
                     shopping.com
                </div>
                <div class="offset-8 offset-background">
                     404
                </div>
                <div class="offset-9 offset-background">
                     12.130.60.4
                </div>
                <div class="offset-10 offset-background">
                     SD1SL4FF10ADFF10
                </div>
                <div class="offset-11 offset-background">
                     GET /category.screen?
                </div>
                <div class="offset-12 offset-background">
                     category_id
                </div>
                <div class="offset-13 offset-background">
                     &product_id=FI-SW-01
                </div>
                <div class="offset-14 offset-background">
                     JSESSIONID
                </div>
            </div>

        </div>
        <div class="error-container fixed-width">
            <div class="error-image" data-role="error-image">
                <svg width="147px" height="391px" viewBox="339 122 147 391" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <defs></defs>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" transform="translate(341.964620, 124.258095)">
                        <path d="M30.8324637,383.060345 C30.8324637,385.005323 48.2226765,386.583023 69.673423,386.583023 C91.1241695,386.583023 108.514382,385.005323 108.514382,383.060345 C108.514382,381.115367 91.1241695,379.537667 69.673423,379.537667 C48.2226765,379.537667 30.8324637,381.115367 30.8324637,383.060345" id="Fill-1" fill="#221F20" transform="translate(69.673423, 383.060345) scale(1, -1) translate(-69.673423, -383.060345) "></path>
                        <path d="M89.4503057,375.876595 C93.0743835,375.820647 93.4669839,373.36376 97.0167859,374.096871 C99.9752757,374.706511 102.932801,375.317116 105.890326,375.92772 C106.671669,376.088812 107.48002,376.261479 108.118599,376.738966 C109.023412,377.4142 109.417942,378.570779 109.648486,379.677199 C109.934014,381.051782 109.923403,382.739867 108.777434,383.551113 C108.160077,383.98905 107.361372,384.049822 106.60511,384.089371 C98.0363893,384.546601 89.4281194,384.275543 80.9047361,383.281019 C76.2764888,382.740832 73.759795,384.286153 71.2170564,380.382336 C70.8070928,379.752439 72.4604517,375.456021 73.4868075,375.442516 C73.4868075,375.442516 85.8262279,375.932543 89.4503057,375.876595" id="Fill-3" fill="#FEFEFE"></path>
                        <path d="M89.4503057,375.876595 C93.0743835,375.820647 93.4669839,373.36376 97.0167859,374.096871 C99.9752757,374.706511 102.932801,375.317116 105.890326,375.92772 C106.671669,376.088812 107.48002,376.261479 108.118599,376.738966 C109.023412,377.4142 109.417942,378.570779 109.648486,379.677199 C109.934014,381.051782 109.923403,382.739867 108.777434,383.551113 C108.160077,383.98905 107.361372,384.049822 106.60511,384.089371 C98.0363893,384.546601 89.4281194,384.275543 80.9047361,383.281019 C76.2764888,382.740832 73.759795,384.286153 71.2170564,380.382336 C70.8070928,379.752439 72.4604517,375.456021 73.4868075,375.442516 C73.4868075,375.442516 85.8262279,375.932543 89.4503057,375.876595 L89.4503057,375.876595 Z" id="Stroke-5" stroke="#221F20" stroke-width="3"></path>
                        <path d="M37.0462571,42.0013176 C23.7875536,63.0493285 4.58389644,87.1117772 6.57487235,123.008185 C8.75105532,119.12366 14.8715699,108.592902 17.0477529,104.708377 C21.1049451,114.261975 9.99155679,131.871115 11.9275494,142.068114 C13.9802609,139.585182 17.7094823,138.007064 18.3943626,134.859508 C19.6396871,139.418303 16.2307197,142.834023 15.775419,147.538475 C15.3201183,152.241962 15.8043576,157.575347 19.345478,160.704575 C20.152865,155.177301 22.8354736,149.940379 26.8482932,146.054889 C26.9071351,148.768365 26.9659769,151.481842 27.0248187,154.195318 C27.039288,154.867658 27.0643681,155.577619 27.4251361,156.14578 C28.2045491,157.374706 30.1849142,157.223261 31.2411732,156.22295 C32.2974322,155.222639 37.7349958,151.365123 38.0591082,149.947131 L36.9922383,136.540841 C32.7286174,107.636964 35.6890366,71.1858991 37.0462571,42.0013176" id="Fill-7" fill="#FEFEFE"></path>
                        <path d="M37.0462571,42.0013176 C23.7875536,63.0493285 4.58389644,87.1117772 6.57487235,123.008185 C8.75105532,119.12366 14.8715699,108.592902 17.0477529,104.708377 C21.1049451,114.261975 9.99155679,131.871115 11.9275494,142.068114 C13.9802609,139.585182 17.7094823,138.007064 18.3943626,134.859508 C19.6396871,139.418303 16.2307197,142.834023 15.775419,147.538475 C15.3201183,152.241962 15.8043576,157.575347 19.345478,160.704575 C20.152865,155.177301 22.8354736,149.940379 26.8482932,146.054889 C26.9071351,148.768365 26.9659769,151.481842 27.0248187,154.195318 C27.039288,154.867658 27.0643681,155.577619 27.4251361,156.14578 C28.2045491,157.374706 30.1849142,157.223261 31.2411732,156.22295 C32.2974322,155.222639 37.7349958,151.365123 38.0591082,149.947131 L36.9922383,136.540841 C32.7286174,107.636964 35.6890366,71.1858991 37.0462571,42.0013176 L37.0462571,42.0013176 Z" id="Stroke-9" stroke="#221F20" stroke-width="3"></path>
                        <path d="M58.5937224,263.034514 C32.6174674,261.863465 1.38692667,290.626508 15.5272929,328.829323 C18.5648816,320.937766 21.9015026,312.634316 28.619117,307.497714 C24.4259134,321.005289 23.0387897,335.377164 24.5715711,349.437467 C26.9040225,341.937546 29.8856633,334.638265 33.4711562,327.650557 C32.0936787,336.756571 32.4486589,346.122068 34.5119813,355.097858 C37.8428146,349.067053 39.8048519,342.284809 40.2099923,335.407067 C39.1460163,339.422781 38.0743234,343.51277 38.2489196,347.663531 C38.4235159,351.814291 40.0392545,356.109744 43.4057787,358.543481 C47.7677909,357.157322 49.6979957,352.055446 50.2053859,347.506297 C51.0610039,339.842391 49.5822413,332.135076 49.1655254,324.435478 C48.8500946,318.611102 49.194464,312.480941 51.5761111,307.07521 C53.0789892,303.664313 53.7127446,303.117374 53.5275376,299.54635 L58.5937224,263.034514 Z" id="Fill-11" fill="#FEFEFE"></path>
                        <path d="M58.138544,262.900577 C32.162289,261.729528 0.931748236,290.492571 15.0721145,328.695386 C18.1097032,320.803829 21.4463242,312.500379 28.1639386,307.363777 C23.970735,320.871352 22.5836113,335.243227 24.1163926,349.30353 C26.4488441,341.803609 29.4304848,334.504328 33.0159778,327.51662 C31.6385003,336.622634 31.9934805,345.988131 34.0568029,354.963921 C37.3876361,348.933116 39.3496734,342.150872 39.7548139,335.27313 C38.6908379,339.288844 37.6191449,343.378833 37.7937412,347.529593 C37.9683374,351.680354 39.5840761,355.975807 42.9506003,358.409544 C47.3126124,357.023385 49.2428173,351.921509 49.7502075,347.37236 C50.6058255,339.708454 49.1270629,332.001139 48.710347,324.301541 C48.3949162,318.477165 48.7392856,312.347004 51.1209326,306.941273 C52.6238108,303.530376 53.2575662,302.983437 53.0723591,299.412413 L58.138544,262.900577 L58.138544,262.900577 Z" id="Stroke-13" stroke="#221F20" stroke-width="3"></path>
                        <path d="M139.249301,120.406798 C138.507508,119.327388 137.345141,111.607533 127.666143,117.233198 C126.676443,117.809076 125.323081,117.343164 124.291902,116.846385 C123.342716,116.39012 122.661694,115.530643 122.027938,114.689494 C112.980766,102.684797 113.882686,95.8832608 110.867284,81.1573701 C109.323892,73.618864 108.631294,65.8845399 106.354791,58.5341347 C104.046455,51.0824443 100.171576,46.0365165 96.3266002,39.2484848 C95.9012027,38.4970457 95.4709821,37.7417482 95.0311154,36.9883799 C96.3044139,33.7028838 100.254533,26.03126 101.083142,23.4721228 C101.644551,21.7367713 102.209818,19.987915 102.420105,18.1753938 C102.748076,15.3442338 102.172198,12.4146825 100.797614,9.91728104 C99.4413585,10.2741905 98.084138,10.6310999 96.7278821,10.9880094 C96.1404285,11.1423486 95.542364,11.3015109 95.0272569,11.623694 C94.5324068,11.9343017 94.1388418,12.3799562 93.7578168,12.8227168 C90.7173342,16.3580495 86.7807195,21.1329191 84.2341225,25.1688896 C80.1499209,23.055407 75.3740867,22.4833872 70.7448748,22.3078264 C62.6314551,22.0001126 45.9242347,25.6232257 45.9242347,25.6232257 L45.1525386,26.9553661 C44.9875886,23.5444694 42.8007948,20.4769774 40.2715609,18.1358444 C37.6053509,15.6683461 34.474194,13.7130612 32.0076604,11.0458866 C30.1073587,8.99028111 28.6343838,6.54496913 26.5556275,4.66974763 C24.4768712,2.79452613 21.4836549,1.54148461 18.8685698,2.54083104 C16.4599134,15.9268643 23.4244706,30.4781587 35.3597153,36.9989907 C36.5269056,37.6366046 35.5564978,36.4703789 38.4831552,39.3980009 C23.3974613,69.8221192 34.0970275,136.359685 34.0970275,136.359685 C35.3693615,144.98146 41.1127096,163.303454 47.4772731,169.25709 C49.9274082,171.548062 54.6366836,174.939667 57.7417957,176.210071 C65.8706494,179.533188 69.4098406,169.476058 77.9795257,167.556464 C76.5123385,158.229552 76.1207027,148.734797 76.8142646,139.31914 C83.6582442,141.409472 89.1363219,147.451852 90.5475611,154.467534 C90.9372676,156.407385 91.0674913,158.481318 92.1488305,160.138536 C94.1320894,163.176124 98.3899226,163.575477 102.007248,163.296702 C107.291437,162.889632 112.483022,161.71376 117.652422,160.540782 C125.060704,158.859449 133.481838,156.382305 136.557047,149.435111 C137.895939,146.410062 129.877052,132.648792 132.926216,131.364882 C134.628771,130.64817 132.955155,130.901865 134.759959,130.503477 C137.441603,129.912164 141.266322,123.340208 139.249301,120.406798" id="Fill-15" fill="#FEFEFE"></path>
                        <path d="M139.249301,120.406798 C138.507508,119.327388 137.345141,111.607533 127.666143,117.233198 C126.676443,117.809076 125.323081,117.343164 124.291902,116.846385 C123.342716,116.39012 122.661694,115.530643 122.027938,114.689494 C112.980766,102.684797 113.882686,95.8832608 110.867284,81.1573701 C109.323892,73.618864 108.631294,65.8845399 106.354791,58.5341347 C104.046455,51.0824443 100.171576,46.0365165 96.3266002,39.2484848 C95.9012027,38.4970457 95.4709821,37.7417482 95.0311154,36.9883799 C96.3044139,33.7028838 100.254533,26.03126 101.083142,23.4721228 C101.644551,21.7367713 102.209818,19.987915 102.420105,18.1753938 C102.748076,15.3442338 102.172198,12.4146825 100.797614,9.91728104 C99.4413585,10.2741905 98.084138,10.6310999 96.7278821,10.9880094 C96.1404285,11.1423486 95.542364,11.3015109 95.0272569,11.623694 C94.5324068,11.9343017 94.1388418,12.3799562 93.7578168,12.8227168 C90.7173342,16.3580495 86.7807195,21.1329191 84.2341225,25.1688896 C80.1499209,23.055407 75.3740867,22.4833872 70.7448748,22.3078264 C62.6314551,22.0001126 45.9242347,25.6232257 45.9242347,25.6232257 L45.1525386,26.9553661 C44.9875886,23.5444694 42.8007948,20.4769774 40.2715609,18.1358444 C37.6053509,15.6683461 34.474194,13.7130612 32.0076604,11.0458866 C30.1073587,8.99028111 28.6343838,6.54496913 26.5556275,4.66974763 C24.4768712,2.79452613 21.4836549,1.54148461 18.8685698,2.54083104 C16.4599134,15.9268643 23.4244706,30.4781587 35.3597153,36.9989907 C36.5269056,37.6366046 35.5564978,36.4703789 38.4831552,39.3980009 C23.3974613,69.8221192 34.0970275,136.359685 34.0970275,136.359685 C35.3693615,144.98146 41.1127096,163.303454 47.4772731,169.25709 C49.9274082,171.548062 54.6366836,174.939667 57.7417957,176.210071 C65.8706494,179.533188 69.4098406,169.476058 77.9795257,167.556464 C76.5123385,158.229552 76.1207027,148.734797 76.8142646,139.31914 C83.6582442,141.409472 89.1363219,147.451852 90.5475611,154.467534 C90.9372676,156.407385 91.0674913,158.481318 92.1488305,160.138536 C94.1320894,163.176124 98.3899226,163.575477 102.007248,163.296702 C107.291437,162.889632 112.483022,161.71376 117.652422,160.540782 C125.060704,158.859449 133.481838,156.382305 136.557047,149.435111 C137.895939,146.410062 129.877052,132.648792 132.926216,131.364882 C134.628771,130.64817 132.955155,130.901865 134.759959,130.503477 C137.441603,129.912164 141.266322,123.340208 139.249301,120.406798 L139.249301,120.406798 Z" id="Stroke-17" stroke="#221F20" stroke-width="3"></path>
                        <g id="Group-22" transform="translate(46.000000, 89.000000)">
                            <path d="M1.87710814,0.066386904 C0.667474515,7.89138525 -0.527689803,15.9594679 1.34849631,23.6513486 C3.36069387,31.8998152 9.01047386,39.190414 16.4949613,43.197446 C21.2698309,45.7536893 26.7324746,47.036634 31.1022037,50.2362789" id="Fill-19" fill="#FEFEFE"></path>
                            <path d="M1.87710814,0.066386904 C0.667474515,7.89138525 -0.527689803,15.9594679 1.34849631,23.6513486 C3.36069387,31.8998152 9.01047386,39.190414 16.4949613,43.197446 C21.2698309,45.7536893 26.7324746,47.036634 31.1022037,50.2362789" id="Stroke-21" stroke="#221F20" stroke-width="3"></path>
                        </g>
                        <path d="M54.9223076,280.510489 C50.6992007,296.279134 53.2091423,313.044232 56.9914177,328.924772 C60.7736932,344.805313 62.2090479,360.544055 63.0617721,376.846135 C63.1370125,378.271844 63.3106441,379.937742 64.5289593,380.682429 C65.225415,381.107827 66.0916439,381.104933 66.9067479,381.08564 C73.9484747,380.917796 80.9834491,380.433557 87.9817681,379.635816 C88.956999,379.52392 90.0450905,379.343536 90.6257918,378.551583 C91.1042434,377.898536 91.0897741,377.019767 91.0608354,376.21045 C89.848308,342.142962 98.6138109,301.931808 96.4829651,267.909657 C85.4207017,268.35724 56.2091108,260.771468 52.8020726,269.907385 L54.9223076,280.510489 Z" id="Fill-23" fill="#FEFEFE"></path>
                        <path d="M54.9223076,280.510489 C50.6992007,296.279134 53.2091423,313.044232 56.9914177,328.924772 C60.7736932,344.805313 62.2090479,360.544055 63.0617721,376.846135 C63.1370125,378.271844 63.3106441,379.937742 64.5289593,380.682429 C65.225415,381.107827 66.0916439,381.104933 66.9067479,381.08564 C73.9484747,380.917796 80.9834491,380.433557 87.9817681,379.635816 C88.956999,379.52392 90.0450905,379.343536 90.6257918,378.551583 C91.1042434,377.898536 91.0897741,377.019767 91.0608354,376.21045 C89.848308,342.142962 98.6138109,301.931808 96.4829651,267.909657 C85.4207017,268.35724 56.2091108,260.771468 52.8020726,269.907385 L54.9223076,280.510489 L54.9223076,280.510489 Z" id="Stroke-25" stroke="#221F20" stroke-width="3"></path>
                        <path d="M77.5108167,377.86651 C81.1348945,377.810562 81.5274949,375.353675 85.0772969,376.086786 C88.0357868,376.696426 90.993312,377.30703 93.9508373,377.917635 C94.7321796,378.078727 95.5405312,378.251394 96.1791098,378.728881 C97.0839234,379.404115 97.478453,380.560694 97.7080326,381.667113 C97.9945248,383.041697 97.983914,384.729782 96.8379453,385.541028 C96.2205884,385.978965 95.421883,386.039736 94.6656208,386.079286 C86.0969004,386.536516 77.4886305,386.265457 68.9652472,385.270934 C64.3369999,384.730747 61.820306,386.276068 59.2775674,382.372251 C58.8676038,381.742354 60.5209627,377.445936 61.5473185,377.432431 C61.5473185,377.432431 73.886739,377.922458 77.5108167,377.86651" id="Fill-27" fill="#FEFEFE"></path>
                        <path d="M77.5108167,377.86651 C81.1348945,377.810562 81.5274949,375.353675 85.0772969,376.086786 C88.0357868,376.696426 90.993312,377.30703 93.9508373,377.917635 C94.7321796,378.078727 95.5405312,378.251394 96.1791098,378.728881 C97.0839234,379.404115 97.478453,380.560694 97.7080326,381.667113 C97.9945248,383.041697 97.983914,384.729782 96.8379453,385.541028 C96.2205884,385.978965 95.421883,386.039736 94.6656208,386.079286 C86.0969004,386.536516 77.4886305,386.265457 68.9652472,385.270934 C64.3369999,384.730747 61.820306,386.276068 59.2775674,382.372251 C58.8676038,381.742354 60.5209627,377.445936 61.5473185,377.432431 C61.5473185,377.432431 73.886739,377.922458 77.5108167,377.86651 L77.5108167,377.86651 Z" id="Stroke-29" stroke="#221F20" stroke-width="3"></path>
                        <path d="M109.792408,179.11869 C110.38372,176.096536 112.011998,173.487238 112.145116,170.368621 C112.354439,165.454846 110.921978,160.670331 111.432262,155.678422 C111.51329,154.888398 111.62808,154.08294 111.985954,153.373944 C112.709419,151.945342 114.334804,151.143742 115.93125,151.015448 C117.527696,150.886189 119.111602,151.32702 120.630879,151.833446 C126.782262,153.883264 132.542008,157.098342 137.51559,161.257784 C137.51559,161.257784 146.281093,167.848069 140.412344,170.933889 C134.54456,174.019708 126.038539,177.770151 123.668468,180.643755 C121.298396,183.518323 109.792408,179.11869 109.792408,179.11869" id="Fill-31" fill="#FEFEFE"></path>
                        <path d="M109.792408,179.11869 C110.38372,176.096536 112.011998,173.487238 112.145116,170.368621 C112.354439,165.454846 110.921978,160.670331 111.432262,155.678422 C111.51329,154.888398 111.62808,154.08294 111.985954,153.373944 C112.709419,151.945342 114.334804,151.143742 115.93125,151.015448 C117.527696,150.886189 119.111602,151.32702 120.630879,151.833446 C126.782262,153.883264 132.542008,157.098342 137.51559,161.257784 C137.51559,161.257784 146.281093,167.848069 140.412344,170.933889 C134.54456,174.019708 126.038539,177.770151 123.668468,180.643755 C121.298396,183.518323 109.792408,179.11869 109.792408,179.11869 L109.792408,179.11869 Z" id="Stroke-33" stroke="#221F20" stroke-width="3"></path>
                        <path d="M99.9977514,174.551118 C98.7263821,171.447935 90.6428656,163.369241 80.4410433,163.369241 C72.9623435,169.688468 44.3690742,166.426122 39.5942046,161.273122 L14.4590984,187.395034 L28.1094376,218.614 C28.1094376,218.614 37.6119103,205.731498 42.231476,201.112897 C38.5823181,222.720388 50.0333235,257.343497 52.101469,272.717613 C59.0515569,272.323083 68.5289495,268.24274 74.6890135,267.662039 C81.2156332,267.046611 87.6998096,272.240126 94.0788424,270.727601 C94.8129183,270.55397 95.5711097,270.36201 96.159528,269.890311 C97.2726996,268.998037 97.4608005,267.404485 97.5640149,265.980706 C97.8283208,262.321902 98.2681875,248.745838 98.3714019,232.492954 L93.8945999,201.149553 C93.8945999,201.149553 99.7392332,229.145722 101.380052,227.505868 C103.020871,225.865049 110.001827,200.028664 107.557479,190.802073 C105.015705,190.802073 106.005405,181.865832 99.9977514,174.551118 Z" id="Fill-35" fill="#221F20"></path>
                        <path d="M107.34343,174.551311 C103.883338,186.196205 107.359829,205.335232 102.55795,216.774662 C99.469236,224.130855 95.4950012,224.628599 96.5396848,232.537519 C96.6795547,233.591849 97.0007732,234.698268 97.8207003,235.374467 C98.4178001,235.866423 99.1972132,236.062241 99.9496169,236.241661 C103.863081,237.177342 108.734412,237.735857 111.218309,234.569009 C112.142415,233.391208 112.531157,231.891224 112.876491,230.433683 C115.310228,220.152762 114.14979,215.694288 118.103767,205.897606 C119.628832,202.119189 121.534921,198.470995 122.543914,194.52377 C123.597279,190.402913 123.635864,186.100707 123.668661,181.848662 C118.227239,179.41589 112.784852,176.984083 107.34343,174.551311" id="Fill-37" fill="#FEFEFE"></path>
                        <path d="M107.34343,174.551311 C103.883338,186.196205 107.359829,205.335232 102.55795,216.774662 C99.469236,224.130855 95.4950012,224.628599 96.5396848,232.537519 C96.6795547,233.591849 97.0007732,234.698268 97.8207003,235.374467 C98.4178001,235.866423 99.1972132,236.062241 99.9496169,236.241661 C103.863081,237.177342 108.734412,237.735857 111.218309,234.569009 C112.142415,233.391208 112.531157,231.891224 112.876491,230.433683 C115.310228,220.152762 114.14979,215.694288 118.103767,205.897606 C119.628832,202.119189 121.534921,198.470995 122.543914,194.52377 C123.597279,190.402913 123.635864,186.100707 123.668661,181.848662 C118.227239,179.41589 112.784852,176.984083 107.34343,174.551311 L107.34343,174.551311 Z" id="Stroke-39" stroke="#221F20" stroke-width="3"></path>
                        <path d="M111.870971,147.899918 C109.942695,147.924998 108.119563,148.725633 106.359132,149.512763 C105.477469,149.906328 104.566867,150.321114 103.927324,151.04458 C103.287781,151.768045 102.994537,152.893756 103.502891,153.714648 C104.820563,154.400493 106.245306,155.085373 107.721175,154.920423 C109.197044,154.755473 110.627576,153.355809 110.252338,151.91949" id="Fill-41" fill="#221F20"></path>
                        <path d="M84.9299029,19.3727768 C87.0655719,17.2371078 89.7587912,14.6895461 88.857836,11.8072612 C86.3855147,11.2709324 83.7752527,12.0677087 81.6424776,13.4297523 C79.5106672,14.7908312 77.7762802,16.6776282 76.0669734,18.5422388 C77.6335164,15.4284451 80.163715,12.9281498 82.2771976,10.1567962 C84.3916449,7.38544263 86.1665459,4.04978628 85.8048134,0.582941603 C83.2263838,0.0514359217 80.6151572,1.16653677 78.2749888,2.37038267 C70.4615659,6.38706082 63.3195186,11.7040469 57.2308364,18.0367779 C54.4392258,20.9412491 51.6784831,24.5556806 47.6955666,25.1576036 C47.6955666,25.1576036 71.9422578,32.3604219 84.9299029,19.3727768" id="Fill-43" fill="#FEFEFE"></path>
                        <path d="M84.9299029,19.3727768 C87.0655719,17.2371078 89.7587912,14.6895461 88.857836,11.8072612 C86.3855147,11.2709324 83.7752527,12.0677087 81.6424776,13.4297523 C79.5106672,14.7908312 77.7762802,16.6776282 76.0669734,18.5422388 C77.6335164,15.4284451 80.163715,12.9281498 82.2771976,10.1567962 C84.3916449,7.38544263 86.1665459,4.04978628 85.8048134,0.582941603 C83.2263838,0.0514359217 80.6151572,1.16653677 78.2749888,2.37038267 C70.4615659,6.38706082 63.3195186,11.7040469 57.2308364,18.0367779 C54.4392258,20.9412491 51.6784831,24.5556806 47.6955666,25.1576036 C47.6955666,25.1576036 71.9422578,32.3604219 84.9299029,19.3727768 L84.9299029,19.3727768 Z" id="Stroke-45" stroke="#221F20" stroke-width="3"></path>
                        <path d="M52.8252235,262.002323 C51.95803,255.558661 49.9275046,252.727501 48.9696369,240.982286 C48.7825006,238.682632 46.1384768,234.656307 45.0079421,235.091351 C37.4356742,238.008362 25.6470518,224.080213 18.1374842,221.004039 C18.2300878,220.478321 25.9576595,213.691254 25.9576595,213.691254 L18.2107954,195.974076 C14.661958,199.82484 2.50388609,216.563893 0.728985088,219.314989 C-2.38673787,224.143877 21.2194455,241.884206 28.7232253,244.992212 C33.0022802,246.764219 37.6536783,248.88156 39.5964232,253.086339 C41.2989777,256.772153 42.0465583,263.323853 44.7320607,266.368194 C46.8436141,268.762381 50.38377,269.091316 53.4570496,268.010942 L52.8252235,262.002323 Z" id="Fill-47" fill="#FEFEFE"></path>
                        <path d="M52.8252235,262.002323 C51.95803,255.558661 49.9275046,252.727501 48.9696369,240.982286 C48.7825006,238.682632 46.1384768,234.656307 45.0079421,235.091351 C37.4356742,238.008362 25.6470518,224.080213 18.1374842,221.004039 C18.2300878,220.478321 25.9576595,213.691254 25.9576595,213.691254 L18.2107954,195.974076 C14.661958,199.82484 2.50388609,216.563893 0.728985088,219.314989 C-2.38673787,224.143877 21.2194455,241.884206 28.7232253,244.992212 C33.0022802,246.764219 37.6536783,248.88156 39.5964232,253.086339 C41.2989777,256.772153 42.0465583,263.323853 44.7320607,266.368194 C46.8436141,268.762381 50.38377,269.091316 53.4570496,268.010942 L52.8252235,262.002323 L52.8252235,262.002323 Z" id="Stroke-49" stroke="#221F20" stroke-width="3"></path>
                        <g id="Group-58" transform="translate(84.000000, 118.000000)">
                            <path d="M13.5973907,8.0724941 C14.2716602,7.27378864 14.3362897,4.44455786 13.8674843,3.51080559 C10.4903493,-3.21549045 -5.96510516,1.74458616 3.09653617,14.199761 C4.5270678,16.1656568 7.18073773,17.6704642 9.23923705,16.3769086" id="Fill-55" fill="#FEFEFE"></path>
                            <path d="M13.5973907,8.0724941 C14.2716602,7.27378864 14.3362897,4.44455786 13.8674843,3.51080559 C10.4903493,-3.21549045 -5.96510516,1.74458616 3.09653617,14.199761 C4.5270678,16.1656568 7.18073773,17.6704642 9.23923705,16.3769086" id="Stroke-57" stroke="#221F20" stroke-width="3"></path>
                        </g>
                        <path d="M80.2077981,288.999243 C78.5390053,328.572783 80.1933288,344.413774 80.1856118,372.121522 C80.1856118,373.151736 80.1692133,378.040431 80.5589198,377.086422" id="Stroke-59" stroke="#221F20" stroke-width="2.438"></path>
                        <g id="Group-64" transform="translate(36.000000, 235.000000)">
                            <path d="M4.2135872,0.144115827 C2.60556547,4.88040058 1.51458012,9.79224618 0.96474666,14.7638982" id="Fill-61" fill="#FEFEFE"></path>
                            <path d="M4.2135872,0.144115827 C2.60556547,4.88040058 1.51458012,9.79224618 0.96474666,14.7638982" id="Stroke-63" stroke="#221F20" stroke-width="3"></path>
                        </g>
                        <g id="Group-68" transform="translate(128.000000, 120.000000)">
                            <path d="M0.205751474,2.49172778 C0.965872122,1.77887352 1.85428724,1.20299531 2.8160135,0.801713344 C3.19607382,0.642551026 3.60121427,0.50846883 4.01214243,0.540301294 C4.73271366,0.59528464 5.31920269,1.14222424 5.74363553,1.72581941 C6.29057514,2.4782231 6.68028166,3.48046339 6.2982921,4.32836447 C5.9433119,5.11549448 4.90923914,5.51291797 4.11921527,5.16565473" id="Fill-65" fill="#FEFEFE"></path>
                            <path d="M0.205751474,2.49172778 C0.965872122,1.77887352 1.85428724,1.20299531 2.8160135,0.801713344 C3.19607382,0.642551026 3.60121427,0.50846883 4.01214243,0.540301294 C4.73271366,0.59528464 5.31920269,1.14222424 5.74363553,1.72581941 C6.29057514,2.4782231 6.68028166,3.48046339 6.2982921,4.32836447 C5.9433119,5.11549448 4.90923914,5.51291797 4.11921527,5.16565473" id="Stroke-67" stroke="#221F20" stroke-width="2.438"></path>
                        </g>
                        <g id="Group-72" transform="translate(87.745050, 122.471374)">
                            <path d="M5.93791202,2.93910102 C5.36106919,1.76998144 4.62699329,0.471602773 3.35562398,0.184145979 C2.54437847,0.0008681581 -1.83017374,3.75131115 3.54276028,8.25898093" id="Fill-69" fill="#FEFEFE"></path>
                            <path d="M5.93791202,2.93910102 C5.36106919,1.76998144 4.62699329,0.471602773 3.35562398,0.184145979 C2.54437847,0.0008681581 -1.83017374,3.75131115 3.54276028,8.25898093" id="Stroke-71" stroke="#221F20" stroke-width="2.438"></path>
                        </g>
                        <path d="M62.8175303,64.6838773 C61.0329831,68.2066699 62.1895626,75.0130294 65.4760233,76.8824632 C70.3049116,79.6316305 68.6322603,68.8018405 67.5624966,66.6362684 C67.0654702,64.4659651 64.2056186,61.9443561 62.8175303,64.6838773 Z" id="Fill-73" fill="#221F20"></path>
                        <path d="M96.7614704,62.2685885 C96.2259927,61.8496931 95.9065575,61.6524092 94.7798257,61.8601301 C94.1875405,61.969322 93.8302407,62.4366072 93.6875925,62.8369191 C93.3515715,63.7798905 93.109785,64.7979918 93.1956362,65.795409 C93.2554427,66.493794 93.4994916,67.1728865 93.8236039,67.8172528 C94.3088078,68.7828375 94.9907942,69.6944035 95.936122,70.3725314 C96.8814497,71.0496948 97.1023477,71.4162504 99.3441248,71.4162504 C101.585902,71.4162504 99.8751631,69.0516668 99.9518355,67.8095358 C99.9824605,67.3133957 99.9376925,66.8655986 99.8274406,66.4431129 C99.5624389,65.4276254 98.9191167,64.5583702 98.0350747,63.5155256 C97.5933633,62.9944685 97.2969482,62.6874839 96.7614704,62.2685885 Z" id="Fill-75" fill="#221F20"></path>
                        <path d="M50.6418058,199.985931 C50.783605,200.045738 50.984246,200.081429 51.1839223,200.049596 C51.4800607,200.003295 51.6276476,199.819052 51.5919566,199.592366 C51.5591596,199.383044 51.4202543,199.282723 51.0990358,199.214235 C50.7122231,199.142853 50.4556342,198.989479 50.4054739,198.673083 C50.3495259,198.323891 50.5974333,198.018106 51.0334416,197.948654 C51.2630212,197.911998 51.4376174,197.939008 51.5466195,197.979522 L51.5041762,198.228394 C51.4250774,198.20042 51.2649504,198.157012 51.0614156,198.189809 C50.755631,198.23804 50.6678506,198.439645 50.6929307,198.59302 C50.7257278,198.802343 50.8791024,198.884335 51.2070732,198.954752 C51.6093198,199.040604 51.8321471,199.193014 51.8842365,199.521949 C51.9392199,199.868248 51.7308619,200.207794 51.2022501,200.292681 C50.9861752,200.327407 50.7401971,200.301362 50.6070795,200.240591 L50.6418058,199.985931 Z" id="Fill-77" fill="#FEFEFE"></path>
                        <path d="M53.2760869,198.962855 C53.252936,198.775719 53.1313939,198.495979 52.8005292,198.542281 C52.5034262,198.58376 52.4117873,198.877004 52.417575,199.083433 L53.2760869,198.962855 Z M52.4436197,199.294685 C52.5063201,199.691143 52.783166,199.819438 53.0773752,199.777959 C53.2876623,199.748056 53.4092045,199.694037 53.5133834,199.631337 L53.5934469,199.834872 C53.4960203,199.895643 53.3262471,199.974742 53.0696582,200.010433 C52.5719142,200.08085 52.2285095,199.795322 52.1590568,199.307225 C52.0905688,198.820092 52.3240068,198.395659 52.7947415,198.3291 C53.3223887,198.254824 53.5288174,198.699514 53.570296,198.996617 C53.5789776,199.056423 53.578013,199.10369 53.5789776,199.134558 L52.4436197,199.294685 Z" id="Fill-79" fill="#FEFEFE"></path>
                        <path d="M54.9703457,198.738678 C54.9500886,198.550577 54.8314404,198.267943 54.499611,198.310386 C54.2015434,198.348971 54.1050814,198.640286 54.1070107,198.84768 L54.9703457,198.738678 Z M54.1311262,199.059896 C54.1890034,199.458284 54.4648847,199.590437 54.7600585,199.552817 C54.9713103,199.525808 55.093817,199.472753 55.1989606,199.411982 L55.2761302,199.616482 C55.177739,199.677253 55.0070012,199.753458 54.7494477,199.786255 C54.2488098,199.84992 53.9082989,199.559569 53.8455986,199.068578 C53.7838629,198.578551 54.0230887,198.156047 54.4967172,198.096241 C55.0262936,198.028717 55.2269346,198.477266 55.2645548,198.776298 C55.2722718,198.836104 55.2713071,198.884335 55.2722718,198.915203 L54.1311262,199.059896 Z" id="Fill-81" fill="#FEFEFE"></path>
                        <path d="M56.5496217,197.416087 L56.6026758,197.881998 L57.026144,197.834732 L57.0512242,198.059489 L56.6287206,198.106755 L56.7290411,198.983595 C56.7512273,199.184236 56.8216446,199.292273 56.98563,199.272981 C57.0627996,199.264299 57.1187476,199.247901 57.1544385,199.233431 L57.1930233,199.453365 C57.1390046,199.484232 57.0502595,199.510277 56.9364344,199.523782 C56.7984937,199.539216 56.6827393,199.508348 56.6036404,199.436001 C56.5091077,199.358832 56.4628059,199.217033 56.4406196,199.026038 L56.3402991,198.139552 L56.0875687,198.168491 L56.0624886,197.943734 L56.3142544,197.91576 L56.2698819,197.526054 L56.5496217,197.416087 Z" id="Fill-83" fill="#FEFEFE"></path>
                        <path d="M57.3013502,197.037377 L57.5965239,197.006509 L57.7035968,198.01936 L57.7093845,198.01936 C57.7479693,197.929651 57.8145281,197.848623 57.8994146,197.788816 C57.9814073,197.72901 58.0817278,197.684637 58.1926591,197.673062 C58.4106633,197.649911 58.7733605,197.747337 58.8331669,198.307782 L58.934452,199.274331 L58.6392783,199.305199 L58.540887,198.372411 C58.5138776,198.110999 58.3933001,197.899747 58.1145249,197.928686 C57.9235301,197.948943 57.7855895,198.099424 57.7489339,198.265338 C57.7373585,198.307782 57.7383231,198.352154 57.7441108,198.409067 L57.8473251,199.389121 L57.5521514,199.419989 L57.3013502,197.037377 Z" id="Fill-85" fill="#FEFEFE"></path>
                        <path d="M60.3378778,198.14997 C60.3224439,197.961869 60.2124772,197.677306 59.8796833,197.711068 C59.5816156,197.741936 59.4784013,198.029392 59.4755074,198.236786 L60.3378778,198.14997 Z M59.4938352,198.449002 C59.540137,198.84739 59.8121599,198.986296 60.1073336,198.956392 C60.3185854,198.934206 60.4420568,198.88501 60.548165,198.827133 L60.6195469,199.033562 C60.520191,199.090475 60.3484886,199.162821 60.0899704,199.188866 C59.5902972,199.239026 59.2575033,198.939994 59.2092723,198.449967 C59.159112,197.95994 59.4089486,197.545153 59.8816125,197.497887 C60.4121536,197.443868 60.6002545,197.896275 60.6301577,198.194342 C60.63691,198.255114 60.6349808,198.303345 60.6340162,198.333248 L59.4938352,198.449002 Z" id="Fill-87" fill="#FEFEFE"></path>
                        <path d="M61.8277336,198.991119 L61.6994391,197.591455 L61.4708241,197.612677 L61.4496025,197.38792 L61.6782175,197.366698 L61.6714651,197.289529 C61.6502435,197.061878 61.6811113,196.848697 61.8074766,196.704969 C61.907797,196.587285 62.0515254,196.530373 62.1894661,196.517833 C62.2926805,196.508186 62.3862486,196.52362 62.4450904,196.540984 L62.425798,196.773457 C62.3804609,196.758023 62.3177606,196.746448 62.2338386,196.754165 C61.9830374,196.777316 61.9396295,197.004001 61.9618158,197.252873 L61.9695327,197.340654 L62.3630977,197.303998 L62.3833548,197.528755 L61.9907544,197.564446 L62.1200135,198.964109 L61.8277336,198.991119 Z" id="Fill-89" fill="#FEFEFE"></path>
                        <path d="M62.8412599,198.08071 C62.8721278,198.438584 63.1017074,198.689385 63.3910934,198.664305 C63.6746917,198.64019 63.8637572,198.354662 63.8319248,197.987142 C63.8078093,197.711261 63.6390008,197.372679 63.287879,197.402582 C62.9377219,197.43345 62.8142506,197.771067 62.8412599,198.08071 M64.1338509,197.950486 C64.186905,198.554339 63.7914107,198.853371 63.3978457,198.888097 C62.9560497,198.926682 62.5875648,198.632473 62.5422277,198.117366 C62.4949613,197.571391 62.8238968,197.219304 63.275339,197.179755 C63.7441444,197.139241 64.090443,197.451778 64.1338509,197.950486" id="Fill-91" fill="#FEFEFE"></path>
                        <path d="M64.4837186,197.629461 C64.46732,197.437502 64.4509215,197.272551 64.4277706,197.121106 L64.6872534,197.099884 L64.723909,197.419174 L64.7374137,197.418209 C64.7933616,197.192488 64.9612055,197.040078 65.1599173,197.023679 C65.193679,197.020786 65.2168299,197.02175 65.2448039,197.026573 L65.2679547,197.306313 C65.2370869,197.302455 65.2062191,197.30149 65.165705,197.304384 C64.9573471,197.321747 64.8223003,197.492485 64.800114,197.718206 C64.7962555,197.759685 64.7933616,197.806951 64.7981847,197.858076 L64.8695666,198.727199 L64.5763221,198.752279 L64.4837186,197.629461 Z" id="Fill-93" fill="#FEFEFE"></path>
                        <path d="M66.5867834,197.610651 C66.5752079,197.421585 66.4710289,197.135093 66.1372704,197.161138 C65.8372735,197.184289 65.7273068,197.470781 65.7205545,197.679139 L66.5867834,197.610651 Z M65.7340592,197.891355 C65.7716794,198.292637 66.041773,198.436366 66.3379114,198.414179 C66.5501278,198.396816 66.6755284,198.34955 66.7826012,198.293602 L66.8501246,198.50196 C66.7488395,198.557908 66.5752079,198.625431 66.3157251,198.645688 C65.813158,198.685238 65.4871164,198.378488 65.4485316,197.886532 C65.4099468,197.394576 65.6694296,196.984612 66.1449873,196.946992 C66.6774576,196.905514 66.8549478,197.362743 66.8790633,197.66274 C66.8838864,197.723511 66.8809925,197.770778 66.8800279,197.801646 L65.7340592,197.891355 Z" id="Fill-95" fill="#FEFEFE"></path>
                        <path d="M67.2597988,198.234664 C67.3514377,198.284824 67.5115647,198.334984 67.6591515,198.323409 C67.8752264,198.30701 67.96783,198.19222 67.9581838,198.057173 C67.947573,197.915374 67.8578633,197.843992 67.6331068,197.779363 C67.3311807,197.696406 67.1816646,197.545925 67.1671953,197.350107 C67.1469383,197.08773 67.3437208,196.855257 67.6938779,196.829212 C67.8597925,196.817637 68.0073794,196.853328 68.1028768,196.900594 L68.0449996,197.122457 C67.9774762,197.086766 67.855934,197.041428 67.7035241,197.052039 C67.5289278,197.065544 67.4382535,197.173581 67.4478997,197.295124 C67.4575459,197.43017 67.5597957,197.483225 67.7787644,197.548819 C68.0691151,197.635634 68.2244189,197.766823 68.2427467,198.008942 C68.2639683,198.295435 68.056575,198.514403 67.6687977,198.543342 C67.490343,198.555882 67.3215345,198.525014 67.2019216,198.466172 L67.2597988,198.234664 Z" id="Fill-97" fill="#FEFEFE"></path>
                        <path d="M68.8550876,196.31343 L68.8878846,196.782235 L69.3132821,196.752332 L69.328716,196.978053 L68.9033186,197.007956 L68.9650542,197.88769 C68.9795235,198.089295 69.0451177,198.200227 69.2100678,198.188651 C69.2872374,198.182863 69.3441499,198.169359 69.3798409,198.156819 L69.4097441,198.378681 C69.3537961,198.405691 69.2640865,198.428842 69.1492967,198.437523 C69.011356,198.446205 68.8965662,198.410514 68.8203612,198.334309 C68.7296869,198.253281 68.6901375,198.110517 68.6756682,197.918558 L68.6139325,197.028213 L68.3612021,197.045576 L68.3457681,196.819855 L68.5984986,196.802492 L68.5714892,196.411821 L68.8550876,196.31343 Z" id="Fill-99" fill="#FEFEFE"></path>
                        <path d="M71.2840975,197.422261 C70.9609497,197.43673 70.5963233,197.517758 70.617545,197.835118 C70.630085,198.027077 70.7641672,198.10907 70.9156126,198.099424 C71.127829,198.084955 71.2541942,197.942191 71.2918144,197.800392 C71.300496,197.769524 71.3043545,197.735762 71.3033899,197.704894 L71.2840975,197.422261 Z M71.3824887,198.251834 L71.3458331,198.047334 L71.3352223,198.048299 C71.2532296,198.182381 71.0853857,198.308746 70.8529123,198.32418 C70.5220476,198.345402 70.3387697,198.124504 70.3223712,197.888172 C70.2972911,197.493642 70.6339435,197.255381 71.2638404,197.216796 L71.2619112,197.183035 C71.2532296,197.047988 71.2001755,196.807798 70.8664169,196.829984 C70.7149716,196.83963 70.5596678,196.897507 70.4497011,196.9795 L70.3696376,196.788505 C70.4988967,196.692043 70.6898915,196.621626 70.8963202,196.608121 C71.3950288,196.575324 71.5387572,196.908118 71.5599788,197.235124 L71.5995282,197.844764 C71.6091744,197.986563 71.6246084,198.124504 71.6525823,198.234471 L71.3824887,198.251834 Z" id="Fill-101" fill="#FEFEFE"></path>
                        <path d="M72.0301346,197.01384 C72.0195238,196.845032 72.0079484,196.707091 71.9896206,196.573009 L72.2519973,196.55661 L72.285759,196.825739 L72.2925113,196.825739 C72.3638932,196.665612 72.5433125,196.501627 72.8134062,196.485229 C73.0391273,196.471724 73.397966,196.585549 73.4317277,197.145029 L73.4915341,198.119295 L73.1953957,198.136658 L73.1375185,197.196154 C73.12112,196.933777 73.0101887,196.720596 72.7304489,196.736994 C72.534631,196.749534 72.3918672,196.897121 72.3513531,197.064965 C72.3397777,197.10355 72.3359192,197.154675 72.3397777,197.204835 L72.3995842,198.185854 L72.1024812,198.203217 L72.0301346,197.01384 Z" id="Fill-103" fill="#FEFEFE"></path>
                        <path d="M75.0120648,197.058116 C75.0101356,197.021461 75.0043478,196.971301 74.9918078,196.934645 C74.9368244,196.748473 74.7670513,196.601851 74.544224,196.615356 C74.2374749,196.632719 74.0705956,196.912459 74.0908526,197.273227 C74.110145,197.603127 74.2876351,197.867433 74.607889,197.849105 C74.8066007,197.837529 74.981197,197.69573 75.021711,197.470009 C75.0303926,197.429495 75.0313572,197.388981 75.0284633,197.341715 L75.0120648,197.058116 Z M75.2281397,195.616009 L75.3400356,197.587693 C75.3477526,197.732386 75.3602927,197.897336 75.3766912,198.008267 L75.1114207,198.022737 L75.0815174,197.741067 L75.0747651,197.741067 C74.993737,197.928204 74.8027422,198.07772 74.5365071,198.093154 C74.1419775,198.11534 73.8197943,197.798945 73.7918204,197.30313 C73.7580587,196.761013 74.0754187,196.407962 74.4738068,196.385776 C74.7226788,196.371307 74.8982396,196.479344 74.9802323,196.606674 L74.9869847,196.606674 L74.9320013,195.632408 L75.2281397,195.616009 Z" id="Fill-105" fill="#FEFEFE"></path>
                        <path d="M76.835872,195.820798 L76.8599875,196.288639 L77.285385,196.266453 L77.2969605,196.492174 L76.8725276,196.515325 L76.9178648,197.394094 C76.9294402,197.596664 76.9921405,197.70856 77.1570905,197.699878 C77.2352248,197.69602 77.2921374,197.682515 77.3287929,197.669975 L77.353873,197.891838 C77.2979251,197.918847 77.2072508,197.941033 77.092461,197.946821 C76.9545203,197.953573 76.8406951,197.915953 76.7664194,197.838783 C76.6767097,197.754862 76.6390895,197.612098 76.6294433,197.420138 L76.582177,196.529794 L76.3294465,196.543299 L76.317871,196.317578 L76.5706015,196.304073 L76.5503445,195.913402 L76.835872,195.820798 Z" id="Fill-107" fill="#FEFEFE"></path>
                        <path d="M77.559723,195.486847 L77.856826,195.471413 L77.9098801,196.489087 L77.9166324,196.489087 C77.9590757,196.402271 78.029493,196.324137 78.118238,196.269154 C78.2031246,196.213206 78.3053743,196.174621 78.4172703,196.168833 C78.636239,196.157258 78.9931485,196.273012 79.0230517,196.83635 L79.0741766,197.806758 L78.7770736,197.822192 L78.7278779,196.885546 C78.7143733,196.623169 78.6044066,196.405165 78.3246667,196.419634 C78.1327073,196.430245 77.9880143,196.573009 77.9426772,196.736994 C77.9282079,196.778473 77.9272432,196.822846 77.9301371,196.879758 L77.981262,197.864635 L77.6851236,197.880069 L77.559723,195.486847 Z" id="Fill-109" fill="#FEFEFE"></path>
                        <path d="M80.5440647,196.762364 C80.538277,196.573298 80.4437442,196.283912 80.1099856,196.300311 C79.8099888,196.31478 79.6913405,196.597414 79.6778358,196.803843 L80.5440647,196.762364 Z M79.6845882,197.017024 C79.7106329,197.417341 79.9749388,197.569751 80.2710772,197.556246 C80.4842582,197.545635 80.6096588,197.503192 80.7186609,197.450138 L80.779432,197.660425 C80.6771823,197.71155 80.5016214,197.77425 80.2421386,197.78679 C79.7395715,197.810906 79.4241407,197.495475 79.4000252,197.003519 C79.3768743,196.511563 79.6479326,196.109316 80.1225257,196.08713 C80.6559606,196.061085 80.819946,196.523138 80.8344153,196.82217 C80.8373092,196.882941 80.8324861,196.931172 80.8305569,196.96204 L79.6845882,197.017024 Z" id="Fill-111" fill="#FEFEFE"></path>
                        <path d="M82.2293525,195.561701 L82.2496095,196.029542 L82.6740423,196.011214 L82.6846532,196.2379 L82.2602203,196.256228 L82.2978405,197.135961 C82.3074867,197.337567 82.3692224,197.450427 82.5341724,197.44271 C82.6123067,197.439817 82.6692192,197.427277 82.7058748,197.414736 L82.7290257,197.636599 C82.6721131,197.662644 82.5824034,197.683865 82.4676136,197.688689 C82.329673,197.694476 82.2158478,197.655892 82.141572,197.577757 C82.0537916,197.493835 82.0171361,197.350107 82.0084545,197.158148 L81.9698697,196.268768 L81.7171392,196.279379 L81.707493,196.053657 L81.9602235,196.043047 L81.9428603,195.651411 L82.2293525,195.561701 Z" id="Fill-113" fill="#FEFEFE"></path>
                        <path d="M83.0394404,196.508476 C83.0317235,196.316516 83.0220773,196.151566 83.0056787,196.000121 L83.2651616,195.98951 L83.2883124,196.309764 L83.3018171,196.3088 C83.3674113,196.086937 83.5400783,195.942244 83.7397546,195.934527 C83.7725517,195.932598 83.7966672,195.935492 83.8236766,195.941279 L83.835252,196.221019 C83.8043842,196.215231 83.7735164,196.213302 83.7330023,196.214267 C83.5236797,196.222948 83.3818806,196.386934 83.3510127,196.610726 C83.345225,196.652204 83.3404019,196.699471 83.3423312,196.749631 L83.3770575,197.619718 L83.0828484,197.631294 L83.0394404,196.508476 Z" id="Fill-115" fill="#FEFEFE"></path>
                        <path d="M85.1603507,196.579086 C85.1574568,196.390021 85.0658179,196.09967 84.7320594,196.111245 C84.4320625,196.121856 84.3105204,196.402561 84.2941218,196.608989 L85.1603507,196.579086 Z M84.2979803,196.821206 C84.3192019,197.222488 84.580614,197.378756 84.877717,197.368145 C85.0899334,197.361393 85.2172633,197.319914 85.3262653,197.268789 L85.3841426,197.479077 C85.2809282,197.530202 85.1044027,197.590008 84.8449199,197.599654 C84.3423528,197.617017 84.0317452,197.296763 84.014382,196.804807 C83.9970188,196.312851 84.2738648,195.915427 84.7484579,195.898064 C85.2809282,195.879736 85.4391259,196.342754 85.4497367,196.642751 C85.451666,196.703522 85.4468429,196.751753 85.443949,196.781656 L84.2979803,196.821206 Z" id="Fill-117" fill="#FEFEFE"></path>
                        <path d="M86.8404295,196.524971 C86.8385003,196.335905 86.747826,196.04459 86.4150321,196.055201 C86.1150352,196.064847 85.9915638,196.344587 85.9742007,196.551016 L86.8404295,196.524971 Z M85.9770945,196.764197 C85.9963869,197.164514 86.257799,197.321747 86.5539374,197.313066 C86.7661538,197.306313 86.8934836,197.265799 87.0034503,197.214674 L87.0603629,197.425926 C86.9571486,197.476086 86.7806231,197.534928 86.5201757,197.54361 C86.0185732,197.559044 85.7089301,197.237825 85.6934962,196.745869 C85.6780623,196.252948 85.9558729,195.857454 86.4314306,195.84202 C86.9639009,195.825621 87.1201694,196.290568 87.1288509,196.590565 C87.1307802,196.650371 87.1259571,196.698603 87.1230632,196.728506 L85.9770945,196.764197 Z" id="Fill-119" fill="#FEFEFE"></path>
                        <path d="M87.4640564,197.178694 C87.5528015,197.233677 87.7090699,197.289625 87.8576214,197.285767 C88.0736963,197.279979 88.1720876,197.170012 88.1682291,197.034966 C88.1653353,196.894131 88.0785194,196.817926 87.8576214,196.742686 C87.5614831,196.646224 87.4187193,196.488026 87.4138962,196.293173 C87.4061792,196.029831 87.6135726,195.808933 87.9646943,195.799287 C88.1286797,195.794464 88.275302,195.837872 88.3679055,195.889961 L88.2994175,196.107966 C88.2338233,196.069381 88.115175,196.018256 87.9637297,196.022114 C87.7872042,196.026938 87.6926714,196.130152 87.6955653,196.251694 C87.6994237,196.386741 87.7987796,196.444618 88.0129253,196.519858 C88.2994175,196.620179 88.447969,196.75812 88.4537567,197.000239 C88.4614736,197.286731 88.2444341,197.495089 87.8566568,197.5057 C87.6782021,197.510523 87.5122874,197.470974 87.3955684,197.406344 L87.4640564,197.178694 Z" id="Fill-121" fill="#FEFEFE"></path>
                    </g>
                    <polygon id="Path-140" stroke="none" fill="#D0D0D0" fill-rule="evenodd" style="mix-blend-mode: multiply;" points="452.958316 300.265349 452.81549 289.327919 454.980826 276.722416 459.287005 275.664689 468.707058 278.807107 483.599016 290.321669 484.080443 294.829949 464.749746 305.059811 462.168918 304.89225"></polygon>
                    <polygon id="Path-141" stroke="none" fill="#D0D0D0" fill-rule="evenodd" style="mix-blend-mode: multiply;" points="383.407905 358.625402 379.549425 376.953184 383.407905 382.740905 387.266385 392.387106 395.947966 393.351726 392.089486 368.271603 389.195626 357.660782"></polygon>
                    <polygon id="Path-142" stroke="none" fill="#23B300" fill-rule="evenodd" opacity="0.376457556" style="mix-blend-mode: multiply;" points="403.700307 501.459939 400.771067 508.14152 407.523408 509.10614 436.462011 511.03538 443.214352 509.10614 452.789793 508.14152 448.895933 499.459939 438.391251 497.566078 431.638911 501.389179 424.88657 499.459939 417.169609 501.389179"></polygon>
                    <ellipse id="Oval-3" stroke="none" fill="#FFFFFF" fill-rule="evenodd" cx="406.744014" cy="191.337682" rx="1.74401396" ry="2.33768157"></ellipse>
                    <ellipse id="Oval-3" stroke="none" fill="#FFFFFF" fill-rule="evenodd" cx="437.44693" cy="188.92924" rx="1.44693017" ry="1.92924022"></ellipse>
                </svg>
            </div>
            <div class="error-message">
                <h1 data-role="error-title">Oops.</h1>
                <p data-role="error-message">%(message)s Click <a href="%(homeurl)s" data-role="return-to-splunk-home">here</a> to return to Splunk homepage.</p>
            </div>
        </div>
    </div>
    <div class="message-wrapper">
        <div class="message-container fixed-width" data-role="more-results">%(more_results_link)s</div>
        <div class="message-container fixed-width" data-role="crashes">%(crashes)s</div>
        <div class="message-container fixed-width" data-role="refferer">%(referrer)s</div>
        <div class="message-container fixed-width" data-role="debug">%(debug)s</div>
        <div class="message-container fixed-width" data-role="byline">
            <p class="byline">%(byline)s.</p>
        </div>
    </div>
</body>
</html>
'''

SIMPLE_HTML_TEMPLATE = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:splunk="http://www.splunk.com/xhtml-extensions/1.0" xml:lang="en">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <link rel="shortcut icon" href="%(favicon)s" />
    <title>%(message)s - Splunk</title>
    <style>.status {color: #999;}</style>
</head>
<body>
    <p class="status">%(status)s</p>
</body>
</html>
'''

DEBUG_TEMPLATE = '''
<p id="toggle"><a href="javascript:void(0)" onclick="toggle('debug')">Debugging information</a></p>
<div id="debug">
    <h2>Python Traceback</h2>
    <pre class="traceback">%(traceback)s</pre>
    <h2>Appserver configuration</h2>
    <pre class="config">%(splunkConfig)s</pre>
    <h2>Client request headers</h2>
    <pre class="headers">%(requestHeaders)s</pre>
    <h2>WSGI environment</h2>
    <pre class="headers">%(wsgi)s</pre>
    <h2>Platform</h2>
    <pre class="traceback">%(uname)s</pre>
</div>
'''


def handleError(**kwargs):
    '''This should be safe.
    Note that the message parameter of kwargs seems to be magically
    HTML escaped by Cherrypy so it is left untreated, for now.
    '''

    # augment the kwargs with mrsparkle data
    kwargs['splunkConfig'] = renderTable(cherrypy.config)
    kwargs['requestHeaders'] = renderTable(cherrypy.request.headers)
    kwargs['byline'] = generateByline()
    kwargs['homeurl'] = cherrypy.config.get('root_endpoint', '/')
    kwargs['uname'] = su.escape('\n'.join(platform.uname()))
    kwargs['wsgi'] = renderTable(cherrypy.request.wsgi_environ)
    kwargs['referrer'] = generateReferrer()
    kwargs['more_results_link'] = generateMoreResultsLink()

    try:
        kwargs['favicon'] = util.make_url(['static', 'img', util.getFaviconFileName()])
    except Exception:
        kwargs['favicon'] = ""
    
    # only show recent crash logs when we can't reach splunkd
    kwargs['crashes'] = ''
    if kwargs.get('status', '')[:3] ==  '503':
        try:
            kwargs['crashes'] = generateCrashLogs()
        except Exception as e:
            logger.exception(e)

    # SPL-93824: 404 pages should NOT display path information
    if kwargs.get('status', '')[:3] ==  '404':
        errMsg = kwargs.get('message', '')
        logger.info("Masking the original 404 message: '%s' with 'Page not found!' for security reasons" % errMsg)
        kwargs['message'] = 'Page not found!'

    # only show debug information while logging is set to debug 
    # (or if --debug was used)
    kwargs['debug'] = ''
    kwargs['visibility'] = 'none'
    if logging.getLogger('splunk').getEffectiveLevel() == logging.DEBUG:
        kwargs['debug'] = DEBUG_TEMPLATE % kwargs
    
    # extract additional info if we're in 500 territory
    if kwargs.get('status', '')[:3] ==  '500' and not kwargs.get('noexname', None):
        logger.info(" ".join([cherrypy.request.wsgi_environ.get("REQUEST_METHOD"), cherrypy.request.wsgi_environ.get("PATH_INFO"), cherrypy.request.wsgi_environ.get("SERVER_NAME"), cherrypy.request.wsgi_environ.get("SERVER_PORT")]))
        logger.info(" ".join([kwargs['status'], kwargs['message']]))
        logger.error(kwargs['traceback'])

    if cherrypy.config.get('simple_error_page'):
        return SIMPLE_HTML_TEMPLATE % kwargs
    else:
        return HTML_TEMPLATE % kwargs

def renderTable(D, sort=True):
    '''This should be safe'''
    output = []
    if len(D) == 0:
        output.append('No data')

    keys = D.keys()
    if sort: 
        keys = sorted(keys)

    output.append('<table>')
    for key in keys:
        output.append('<tr>')
        output.append('<td class="k">%s:</td>' % su.escape(key))
        output.append('<td class="v">%s</td>' % su.escape(str(D.get(key))))
        output.append('</tr>')
    output.append('</table>')
    return ''.join(output)
    
    
def generateCrashLogs():
    '''This should be safe'''
    entries = []
    loc = util.make_splunkhome_path(['var', 'log', 'splunk'])
    for name in sorted(os.listdir(loc), reverse=True):
        if name.startswith('crash') and name.endswith('log'):
            info = os.stat(os.path.join(loc, name))
            if info.st_mtime > (time.time() - CRASH_WINDOW*60):
                h = open(os.path.join(loc, name), 'r')
                contents = '[UNREADABLE]'
                try:
                    contents = ''.join(h.readlines())
                finally:
                    h.close()
                tmpItem = {
                    'filename': name,
                    'delta': time.time() - info.st_mtime,
                    'contents': contents
                }
                entries.append(tmpItem)
        
    if entries:
        output = ['<div id="crashes">']
        output.append('<h2>Splunkd has recently crashed:</h2>')
        output.append('<dl>')
        for i, item in enumerate(entries):
            output.append('<dt><a href="javascript:void(0)" onclick="toggle(\'%s\')">%s</a> (%d minutes(s) ago)</dt>' % ('cl%s' % i, item['filename'], item['delta']/60))
            output.append('<dd id="%s">%s</dd>' % ('cl%s' % i, su.escape(item['contents'])))
        output.append('</dl>')
        output.append('</div>')
        return ''.join(output)
        
    else:
        return ''
    
        
            
def generateByline():
    '''This should be safe'''
    appHost = cherrypy.request.headers.get('host', 'UNKONWN_HOST')
    splunkdHost = splunk.mergeHostPath()
    buildNumber = cherrypy.config.get('build_number', 'UNKNOWN_BUILD')
    currentTime = str(datetime.datetime.now().ctime())

    try:
        userName = cherrypy.session['user']['name']
        return 'You are logged into <span>%s</span> as <span>%s</span>, which is connected to splunkd <span>@%s</span> at <span>%s</span> on <span>%s</span>' % (su.escape(appHost), userName, buildNumber, splunkdHost, currentTime)
    except:
        return ''

def generateReferrer():
    '''This should be safe'''
    r = cherrypy.request.wsgi_environ.get('HTTP_REFERER')
    if r and r.startswith("http"):
        return '<p>This page was linked to from <a href="%s">%s</a>.</p>' % (cgi.escape(r, True), su.escape(r))
    else:
        return ''

def generateMoreResultsLink():
    try:
        host = platform.uname()[1]
    except Exception:
        host = '*'

    request_id = util.get_request_id()
    search_string = 'index=_internal host="%s" source=*web_service.log log_level=ERROR requestid=%s' % (host, request_id)
    qs = { 'q': search_string }
    # Try to generate a link to more results in the current locale.  This might throw an exception (e.g. the error we are
    # displaying is that the locale is invalid, see SPL-81750), in which case fall back to the default locale.
    try:
        link_url = util.make_url('/app/search/search', _qs=qs)
    except:
        link_url = util.make_url('/app/search/search', _qs=qs, translate=False)

    return '<a href="%s" target="_blank">View more information about your request (request ID = %s) in Search</a>' % (link_url, request_id)
