/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.BlockStoreShuffleReader$;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockFetcherIterator;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005me!B\u000b\u0017\u0001aq\u0002\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"AQ\u000f\u0001B\u0001B\u0003%a\u000f\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003\u0013\u0001!\u0011!Q\u0001\n\u0005-\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"a\u0010\u0001A\u0003%\u00111\u0007\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u001d\t)\u0005\u0001C!\u0003\u000f:!\"!\u0015\u0017\u0003\u0003E\t\u0001GA*\r%)b#!A\t\u0002a\t)\u0006C\u0004\u0002\u0012=!\t!a\u0016\t\u0013\u0005es\"%A\u0005\u0002\u0005m\u0003\"CA<\u001fE\u0005I\u0011AA=\u0011%\t\u0019iDI\u0001\n\u0003\t)\tC\u0005\u0002\u0010>\t\n\u0011\"\u0001\u0002\u0012\n9\"\t\\8dWN#xN]3TQV4g\r\\3SK\u0006$WM\u001d\u0006\u0003/a\tqa\u001d5vM\u001adWM\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h+\ryBfN\n\u0005\u0001\u00012\u0013\b\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0005O!Rc'D\u0001\u0017\u0013\tIcCA\u0007TQV4g\r\\3SK\u0006$WM\u001d\t\u0003W1b\u0001\u0001B\u0003.\u0001\t\u0007qFA\u0001L\u0007\u0001\t\"\u0001M\u001a\u0011\u0005\u0005\n\u0014B\u0001\u001a#\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\t\u001b\n\u0005U\u0012#aA!osB\u00111f\u000e\u0003\u0006q\u0001\u0011\ra\f\u0002\u0002\u0007B\u0011!(P\u0007\u0002w)\u0011A\bG\u0001\tS:$XM\u001d8bY&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019A\u0017M\u001c3mKB\u0012\u0011)\u0012\t\u0006O\tSCIN\u0005\u0003\u0007Z\u0011\u0011CQ1tKNCWO\u001a4mK\"\u000bg\u000e\u001a7f!\tYS\tB\u0005G\u0003\u0005\u0005\t\u0011!B\u0001_\t\u0019q\fJ\u0019\u0002\u001f\tdwnY6t\u0005f\fE\r\u001a:fgN\u00042!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N]\u00051AH]8pizJ\u0011aI\u0005\u0003!\n\nq\u0001]1dW\u0006<W-\u0003\u0002S'\nA\u0011\n^3sCR|'O\u0003\u0002QEA!\u0011%V,^\u0013\t1&E\u0001\u0004UkBdWM\r\t\u00031nk\u0011!\u0017\u0006\u00035b\tqa\u001d;pe\u0006<W-\u0003\u0002]3\nq!\t\\8dW6\u000bg.Y4fe&#\u0007cA%_A&\u0011ql\u0015\u0002\u0004'\u0016\f\b#B\u0011bG\u001aL\u0017B\u00012#\u0005\u0019!V\u000f\u001d7fgA\u0011\u0001\fZ\u0005\u0003Kf\u0013qA\u00117pG.LE\r\u0005\u0002\"O&\u0011\u0001N\t\u0002\u0005\u0019>tw\r\u0005\u0002\"U&\u00111N\t\u0002\u0004\u0013:$\u0018aB2p]R,\u0007\u0010\u001e\t\u0003]>l\u0011\u0001G\u0005\u0003ab\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006Y!/Z1e\u001b\u0016$(/[2t!\t93/\u0003\u0002u-\tQ2\u000b[;gM2,'+Z1e\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe\u0006\t2/\u001a:jC2L'0\u001a:NC:\fw-\u001a:\u0011\u0005]TX\"\u0001=\u000b\u0005eD\u0012AC:fe&\fG.\u001b>fe&\u00111\u0010\u001f\u0002\u0012'\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198bO\u0016\u0014\u0018\u0001\u00042m_\u000e\\W*\u00198bO\u0016\u0014\bC\u0001-\u007f\u0013\ty\u0018L\u0001\u0007CY>\u001c7.T1oC\u001e,'/\u0001\tnCB|U\u000f\u001e9viR\u0013\u0018mY6feB\u0019a.!\u0002\n\u0007\u0005\u001d\u0001D\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\u0006\u00012\u000f[8vY\u0012\u0014\u0015\r^2i\r\u0016$8\r\u001b\t\u0004C\u00055\u0011bAA\bE\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\n\u0002\u0016\u0005]\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0002\u0003B\u0014\u0001UYBaaP\u0005A\u0002\u0005e\u0001\u0007BA\u000e\u0003?\u0001ba\n\"+\u0003;1\u0004cA\u0016\u0002 \u0011Qa)a\u0006\u0002\u0002\u0003\u0005)\u0011A\u0018\t\u000b\u001dK\u0001\u0019\u0001%\t\u000b1L\u0001\u0019A7\t\u000bEL\u0001\u0019\u0001:\t\u000fUL\u0001\u0013!a\u0001m\"9A0\u0003I\u0001\u0002\u0004i\b\"CA\u0001\u0013A\u0005\t\u0019AA\u0002\u0011%\tI!\u0003I\u0001\u0002\u0004\tY!A\u0002eKB,\"!a\r1\t\u0005U\u0012Q\b\t\b]\u0006]\"&a\u000f7\u0013\r\tI\u0004\u0007\u0002\u0012'\",hM\u001a7f\t\u0016\u0004XM\u001c3f]\u000eL\bcA\u0016\u0002>\u0011Ia)AA\u0001\u0002\u0003\u0015\taL\u0001\u0005I\u0016\u0004\b%\u0001\u000fgKR\u001c\u0007nQ8oi&tWo\\;t\u00052|7m[:J]\n\u000bGo\u00195\u0016\u0005\u0005-\u0011\u0001\u0002:fC\u0012$\"!!\u0013\u0011\t%\u000b\u00161\n\t\u0006C\u00055#FN\u0005\u0004\u0003\u001f\u0012#\u0001\u0003)s_\u0012,8\r\u001e\u001a\u0002/\tcwnY6Ti>\u0014Xm\u00155vM\u001adWMU3bI\u0016\u0014\bCA\u0014\u0010'\ty\u0001\u0005\u0006\u0002\u0002T\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*b!!\u0018\u0002t\u0005UTCAA0U\r1\u0018\u0011M\u0016\u0003\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u000e\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)Q&\u0005b\u0001_\u0011)\u0001(\u0005b\u0001_\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*b!a\u001f\u0002\u0000\u0005\u0005UCAA?U\ri\u0018\u0011\r\u0003\u0006[I\u0011\ra\f\u0003\u0006qI\u0011\raL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\r\u0005\u001d\u00151RAG+\t\tII\u000b\u0003\u0002\u0004\u0005\u0005D!B\u0017\u0014\u0005\u0004yC!\u0002\u001d\u0014\u0005\u0004y\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0004\u0002\u0014\u0006]\u0015\u0011T\u000b\u0003\u0003+SC!a\u0003\u0002b\u0011)Q\u0006\u0006b\u0001_\u0011)\u0001\b\u0006b\u0001_\u0001")
public class BlockStoreShuffleReader<K, C>
implements ShuffleReader<K, C>,
Logging {
    private final Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> blocksByAddress;
    private final TaskContext context;
    private final ShuffleReadMetricsReporter readMetrics;
    private final SerializerManager serializerManager;
    private final BlockManager blockManager;
    private final boolean shouldBatchFetch;
    private final ShuffleDependency<K, ?, C> dep;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, C> boolean $lessinit$greater$default$8() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$8();
    }

    public static <K, C> MapOutputTracker $lessinit$greater$default$7() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$7();
    }

    public static <K, C> BlockManager $lessinit$greater$default$6() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$6();
    }

    public static <K, C> SerializerManager $lessinit$greater$default$5() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, ?, C> dep() {
        return this.dep;
    }

    private boolean fetchContinuousBlocksInBatch() {
        boolean doBatchFetch;
        block0: {
            SparkConf conf = SparkEnv$.MODULE$.get().conf();
            boolean serializerRelocatable = this.dep().serializer().supportsRelocationOfSerializedObjects();
            boolean compressed = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.SHUFFLE_COMPRESS()));
            boolean codecConcatenation = compressed ? CompressionCodec$.MODULE$.supportsConcatenationOfSerializedStreams(CompressionCodec$.MODULE$.createCodec(conf)) : true;
            boolean useOldFetchProtocol = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.SHUFFLE_USE_OLD_FETCH_PROTOCOL()));
            boolean bl = doBatchFetch = this.shouldBatchFetch && serializerRelocatable && (!compressed || codecConcatenation) && !useOldFetchProtocol;
            if (!this.shouldBatchFetch || doBatchFetch) break block0;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(249).append("The feature tag of continuous shuffle block fetching is set to true, but we can not enable the feature because other conditions are not satisfied. ").append("Shuffle compress: ").append(compressed).append(", serializer relocatable: ").append(serializerRelocatable).append(", ").append("codec concatenation: ").append(codecConcatenation).append(", use old shuffle fetch protocol: ").append(useOldFetchProtocol).append(".").toString());
        }
        return doBatchFetch;
    }

    @Override
    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator resultIter;
        Object object;
        Some some;
        Ordering keyOrd;
        InterruptibleIterator interruptibleIterator;
        Iterator<Tuple2<BlockId, InputStream>> wrappedStreams = new ShuffleBlockFetcherIterator(this.context, this.blockManager.blockStoreClient(), this.blockManager, this.blocksByAddress, (Function2<BlockId, InputStream, InputStream>)(Function2 & Serializable & scala.Serializable)(blockId, s) -> $this.serializerManager.wrapStream((BlockId)blockId, (InputStream)s), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.REDUCER_MAX_SIZE_IN_FLIGHT())) * 1024L * 1024L, BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.REDUCER_MAX_REQS_IN_FLIGHT())), BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.REDUCER_MAX_BLOCKS_IN_FLIGHT_PER_ADDRESS())), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM())), BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.SHUFFLE_DETECT_CORRUPT())), BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.SHUFFLE_DETECT_CORRUPT_MEMORY())), this.readMetrics, this.fetchContinuousBlocksInBatch()).toCompletionIterator();
        SerializerInstance serializerInstance = this.dep().serializer().newInstance();
        Iterator recordIter = wrappedStreams.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream wrappedStream = (InputStream)tuple2._2();
            Iterator<Tuple2<Object, Object>> iterator = serializerInstance.deserializeStream(wrappedStream).asKeyValueIterator();
            return iterator;
        });
        CompletionIterator metricIter = CompletionIterator$.MODULE$.apply(recordIter.map((Function1 & Serializable & scala.Serializable)record -> {
            $this.readMetrics.incRecordsRead(1L);
            return record;
        }), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
        InterruptibleIterator interruptibleIter = new InterruptibleIterator(this.context, metricIter);
        if (this.dep().aggregator().isDefined()) {
            if (this.dep().mapSideCombine()) {
                InterruptibleIterator combinedKeyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineCombinersByKey(combinedKeyValuesIterator, this.context);
            } else {
                InterruptibleIterator keyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineValuesByKey(keyValuesIterator, this.context);
            }
        } else {
            interruptibleIterator = interruptibleIter;
        }
        InterruptibleIterator aggregatedIter = interruptibleIterator;
        Option<Ordering<K>> option = this.dep().keyOrdering();
        if (option instanceof Some && (keyOrd = (Ordering)(some = (Some)option).value()) != null) {
            Ordering ordering = keyOrd;
            TaskContext x$12 = this.context;
            Some x$2 = new Some((Object)ordering);
            Serializer x$3 = this.dep().serializer();
            None$ x$4 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
            Option<Partitioner> x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
            ExternalSorter sorter = new ExternalSorter(x$12, x$4, x$5, x$2, x$3);
            sorter.insertAll(aggregatedIter);
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
                sorter.stop();
                return BoxedUnit.UNIT;
            });
            object = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sorter.stop());
        } else if (None$.MODULE$.equals(option)) {
            object = aggregatedIter;
        } else {
            throw new MatchError(option);
        }
        InterruptibleIterator interruptibleIterator2 = resultIter = object;
        InterruptibleIterator<Object> interruptibleIterator3 = interruptibleIterator2 instanceof InterruptibleIterator ? resultIter : new InterruptibleIterator<Product2<K, C>>(this.context, resultIter);
        return interruptibleIterator3;
    }

    public BlockStoreShuffleReader(BaseShuffleHandle<K, ?, C> handle, Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> blocksByAddress, TaskContext context, ShuffleReadMetricsReporter readMetrics, SerializerManager serializerManager, BlockManager blockManager, MapOutputTracker mapOutputTracker, boolean shouldBatchFetch) {
        this.blocksByAddress = blocksByAddress;
        this.context = context;
        this.readMetrics = readMetrics;
        this.serializerManager = serializerManager;
        this.blockManager = blockManager;
        this.shouldBatchFetch = shouldBatchFetch;
        Logging.$init$(this);
        this.dep = handle.dependency();
    }
}

