/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.reporting;

import com.splunk.mr.cache.GroupedProcessor;
import com.splunk.mr.cache.JobQueue;
import com.splunk.mr.cache.MapCaches;
import com.splunk.mr.cache.PathAndPointer;
import com.splunk.mr.cache.integration.CacheKey;
import com.splunk.mr.cache.reporting.Report;
import com.splunk.mr.input.VixInputSplit;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ProbeFactories {
    private final FileSystem fs;
    private final MapCaches mapCaches;
    private final Map<String, Report> reports = new HashMap<String, Report>();

    public ProbeFactories(FileSystem fs, MapCaches mapCaches) {
        this.fs = fs;
        this.mapCaches = mapCaches;
    }

    private synchronized Report getReport(String key) {
        if (!this.reports.containsKey(key)) {
            this.reports.put(key, new Report());
        }
        return this.reports.get(key);
    }

    public Map<String, Report> getReports() {
        return this.reports;
    }

    public GroupedProcessor.ProcessFactory<String, VixInputSplit> getSplitFactory() {
        return new GroupedProcessor.ProcessFactory<String, VixInputSplit>(){

            @Override
            public GroupedProcessor.Processor<VixInputSplit> getNew(String key, GroupedProcessor<String, VixInputSplit> groupedProcessor) {
                return new ProbeSplitReducer(ProbeFactories.this.getReport(key));
            }
        };
    }

    public GroupedProcessor.ProcessFactory<String, CacheKey> getCacheFactory() {
        return new GroupedProcessor.ProcessFactory<String, CacheKey>(){

            @Override
            public GroupedProcessor.Processor<CacheKey> getNew(String key, GroupedProcessor<String, CacheKey> groupedProcessor) {
                return new ProbeCacheReducer(ProbeFactories.this.fs, ProbeFactories.this.mapCaches, ProbeFactories.this.getReport(key));
            }
        };
    }

    private static long toSec(long millis) {
        return millis / 1000L;
    }

    public static class ProbeCacheReducer
    extends GroupedProcessor.Processor<CacheKey> {
        private final FileSystem fs;
        private final MapCaches mapCaches;
        private final Report report;
        private int retires = 3;

        public ProbeCacheReducer(FileSystem fs, MapCaches mapCaches, Report report) {
            this.fs = fs;
            this.mapCaches = mapCaches;
            this.report = report;
        }

        @Override
        public void process(CacheKey cacheKey) {
            this.doProcess(cacheKey, 0);
        }

        private void doProcess(CacheKey cacheKey, int limit) {
            if (this.mapCaches.hasCompactedResult(cacheKey)) {
                this.setCompactedResults(this.report, this.mapCaches, cacheKey);
            } else if (this.mapCaches.hasStagedResult(cacheKey)) {
                this.setStagedResults(this.report, this.mapCaches, cacheKey);
            } else {
                this.mapCaches.flagCacheUpdate(cacheKey);
                if (limit < this.retires) {
                    this.doProcess(cacheKey, limit + 1);
                } else {
                    this.setDefaults(this.report);
                }
            }
        }

        private void setCompactedResults(Report report, MapCaches mapCaches, CacheKey cacheKey) {
            PathAndPointer pnp = mapCaches.getCompactedPathAndPointer(cacheKey);
            report.allTrue("summary_complete", true);
            long length = pnp.pointer.getLength();
            report.increment("summary_size", length);
            report.setRatio("summary_ratio", "summary_size", "bucket_size");
            report.increment("summary_chunks", 1L);
            Path path = pnp.getPath();
            report.lateTime("summary_modtime", ProbeFactories.toSec(this.getModTime(path)));
            report.set("summary_path", path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setStagedResults(Report report, MapCaches mapCaches, CacheKey cacheKey) {
            JobQueue.CacheJob cacheJob = null;
            try {
                cacheJob = mapCaches.getStagedResult(cacheKey);
                report.allTrue("summary_complete", false);
                long length = cacheJob.length;
                report.increment("summary_size", length);
                report.setRatio("summary_ratio", "summary_size", "bucket_size");
                report.increment("summary_chunks", 1L);
                Path path = cacheJob.getPath();
                report.lateTime("summary_modtime", ProbeFactories.toSec(this.getModTime(path)));
                report.set("summary_path", path);
            }
            catch (IOException e) {
                mapCaches.flagCacheUpdate(cacheKey);
                this.setCompactedResults(report, mapCaches, cacheKey);
                return;
            }
            finally {
                cacheJob.close();
            }
        }

        private void setDefaults(Report report) {
            report.allTrue("summary_complete", false);
            report.increment("summary_size", 0L);
            report.increment("summary_chunks", 0L);
            report.lateTime("summary_modtime", 0L);
        }

        private long getModTime(Path path) {
            try {
                return this.fs.getFileStatus(path).getModificationTime();
            }
            catch (IOException e) {
                return -1L;
            }
        }
    }

    public static class ProbeSplitReducer
    extends GroupedProcessor.Processor<VixInputSplit> {
        private final Report report;

        public ProbeSplitReducer(Report report) {
            this.report = report;
        }

        @Override
        public void process(VixInputSplit split) {
            String bucketId = split.getBucketId();
            String index = split.getIndex();
            String server = "resides-in-hadoop";
            this.report.set("bucket_id", bucketId);
            this.report.set("splunk_server", server);
            this.report.set("index", index);
            this.report.set("bucket_path", "/unknown/path");
            this.report.earlyTime("bucket_et", ProbeFactories.toSec(split.getEarliestTime()));
            this.report.lateTime("bucket_lt", ProbeFactories.toSec(split.getLatestTime()));
            long bucketSize = split.getLength();
            this.report.increment("bucket_size", bucketSize);
        }
    }
}

