/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class PrimeUtils {
    static final Logger logger = Logger.getLogger(PrimeUtils.class);
    private List<Integer> _primes = new ArrayList<Integer>();

    public int getClosestPrime(int num) {
        int range = (int)Math.floor(Math.sqrt((double)num * 2.0));
        int end = num * 2;
        for (int i = 2; i < end; i += range) {
            this.getPrimes(i, i + range > end ? end : i + range);
        }
        return this.closest(num);
    }

    private static List<Integer> rangeClosed(int start, int end) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i = start; i < end; ++i) {
            list.add(i);
        }
        return list;
    }

    private void sieve(int start, int end) {
        int i;
        List<Integer> p = PrimeUtils.rangeClosed(start, end);
        int range = end - start;
        int idx = 0;
        int step = p.get(idx);
        while (step * step < end) {
            for (i = idx + step; i < range; i += step) {
                if (p.get(i) == null) continue;
                p.set(i, null);
            }
            int s = idx + 1;
            if (s >= range) break;
            while (s < range && p.get(s) == null) {
                ++s;
            }
            idx = s;
            step = p.get(s);
        }
        for (i = 0; i < p.size(); ++i) {
            if (p.get(i) == null) continue;
            this._primes.add(p.get(i));
        }
    }

    private void getPrimes(int start, int end) {
        if (this._primes.isEmpty()) {
            this.sieve(start, end);
            return;
        }
        List<Integer> np = PrimeUtils.rangeClosed(start, end);
        int range = end - start;
        for (int p = 0; p < this._primes.size(); ++p) {
            boolean found = false;
            int i = 0;
            while (i < range) {
                if (np.get(i) == null) {
                    ++i;
                    continue;
                }
                if (!found && np.get(i) % this._primes.get(p) != 0) {
                    ++i;
                    continue;
                }
                found = true;
                np.set(i, null);
                i += this._primes.get(p).intValue();
            }
        }
        for (int i = 0; i < np.size(); ++i) {
            if (np.get(i) == null) continue;
            this._primes.add(np.get(i));
        }
    }

    private int closest(int num) {
        int start = 0;
        int end = this._primes.size() - 1;
        int mid = 0;
        while (start <= end) {
            mid = (start + end) / 2;
            if (num == this._primes.get(mid)) {
                return this._primes.get(mid);
            }
            if (num < this._primes.get(mid)) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        while (mid < this._primes.size() && this._primes.get(mid) < num) {
            ++mid;
        }
        if (mid >= this._primes.size()) {
            return num;
        }
        return this._primes.get(mid);
    }

    private void dump() {
        logger.debug((Object)("Primes: " + this._primes.toString()));
    }

    private static void printUsage(Options opts) {
        Iterator oi = opts.getOptions().iterator();
        logger.error((Object)"Option details: ");
        while (oi.hasNext()) {
            Option opt = (Option)oi.next();
            logger.error((Object)(opt.getOpt() + ": " + opt.getDescription()));
        }
    }

    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        Options opts = new Options();
        opts.addOption("n", true, "Input whose closest prime needs to be found");
        int num = 0;
        try {
            CommandLine cl = parser.parse(opts, args);
            if (!cl.hasOption("n")) {
                PrimeUtils.printUsage(opts);
                return;
            }
            num = Integer.valueOf(cl.getOptionValue("n"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        PrimeUtils closestPrime = new PrimeUtils();
        logger.info((Object)("Closest prime of " + num + " is " + closestPrime.getClosestPrime(num)));
        Random rand = new Random();
        for (int i = 0; i < 20; ++i) {
            num = rand.nextInt(500);
            PrimeUtils cp = new PrimeUtils();
            logger.debug((Object)("Closest prime of " + num + " is " + cp.getClosestPrime(num)));
        }
    }
}

