/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import com.splunk.df.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.SparkFiles;

public class DFSLogger {
    static DFSLogger logger;
    private static final String LOG_FILE = "log4j.appender.file.File";

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger((Class)clazz);
    }

    private static Properties getUpdatedExecutorLogProperties(String logConfigFile) {
        Properties logConfigProps = new Properties();
        try (FileInputStream logConfigStream = new FileInputStream(logConfigFile);){
            logConfigProps.load(logConfigStream);
            if (logConfigProps.containsKey(LOG_FILE)) {
                logConfigProps.put(LOG_FILE, Utils.getSparkExecutorLogFile().getAbsolutePath());
            }
        }
        catch (Exception ex) {
            System.err.println("Error configuring executor log file");
        }
        return logConfigProps;
    }

    static {
        String logCfg;
        logger = new DFSLogger();
        LogManager.resetConfiguration();
        if (Boolean.parseBoolean(System.getenv("DFS_SEARCH_LOG_CONFIG_ENABLED")) && new File(SparkFiles.get((String)"log-dfs-search.cfg")).exists()) {
            logCfg = Paths.get(SparkFiles.get((String)"log-dfs-search.cfg"), new String[0]).toString();
            PropertyConfigurator.configure((Properties)DFSLogger.getUpdatedExecutorLogProperties(logCfg));
        } else if (!System.getenv("SPLUNK_HOME").isEmpty()) {
            logCfg = Paths.get(System.getenv("SPLUNK_HOME"), "etc", "log-dfs-search.cfg").toString();
            PropertyConfigurator.configure((String)logCfg);
        } else {
            ClassLoader loader = DFSLogger.class.getClassLoader();
            URL url = loader.getResource("log-dfs-search.cfg");
            PropertyConfigurator.configure((URL)url);
            logCfg = url.toString();
        }
        Logger.getLogger(DFSLogger.class).debug((Object)("Using logger " + logCfg));
    }
}

