/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes.fieldCompressed.util;

import com.splunk.df.serdes.fieldCompressed.util.DataUtil;
import com.splunk.df.serdes.fieldCompressed.util.EncodingStringCache;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WritableThresholdStringCache
implements EncodingStringCache {
    final int threshold;
    int nextId = 0;
    IdCache txtToId;
    LRUCache<String, Counter> txtToCount;
    List<IdPair> unwrittenIds = new ArrayList<IdPair>();

    public WritableThresholdStringCache(int threshold, int numIdsToRemember, int numTxtToTrack) {
        this.threshold = threshold;
        this.txtToId = new IdCache(numIdsToRemember);
        this.txtToCount = new LRUCache(numTxtToTrack);
    }

    @Override
    public Integer getId(String txt) {
        Integer id = (Integer)this.txtToId.get(txt);
        if (null == id && this.nextId < Integer.MAX_VALUE) {
            Counter cnt = (Counter)this.txtToCount.get(txt);
            if (cnt == null) {
                this.txtToCount.put(txt, new Counter());
            } else {
                cnt.increment();
                if (cnt.getValue() == this.threshold) {
                    id = this.nextId++;
                    this.txtToId.put(txt, id);
                    this.txtToCount.remove(txt);
                    this.unwrittenIds.add(new IdPair(txt, id));
                    return id;
                }
            }
        }
        return id;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        int size = this.unwrittenIds.size();
        if (0 == size) {
            return;
        }
        out.write(this.getType());
        DataUtil.writeBase128(out, size);
        for (IdPair pair : this.unwrittenIds) {
            DataUtil.writeString(out, pair.txt);
            DataUtil.writeBase128(out, pair.id);
        }
        this.unwrittenIds.clear();
        List<Integer> oldIds = this.txtToId.droppedValues;
        DataUtil.writeBase128(out, oldIds.size());
        for (Integer id : oldIds) {
            DataUtil.writeBase128(out, id);
        }
        oldIds.clear();
    }

    @Override
    public byte getType() {
        return 1;
    }

    class IdCache
    extends LRUCache<String, Integer> {
        List<Integer> droppedValues;

        public IdCache(int maxSize) {
            super(maxSize);
            this.droppedValues = new ArrayList<Integer>();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
            if (this.size() > this.maxSize) {
                this.droppedValues.add(eldest.getValue());
                return true;
            }
            return false;
        }
    }

    class LRUCache<T, U>
    extends LinkedHashMap<T, U> {
        int maxSize;

        public LRUCache(int maxSize) {
            super(maxSize, 0.75f, true);
            this.maxSize = maxSize;
        }
    }

    class Counter {
        int val = 1;

        Counter() {
        }

        public void increment() {
            ++this.val;
        }

        public int getValue() {
            return this.val;
        }
    }

    class IdPair {
        String txt;
        int id;

        public IdPair(String txt, int id) {
            this.txt = txt;
            this.id = id;
        }
    }
}

