/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DistinctCountAggregateValue
extends BaseAggregateValue {
    private static final long serialVersionUID = 1L;
    private Long count = 0L;

    public DistinctCountAggregateValue(long count) {
        this.count = count;
    }

    public DistinctCountAggregateValue() {
    }

    @Override
    public Object getValue() {
        return this.count;
    }

    @Override
    public AggregateValue accumulate(Object value) {
        this.count = value instanceof Long ? Long.valueOf(this.count + (Long)value) : Long.valueOf(this.count + 1L);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        this.count = this.count + (Long)aggregateValue.getValue();
        return this;
    }

    @Override
    public AggregateValue floor() {
        if (this.count > 0L) {
            return new DistinctCountAggregateValue(1L);
        }
        return this;
    }

    public String toString() {
        return String.format("distinct-count-value:%d", this.count);
    }

    public static void write(OutputStream os, DistinctCountAggregateValue val) throws IOException {
        long count = (Long)val.getValue();
        Utils.write(os, count);
    }

    public static DistinctCountAggregateValue read(InputStream is) throws IOException {
        long count = Utils.readLong(is);
        return new DistinctCountAggregateValue(count);
    }
}

