/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.search.compute.transformers.FieldsTransformer;
import org.apache.log4j.Logger;

public class TableTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(FieldsTransformer.class);
    private ComputeEngineContext ctx;

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        return TableTransformer._transform(ctx, dd, cmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, CommandNode cmd, final boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = cmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, srcCmd);
        if (executeExternal) {
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, cmd, ctx);
        } else {
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
        }
        TableCommand tcmd = (TableCommand)cmd;
        final FieldNode[] fields = tcmd.getFields();
        final SearchResult.FieldMeta[] fieldsMeta = new SearchResult.FieldMeta[fields.length];
        for (int i = 0; i < fieldsMeta.length; ++i) {
            fieldsMeta[i] = SearchResult.FieldMeta.newFieldMeta(fields[i].getFieldName());
        }
        outputdd = outputdd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                int len = fields.length;
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(len + 1, 1.0f);
                SearchResult.FieldMeta[] retFlds = new SearchResult.FieldMeta[len];
                Object[] retVals = new Object[len];
                for (int i = 0; i < len; ++i) {
                    FieldNode field = fields[i];
                    SearchResult.FieldMeta fieldName = fieldsMeta[i];
                    Object fieldVal = sr.getFieldValue(fieldName);
                    data.put(fieldName, fieldVal);
                    retFlds[i] = fieldName;
                    retVals[i] = fieldVal;
                }
                return SearchResultFactory.getInstance().createSearchResult(data, retFlds, retVals);
            }

            @Override
            public boolean repartition() {
                return !streaming;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }

            @Override
            public String desc() {
                return "tailTransformerProcessing";
            }
        });
        return outputdd;
    }

    @Override
    public String name() {
        return "TableTransformer";
    }
}

