/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.Utils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RenameTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(RenameTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        return RenameTransformer._transform(ctx, dd, cmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, CommandNode cmd, boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = cmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, srcCmd);
        if (executeExternal) {
            logger.debug((Object)"Will execute base transformer to input create dataset");
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, cmd, ctx);
        } else {
            String cmdName = srcCmd.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
            logger.debug((Object)("Will apply rename processing on output of transformer " + cmdName));
        }
        RenameCommand rcmd = (RenameCommand)cmd;
        final RenameNode[] renames = rcmd.getRenames();
        if (renames == null || renames.length == 0) {
            return outputdd;
        }
        final TermMatcher[] fromNameArr = new TermMatcher[renames.length];
        final TermMatcher[] toNameArr = new TermMatcher[renames.length];
        Utils.renameArgsCheckAndTermMatcherCreation(renames, fromNameArr, toNameArr);
        outputdd = outputdd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                int len = renames.length;
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = sr.getDataMap();
                sr = null;
                HashMap<String, SearchResult.FieldMeta> fieldMap = new HashMap<String, SearchResult.FieldMeta>();
                for (int i = 0; i < len; ++i) {
                    if (renames[i] == null) {
                        logger.warn((Object)"Nothing to rename, skipping.");
                        continue;
                    }
                    for (SearchResult.FieldMeta field : data.keySet()) {
                        if (field == null || field.fieldName() == null) continue;
                        fieldMap.put(field.fieldName(), field);
                    }
                    if (fromNameArr[i].parts().length == 1 && !fieldMap.containsKey(renames[i].getFieldName())) {
                        if (!fieldMap.containsKey(renames[i].getNewFieldName())) continue;
                        data.remove(fieldMap.get(renames[i].getNewFieldName()));
                        continue;
                    }
                    for (String fieldName : fieldMap.keySet()) {
                        String toField;
                        SearchResult.FieldMeta fm = (SearchResult.FieldMeta)fieldMap.get(fieldName);
                        if (!data.containsKey(fm) || (toField = Utils.getRenameField(fieldName, fromNameArr[i], toNameArr[i])) == null) continue;
                        data.put(SearchResult.FieldMeta.newFieldMeta(toField), data.get(fm));
                        data.remove(fm);
                    }
                }
                return SearchResultFactory.getInstance().createSearchResult(data);
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }

            @Override
            public String desc() {
                return "renameTransformerProcessing";
            }
        });
        return outputdd;
    }

    @Override
    public String name() {
        return "RenameTransformer";
    }
}

