/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.splunkcompute.JavaSerdes;
import com.splunk.df.search.compute.splunkcompute.JsonSerdes;
import com.splunk.df.search.compute.splunkcompute.KryoSerdes;
import com.splunk.df.search.compute.splunkcompute.NativeSerdes;
import com.splunk.df.search.compute.splunkcompute.Serdes;
import org.apache.log4j.Logger;

public class SerdesFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SerdesFactory.class);
    private static SerdesFactory singleton = new SerdesFactory();

    public static SerdesFactory getInstance() {
        return singleton;
    }

    private SerdesType getSerdesType() {
        SerdesType type = SerdesType.NATIVE;
        String typeStr = System.getenv("DFS_SERDES_TYPE");
        if (typeStr != null && !typeStr.trim().isEmpty()) {
            try {
                int intType = Integer.valueOf(typeStr);
                type = SerdesType.values()[intType];
            }
            catch (Throwable t) {
                logger.info((Object)String.format("could not parse serdes type to int: %s", typeStr));
            }
        }
        return type;
    }

    public Serdes getSerdes() {
        SerdesType type = this.getSerdesType();
        return this.getSerdes(type);
    }

    public Serdes getSerdes(SerdesType type) {
        if (type.equals((Object)SerdesType.NATIVE)) {
            logger.info((Object)String.format("will use native serdes", new Object[0]));
            return new NativeSerdes();
        }
        if (type.equals((Object)SerdesType.KRYO)) {
            logger.info((Object)String.format("will use kryo serdes", new Object[0]));
            return new KryoSerdes();
        }
        if (type.equals((Object)SerdesType.JSON)) {
            logger.info((Object)String.format("will use json serdes", new Object[0]));
            return new JsonSerdes();
        }
        if (type.equals((Object)SerdesType.JAVA_NATIVE)) {
            logger.info((Object)String.format("will use java native serdes", new Object[0]));
            return new JavaSerdes();
        }
        throw new RuntimeException(String.format("unsupported type: %s", type.toString()));
    }

    public static enum SerdesType {
        NATIVE,
        KRYO,
        JSON,
        JAVA_NATIVE;

    }
}

