/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.splunkcompute.Flushable;
import com.splunk.df.search.compute.splunkcompute.Serdes;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import com.splunk.df.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class NativeSerdes
implements Serdes {
    static final Logger logger = Logger.getLogger(NativeSerdes.class);

    @Override
    public void write(Flushable flushable, Iterator<SplunkRecord> srs) throws IOException {
        OutputStream os = (OutputStream)flushable.source();
        while (srs.hasNext()) {
            SplunkRecord sr = srs.next();
            if (sr instanceof SplunkKVRecord) {
                SplunkKVRecord kvsr = (SplunkKVRecord)sr;
                Pair<SearchResult, SearchResult> kvSr = kvsr.toPair();
                this.write(os, kvSr);
                continue;
            }
            SearchResult sr1 = sr.getVal();
            this.write(os, RecordType.VALUE_ONLY);
            SearchResultFactory.write(os, sr1);
        }
    }

    private void write(OutputStream os, RecordType recType) throws IOException {
        int typeInt = recType.ordinal();
        Utils.write(os, typeInt);
    }

    private RecordType readRecordType(InputStream is) throws IOException {
        int recTypeInt = Utils.readInt(is);
        if (recTypeInt == RecordType.KEY_VALUE.ordinal()) {
            return RecordType.KEY_VALUE;
        }
        if (recTypeInt == RecordType.VALUE_ONLY.ordinal()) {
            return RecordType.VALUE_ONLY;
        }
        if (recTypeInt == RecordType.END_OF_FILE.ordinal()) {
            return RecordType.END_OF_FILE;
        }
        throw new RuntimeException(String.format("unsupported record type: %d", recTypeInt));
    }

    private void write(OutputStream os, Pair<SearchResult, SearchResult> kvSr) throws IOException {
        SearchResult key = kvSr.first();
        SearchResult val = kvSr.second();
        this.write(os, RecordType.KEY_VALUE);
        SearchResultFactory.write(os, key);
        SearchResultFactory.write(os, val);
    }

    private SplunkRecord readSR(InputStream is) {
        try {
            RecordType recType = this.readRecordType(is);
            if (recType.equals((Object)RecordType.END_OF_FILE)) {
                return null;
            }
            SearchResult keySr = null;
            SearchResult valSr = null;
            if (recType.equals((Object)RecordType.KEY_VALUE)) {
                keySr = SearchResultFactory.readSr(is);
                valSr = SearchResultFactory.readSr(is);
                return new SplunkKVRecord(keySr, valSr);
            }
            valSr = SearchResultFactory.readSr(is);
            return new SplunkRecord(valSr);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Override
    public Iterator<SplunkRecord> read(Flushable flushable, InputStream is) {
        try {
            final BufferedInputStream bis = new BufferedInputStream(is);
            return new Iterator<SplunkRecord>(){
                private SplunkRecord sr;
                private boolean eof = false;

                @Override
                public boolean hasNext() {
                    if (this.sr != null) {
                        return true;
                    }
                    if (this.eof) {
                        return false;
                    }
                    this.sr = NativeSerdes.this.readSR(bis);
                    if (this.sr == null) {
                        this.eof = true;
                        return false;
                    }
                    return true;
                }

                @Override
                public SplunkRecord next() {
                    if (this.sr == null && !this.hasNext()) {
                        logger.error((Object)String.format("no records available in temp", new Object[0]));
                        throw new RuntimeException(String.format("no records available in temp", new Object[0]));
                    }
                    SplunkRecord ret = this.sr;
                    this.sr = null;
                    return ret;
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void end(Flushable flushable) throws IOException {
        OutputStream os = (OutputStream)flushable.source();
        byte[] end = ByteBuffer.allocate(4).putInt(RecordType.END_OF_FILE.ordinal()).array();
        os.write(end);
    }

    @Override
    public Flushable createWriter(OutputStream os) {
        try {
            final BufferedOutputStream bos = new BufferedOutputStream(os);
            return new Flushable(){
                boolean ended = false;

                @Override
                public void flush() throws IOException {
                    if (this.ended) {
                        return;
                    }
                    bos.flush();
                }

                @Override
                public Object source() {
                    return bos;
                }

                @Override
                public void end() {
                    try {
                        bos.close();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                    this.ended = true;
                }

                @Override
                public boolean ended() {
                    return this.ended;
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void main(String[] args) {
        SearchResult.FieldMeta keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1");
        String keyVal1 = "KeyVal1";
        SearchResult.FieldMeta keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2");
        Integer keyVal2 = 10;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> keyData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] keyFields = new SearchResult.FieldMeta[2];
        Object[] keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        SearchResult keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        SearchResult.FieldMeta valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        String valVal1 = "ValVal1";
        SearchResult.FieldMeta valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        Integer valVal2 = 20;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> valData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] valFields = new SearchResult.FieldMeta[2];
        Object[] valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        SearchResult valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        ArrayList<SplunkKVRecord> kvSrs = new ArrayList<SplunkKVRecord>();
        SplunkKVRecord kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1_1");
        keyVal1 = "KeyVal1_1";
        keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2_1");
        keyVal2 = 30;
        keyData = new SearchResult.SRHashMap();
        keyFields = new SearchResult.FieldMeta[2];
        keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        valVal1 = "ValVal1";
        valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        valVal2 = 40;
        valData = new SearchResult.SRHashMap();
        valFields = new SearchResult.FieldMeta[2];
        valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            NativeSerdes sd = new NativeSerdes();
            Flushable flushable = sd.createWriter(baos);
            sd.write(flushable, kvSrs.iterator());
            sd.end(flushable);
            flushable.flush();
            byte[] serData = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serData);
            Iterator<SplunkRecord> srsIter = sd.read(flushable, bais);
            while (srsIter.hasNext()) {
                SplunkKVRecord locKvSr = (SplunkKVRecord)srsIter.next();
                System.out.println(String.format("deser key: %s, value: %s", locKvSr.getKey().toString(), locKvSr.getVal().toString()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static enum RecordType {
        VALUE_ONLY,
        KEY_VALUE,
        END_OF_FILE;

    }
}

