/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.df.search.FSHMetricsInfo;
import com.splunk.df.search.FSHMetricsInfoList;
import com.splunk.df.search.FSHSidToPeerList;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDataSetInfoList;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultImpl;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.Aggregator;
import com.splunk.df.search.compute.transformers.AggregatorFactory;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.log4j.Logger;

public class SearchResultFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SearchResultFactory.class);
    private static SearchResultFactory singleton = new SearchResultFactory();

    public static SearchResultFactory getInstance() {
        return singleton;
    }

    public static SearchResult.SRHashMap<String, Object> convert(Map<SearchResult.FieldMeta, Object> data) {
        Iterator<Map.Entry<SearchResult.FieldMeta, Object>> entries = data.entrySet().iterator();
        SearchResult.SRHashMap<String, Object> ret = new SearchResult.SRHashMap<String, Object>(data.size());
        while (entries.hasNext()) {
            Map.Entry<SearchResult.FieldMeta, Object> entry = entries.next();
            ret.put(entry.getKey().fieldName(), entry.getValue());
        }
        return ret;
    }

    public static SearchResult.SRHashMap<SearchResult.FieldMeta, Object> convert(Map<String, Object> data, SearchResult.FieldMeta[] fields) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> ret = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(data.size());
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            SearchResult.FieldMeta field = fields[i];
            Object val = data.get(fields[i].fieldName());
            ret.put(field, val);
        }
        return ret;
    }

    private SearchResultFactory() {
    }

    public SearchResult createSearchResult(SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data, SearchResult.FieldMeta[] fields, Object[] values) {
        return new SearchResultImpl(data, fields, values);
    }

    public SearchResult createSearchResult(SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data) {
        int dataSize = data.size();
        SearchResult.FieldMeta[] fields = data.keySet().toArray(new SearchResult.FieldMeta[dataSize]);
        Object[] values = data.values().toArray(new Object[dataSize]);
        return new SearchResultImpl(data, fields, values);
    }

    public SearchResult createSearchResult(SearchResult.FieldMeta[] fields, Object[] values) {
        return new SearchResultImpl(fields, values);
    }

    public SearchResult createSearchResult(List<Pair<SearchResult.FieldMeta, Object>> pairs) {
        return new SearchResultImpl(pairs);
    }

    public SearchResult createSearchResult(SearchResult.FieldMeta[] fieldNames, CSVRecord csvData) {
        return new SearchResultImpl(fieldNames, csvData);
    }

    public SearchResult cloneSearchResult(SearchResult src) {
        return new SearchResultImpl(src);
    }

    public SearchResult createSearchResult(SearchResult.FieldMeta key, Object value) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(2);
        data.put(key, value);
        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[1];
        Object[] fieldValues = new Object[1];
        fieldNames[0] = key;
        fieldValues[0] = value;
        return new SearchResultImpl(data, fieldNames, fieldValues);
    }

    public SearchResult emptyResult() {
        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[]{};
        Object[] fieldValues = new Object[]{};
        return new SearchResultImpl(fieldNames, fieldValues);
    }

    public SearchResult merge(SearchResult lhs, SearchResult rhs) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = lhs.getDataMap();
        data.putAll(rhs.getDataMap());
        int size = lhs.getSize() + rhs.getSize();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
        Object[] vals = new Object[size];
        SearchResult.FieldMeta[] lhsFields = lhs.getFieldNames();
        Object[] lhsVals = lhs.getFieldValues();
        System.arraycopy(lhsFields, 0, fields, 0, lhsFields.length);
        System.arraycopy(lhsVals, 0, vals, 0, lhsVals.length);
        SearchResult.FieldMeta[] rhsFields = rhs.getFieldNames();
        Object[] rhsVals = rhs.getFieldValues();
        System.arraycopy(rhsFields, 0, fields, lhsFields.length, rhsFields.length);
        System.arraycopy(rhsVals, 0, vals, lhsVals.length, rhsVals.length);
        return new SearchResultImpl(data, fields, vals);
    }

    public int compareTo(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return 0;
        }
        if (lhs == rhs) {
            return 0;
        }
        if (!lhs.getClass().equals(rhs.getClass())) {
            if (lhs instanceof Number && rhs instanceof Number) {
                Double lhsDbl = ((Number)lhs).doubleValue();
                Double rhsDbl = ((Number)rhs).doubleValue();
                return lhsDbl.compareTo(rhsDbl);
            }
            return lhs.toString().compareTo(rhs.toString());
        }
        if (lhs instanceof Long) {
            return ((Long)lhs).compareTo((Long)rhs);
        }
        if (lhs instanceof Integer) {
            return ((Integer)lhs).compareTo((Integer)rhs);
        }
        if (lhs instanceof Boolean) {
            return ((Boolean)lhs).compareTo((Boolean)rhs);
        }
        if (lhs instanceof String) {
            return ((String)lhs).compareTo((String)rhs);
        }
        if (lhs instanceof Float) {
            return ((Float)lhs).compareTo((Float)rhs);
        }
        if (lhs instanceof Double) {
            return ((Double)lhs).compareTo((Double)rhs);
        }
        if (lhs instanceof NullField) {
            return ((NullField)lhs).compareTo((NullField)rhs);
        }
        if (lhs instanceof TimeField) {
            return ((TimeField)lhs).compareTo((TimeField)rhs);
        }
        if (lhs instanceof StringField) {
            return ((StringField)lhs).compareTo((StringField)rhs);
        }
        if (lhs instanceof IPAddress) {
            int comp = ((IPAddress)lhs).compareTo((IPAddress)rhs);
            return comp;
        }
        if (lhs instanceof NullField) {
            return ((NullField)lhs).compareTo((NullField)rhs);
        }
        logger.error((Object)("unsupported number type: " + lhs.getClass().getName()));
        throw new RuntimeException("unsupported object: " + lhs.getClass() + ", value: " + lhs);
    }

    public static void write(OutputStream os, StringField sf) throws IOException {
        Utils.write(os, sf.toString());
    }

    public static StringField readStringField(InputStream is) throws IOException {
        String str = Utils.readString(is);
        return new StringField(str);
    }

    private static Number convertToNumber(Object val) {
        if (val instanceof Number) {
            return (Number)val;
        }
        try {
            return Utils.convertToDouble(val.toString());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Object convertToIP(Object val) {
        if (val instanceof IPAddress) {
            return (IPAddress)val;
        }
        String strVal = val.toString();
        try {
            if (InetAddressUtils.isIPv4Address((String)strVal) || InetAddressUtils.isIPv6Address((String)strVal)) {
                IPAddress addr = new IPAddress(InetAddress.getByName(strVal));
                return addr;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return val;
    }

    private static Object autoConvert(Object val) {
        if (val instanceof String || val instanceof StringField) {
            String valStr = val.toString();
            if (InetAddressUtils.isIPv4Address((String)valStr) || InetAddressUtils.isIPv6Address((String)valStr)) {
                try {
                    IPAddress addr = new IPAddress(InetAddress.getByName(valStr));
                    return addr;
                }
                catch (Throwable addr) {
                    return val;
                }
            }
            Number num = SearchResultFactory.convertToNumber(valStr);
            if (num != null) {
                return num;
            }
        }
        return val;
    }

    public Object convertValue(Object val, FieldType fieldType) {
        if (val == null) {
            return null;
        }
        if (fieldType.equals((Object)FieldType.STR)) {
            return val.toString();
        }
        if (fieldType.equals((Object)FieldType.NUM)) {
            Number res = SearchResultFactory.convertToNumber(val);
            return res == null ? val : res;
        }
        if (fieldType.equals((Object)FieldType.IP)) {
            return SearchResultFactory.convertToIP(val);
        }
        return SearchResultFactory.autoConvert(val);
    }

    public static SearchResult.FieldType getType(SearchResult.FieldMeta fieldName) {
        if (fieldName.equals(SPLUNK_TIME_FIELD) || fieldName.equals(SPLUNK_INDEX_TIME_FIELD)) {
            return SearchResult.FieldType.TIME_FIELD;
        }
        return SearchResult.FieldType.STR_FIELD;
    }

    public static StringField createStringField(String str) {
        return new StringField(str);
    }

    private static SearchResult.FieldMeta[] toFieldsArray(List<SearchResult.FieldMeta> fields) {
        int size = fields.size();
        SearchResult.FieldMeta[] ret = new SearchResult.FieldMeta[size];
        for (int i = 0; i < size; ++i) {
            SearchResult.FieldMeta field;
            ret[i] = field = fields.get(i);
        }
        return ret;
    }

    private static Object[] toObjectArray(List<Object> vals) {
        int size = vals.size();
        Object[] ret = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object val;
            ret[i] = val = vals.get(i);
        }
        return ret;
    }

    public SearchResult createSearchResult(SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data, List<SearchResult.FieldMeta> fields, List<Object> values) {
        SearchResult.FieldMeta[] fieldsArr = SearchResultFactory.toFieldsArray(fields);
        Object[] valsArr = SearchResultFactory.toObjectArray(values);
        return this.createSearchResult(data, fieldsArr, valsArr);
    }

    public SearchResult appendToSearchResult(SearchResult sr, SearchResult.FieldMeta fieldName, Object value) {
        SearchResult.FieldMeta[] srFieldNames = sr.getFieldNames();
        Object[] srFieldValues = sr.getFieldValues();
        int size = srFieldNames.length;
        SearchResult.FieldMeta[] retFieldNames = new SearchResult.FieldMeta[size + 1];
        System.arraycopy(srFieldNames, 0, retFieldNames, 0, size);
        retFieldNames[size] = fieldName;
        Object[] retFieldValues = new Object[size + 1];
        System.arraycopy(srFieldValues, 0, retFieldValues, 0, size);
        retFieldValues[size] = value;
        int initialSize = (int)((double)size / 0.75 + 2.0);
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> retData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(initialSize);
        retData.putAll(sr.getDataMap());
        retData.put(fieldName, value);
        return this.createSearchResult(retData, retFieldNames, retFieldValues);
    }

    public SearchResult removeIntermediaries(SearchResult sr) {
        int size = sr.getSize();
        ArrayList<Pair<SearchResult.FieldMeta, Object>> retList = new ArrayList<Pair<SearchResult.FieldMeta, Object>>(size + 1);
        SearchResult.FieldMeta[] fieldNames = sr.getFieldNames();
        Object[] fieldValues = sr.getFieldValues();
        for (int i = 0; i < size; ++i) {
            SearchResult.FieldMeta fieldName = fieldNames[i];
            if (fieldName.isIntermediary()) continue;
            Object fieldValue = fieldValues[i];
            retList.add(new Pair<SearchResult.FieldMeta, Object>(fieldName, fieldValue));
        }
        int retSize = retList.size();
        SearchResult.FieldMeta[] retFieldNames = new SearchResult.FieldMeta[retSize];
        Object[] retFieldValues = new Object[retSize];
        int initialSize = (int)((double)retSize / 0.75 + 2.0);
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> retData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(initialSize);
        for (int i = 0; i < retSize; ++i) {
            Pair foPair = (Pair)retList.get(i);
            SearchResult.FieldMeta retFieldName = (SearchResult.FieldMeta)foPair.first();
            Object retFieldValue = foPair.second();
            retData.put(retFieldName, retFieldValue);
            retFieldNames[i] = retFieldName;
            retFieldValues[i] = retFieldValue;
        }
        return this.createSearchResult(retData, retFieldNames, retFieldValues);
    }

    public boolean containsOnlyNullVals(SearchResult sr) {
        SearchResult.FieldMeta[] fieldNames = sr.getFieldNames();
        Object[] fieldValues = sr.getFieldValues();
        for (int i = 0; i < sr.getSize(); ++i) {
            Object fieldValue;
            SearchResult.FieldMeta fieldName = fieldNames[i];
            if (fieldName.isIntermediary() || (fieldValue = fieldValues[i]) == null) continue;
            return false;
        }
        return true;
    }

    private static void write(OutputStream os, SearchResult.FieldMeta field, Object value) throws IOException {
        SearchResultFactory.writeField(os, field);
        SearchResultFactory.writeValue(os, value);
    }

    private static ValueType getFieldValueType(Object value) {
        if (value == null) {
            return ValueType.NULL_VALUE;
        }
        if (value instanceof String) {
            return ValueType.STRING;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        if (value instanceof Long) {
            return ValueType.LONG;
        }
        if (value instanceof Integer) {
            return ValueType.INTEGER;
        }
        if (value instanceof Aggregator) {
            return ValueType.AGGREGATOR;
        }
        if (value instanceof AggregateValue) {
            return ValueType.AGGREGATOR_VALUE;
        }
        if (value instanceof StringField) {
            return ValueType.STRING_FIELD;
        }
        if (value instanceof Pair) {
            return ValueType.PAIR;
        }
        if (value instanceof ArrayList) {
            return ValueType.ARRAY_LIST;
        }
        if (value instanceof IPAddress) {
            return ValueType.IP_ADDRESS;
        }
        if (value instanceof TimeField) {
            return ValueType.TIME_FIELD;
        }
        if (value instanceof NullField) {
            return ValueType.NULL_FIELD;
        }
        if (value instanceof FederatedDeploymentInfo) {
            return ValueType.FEDERATED_DEPLOYMENT_INFO_VALUE;
        }
        if (value instanceof FederatedDataSetInfo) {
            return ValueType.FEDERATED_DATASET_INFO_VALUE;
        }
        if (value instanceof SplunkSearchEndpoint) {
            return ValueType.SPLUNK_SEARCH_ENDPOINT_VALUE;
        }
        if (value instanceof FederatedDataSetInfoList) {
            return ValueType.FEDERATED_DATASETINFO_LIST_VALUE;
        }
        if (value instanceof FSHSidToPeerList) {
            return ValueType.FSH_SID_TO_PEER_LIST_VALUE;
        }
        if (value instanceof FSHMetricsInfo) {
            return ValueType.FSH_METRICS_INFO;
        }
        if (value instanceof FSHMetricsInfoList) {
            return ValueType.FSH_METRICS_INFO_LIST;
        }
        throw new RuntimeException(String.format("cannot serialize class: %s, value: %s", value.getClass().getName(), value.toString()));
    }

    private static void writeValue(OutputStream os, Object value) throws IOException {
        int type = SearchResultFactory.getFieldValueType(value).ordinal();
        Utils.write(os, type);
        if (type == ValueType.STRING.ordinal()) {
            Utils.write(os, (String)value);
        } else if (type == ValueType.INTEGER.ordinal()) {
            Utils.write(os, (Integer)value);
        } else if (type == ValueType.DOUBLE.ordinal()) {
            Utils.write(os, (Double)value);
        } else if (type == ValueType.LONG.ordinal()) {
            Utils.write(os, (Long)value);
        } else if (type == ValueType.AGGREGATOR.ordinal()) {
            AggregatorFactory.write(os, (Aggregator)value);
        } else if (type == ValueType.AGGREGATOR_VALUE.ordinal()) {
            AggregatorFactory.write(os, (AggregateValue)value);
        } else if (type == ValueType.STRING_FIELD.ordinal()) {
            SearchResultFactory.write(os, (StringField)value);
        } else if (type == ValueType.PAIR.ordinal()) {
            SearchResultFactory.writePairValue(os, (Pair)value);
        } else if (type == ValueType.ARRAY_LIST.ordinal()) {
            SearchResultFactory.writeArrayList(os, (ArrayList)value);
        } else if (type == ValueType.IP_ADDRESS.ordinal()) {
            SearchResultFactory.writeIPAddress(os, (IPAddress)value);
        } else if (type == ValueType.TIME_FIELD.ordinal()) {
            SearchResultFactory.writeTimeField(os, (TimeField)value);
        } else if (type == ValueType.NULL_FIELD.ordinal()) {
            SearchResultFactory.writeNullField(os, (NullField)value);
        } else if (type == ValueType.NULL_VALUE.ordinal()) {
            SearchResultFactory.writeNullValue(os);
        } else if (type == ValueType.FEDERATED_DEPLOYMENT_INFO_VALUE.ordinal()) {
            FederatedDeploymentInfo.write(os, (FederatedDeploymentInfo)value);
        } else if (type == ValueType.FEDERATED_DATASET_INFO_VALUE.ordinal()) {
            FederatedDataSetInfo.write(os, (FederatedDataSetInfo)value);
        } else if (type == ValueType.SPLUNK_SEARCH_ENDPOINT_VALUE.ordinal()) {
            SplunkSearchEndpoint.write(os, (SplunkSearchEndpoint)value);
        } else if (type == ValueType.FEDERATED_DATASETINFO_LIST_VALUE.ordinal()) {
            FederatedDataSetInfoList.write(os, (FederatedDataSetInfoList)value);
        } else if (type == ValueType.FSH_SID_TO_PEER_LIST_VALUE.ordinal()) {
            FSHSidToPeerList.write(os, (FSHSidToPeerList)value);
        } else if (type == ValueType.FSH_METRICS_INFO.ordinal()) {
            FSHMetricsInfo.write(os, (FSHMetricsInfo)value);
        } else if (type == ValueType.FSH_METRICS_INFO_LIST.ordinal()) {
            FSHMetricsInfoList.write(os, (FSHMetricsInfoList)value);
        } else {
            throw new RuntimeException(String.format("cannot serialize: class: %s, value: %s", value.getClass().getName(), value.toString()));
        }
    }

    public static void writeNullValue(OutputStream os) {
    }

    private static void writeTimeField(OutputStream os, TimeField time) throws IOException {
        Double t = time.time;
        if (t == null) {
            Utils.write(os, 0);
        } else {
            Utils.write(os, 1);
            Utils.write(os, t);
        }
        String timeStr = time.timeStr;
        if (timeStr == null) {
            Utils.write(os, 0);
        } else {
            Utils.write(os, 1);
            Utils.write(os, timeStr);
        }
        int hashCode = time.hashCode;
        Utils.write(os, hashCode);
    }

    private static void writeNullField(OutputStream os, NullField nullField) throws IOException {
        Utils.write(os, nullField.unequal);
    }

    private static void writeIPAddress(OutputStream os, IPAddress addr) throws IOException {
        int[] bytes = addr.bytes;
        if (bytes == null) {
            Utils.write(os, 0);
            return;
        }
        Utils.write(os, 1);
        int len = bytes.length;
        Utils.write(os, len);
        for (int i = 0; i < len; ++i) {
            Utils.write(os, bytes[i]);
        }
        Utils.write(os, addr.hashCode);
    }

    public static void writeArrayList(OutputStream os, ArrayList al) throws IOException {
        int len = al.size();
        Utils.write(os, len);
        for (Object elem : al) {
            Utils.write(os, elem.toString());
        }
    }

    private static void writePairValue(OutputStream os, Pair pair) throws IOException {
        Object first = pair.first();
        Object second = pair.second();
        SearchResultFactory.writeValue(os, first);
        SearchResultFactory.writeValue(os, second);
    }

    private static void writeField(OutputStream os, SearchResult.FieldMeta field) throws IOException {
        Utils.write(os, field.fieldName());
        Utils.write(os, field.isIntermediary());
    }

    public static void write(OutputStream os, SearchResult sr) throws IOException {
        SearchResultImpl srImpl = (SearchResultImpl)sr;
        long seed = srImpl._getSeed();
        Utils.write(os, seed);
        String sid = srImpl._getSid();
        if (sid == null) {
            sid = "";
        }
        Utils.write(os, sid);
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = sr.getDataMap();
        int len = data.size();
        Utils.write(os, len);
        for (Map.Entry entry : data.entrySet()) {
            SearchResult.FieldMeta field = (SearchResult.FieldMeta)entry.getKey();
            Object value = entry.getValue();
            SearchResultFactory.write(os, field, value);
        }
    }

    private static Object readValue(InputStream is) throws IOException {
        int valType = Utils.readInt(is);
        if (valType == ValueType.STRING.ordinal()) {
            return Utils.readString(is);
        }
        if (valType == ValueType.INTEGER.ordinal()) {
            return Utils.readInt(is);
        }
        if (valType == ValueType.DOUBLE.ordinal()) {
            return Utils.readDouble(is);
        }
        if (valType == ValueType.LONG.ordinal()) {
            return Utils.readLong(is);
        }
        if (valType == ValueType.AGGREGATOR.ordinal()) {
            return AggregatorFactory.readAggregator(is);
        }
        if (valType == ValueType.AGGREGATOR_VALUE.ordinal()) {
            return AggregatorFactory.readAggregatorValue(is);
        }
        if (valType == ValueType.PAIR.ordinal()) {
            return SearchResultFactory.readPairValue(is);
        }
        if (valType == ValueType.STRING_FIELD.ordinal()) {
            return SearchResultFactory.readStringField(is);
        }
        if (valType == ValueType.ARRAY_LIST.ordinal()) {
            return SearchResultFactory.readArrayList(is);
        }
        if (valType == ValueType.IP_ADDRESS.ordinal()) {
            return SearchResultFactory.readIPAddress(is);
        }
        if (valType == ValueType.TIME_FIELD.ordinal()) {
            return SearchResultFactory.readTimeField(is);
        }
        if (valType == ValueType.NULL_FIELD.ordinal()) {
            return SearchResultFactory.readNullField(is);
        }
        if (valType == ValueType.NULL_VALUE.ordinal()) {
            return null;
        }
        if (valType == ValueType.FEDERATED_DEPLOYMENT_INFO_VALUE.ordinal()) {
            return FederatedDeploymentInfo.read(is);
        }
        if (valType == ValueType.FEDERATED_DATASET_INFO_VALUE.ordinal()) {
            return FederatedDataSetInfo.read(is);
        }
        if (valType == ValueType.SPLUNK_SEARCH_ENDPOINT_VALUE.ordinal()) {
            return SplunkSearchEndpoint.read(is);
        }
        if (valType == ValueType.FEDERATED_DATASETINFO_LIST_VALUE.ordinal()) {
            return FederatedDataSetInfoList.read(is);
        }
        if (valType == ValueType.FSH_SID_TO_PEER_LIST_VALUE.ordinal()) {
            return FSHSidToPeerList.read(is);
        }
        if (valType == ValueType.FSH_METRICS_INFO.ordinal()) {
            return FSHMetricsInfo.read(is);
        }
        if (valType == ValueType.FSH_METRICS_INFO_LIST.ordinal()) {
            return FSHMetricsInfoList.read(is);
        }
        throw new RuntimeException(String.format("cannot deserialize value type: %d", valType));
    }

    private static NullField readNullField(InputStream is) throws IOException {
        boolean unequal = Utils.readBoolean(is);
        return new NullField(unequal);
    }

    private static TimeField readTimeField(InputStream is) throws IOException {
        boolean isTimeStrPresent;
        boolean isTimePresent = Utils.readInt(is) == 1;
        Double time = null;
        if (isTimePresent) {
            time = Utils.readDouble(is);
        }
        String timeStr = null;
        boolean bl = isTimeStrPresent = Utils.readInt(is) == 1;
        if (isTimeStrPresent) {
            timeStr = Utils.readString(is);
        }
        int hashCode = Utils.readInt(is);
        return new TimeField(time, timeStr, hashCode);
    }

    private static IPAddress readIPAddress(InputStream is) throws IOException {
        boolean dataPresent;
        boolean bl = dataPresent = Utils.readInt(is) == 1;
        if (!dataPresent) {
            return new IPAddress();
        }
        int len = Utils.readInt(is);
        int[] bytes = new int[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = Utils.readInt(is);
        }
        int hashCode = Utils.readInt(is);
        return new IPAddress(bytes, hashCode);
    }

    public static ArrayList readArrayList(InputStream is) throws IOException {
        int len = Utils.readInt(is);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            String elem = Utils.readString(is);
            ret.add(elem);
        }
        return ret;
    }

    private static Pair readPairValue(InputStream is) throws IOException {
        Object first = SearchResultFactory.readValue(is);
        Object second = SearchResultFactory.readValue(is);
        return new Pair<Object, Object>(first, second);
    }

    public static SearchResult readSr(InputStream is) {
        try {
            long seed = Utils.readLong(is);
            String sid = Utils.readString(is);
            int numFields = Utils.readInt(is);
            if (numFields < 0) {
                return null;
            }
            SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(numFields);
            SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[numFields];
            Object[] fieldValues = new Object[numFields];
            for (int i = 0; i < numFields; ++i) {
                SearchResult.FieldMeta fieldName = SearchResultFactory.readField(is);
                Object fieldValue = SearchResultFactory.readValue(is);
                fieldNames[i] = fieldName;
                fieldValues[i] = fieldValue;
                data.put(fieldName, fieldValue);
            }
            SearchResult sr = SearchResultFactory.getInstance().createSearchResult(data, fieldNames, fieldValues);
            SearchResultImpl srImpl = (SearchResultImpl)sr;
            srImpl._setSeed(seed);
            srImpl._setSid(sid);
            return sr;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static SearchResult.FieldMeta readField(InputStream is) throws IOException {
        String fieldName = Utils.readString(is);
        boolean intermediary = Utils.readBoolean(is);
        return SearchResult.FieldMeta.newFieldMeta_(fieldName, intermediary);
    }

    public static class IPAddress
    implements Comparable<IPAddress>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int[] bytes;
        private int hashCode = -1;

        private IPAddress() {
        }

        private IPAddress(int[] bytes, int hashCode) {
            this.bytes = bytes;
            this.hashCode = hashCode;
        }

        IPAddress(InetAddress addr) {
            byte[] bytes = addr.getAddress();
            int len = bytes.length;
            this.bytes = new int[len];
            this.hashCode = 1;
            for (int i = 0; i < len; ++i) {
                this.bytes[i] = 0xFF & bytes[i];
                this.hashCode = this.hashCode * 32 + this.bytes[i];
            }
        }

        @Override
        public int compareTo(IPAddress rhs) {
            int len = this.bytes.length;
            for (int i = 0; i < len; ++i) {
                int lhsByte = this.bytes[i];
                int rhsByte = rhs.bytes[i];
                if (lhsByte > rhsByte) {
                    return 1;
                }
                if (lhsByte >= rhsByte) continue;
                return -1;
            }
            return 0;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof IPAddress)) {
                return false;
            }
            IPAddress rhsAddr = (IPAddress)rhs;
            int len = this.bytes.length;
            for (int i = 0; i < len; ++i) {
                int lhsByte = this.bytes[i];
                int rhsByte = rhsAddr.bytes[i];
                if (lhsByte == rhsByte) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            int len = this.bytes.length;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                int b = this.bytes[i];
                sb.append(b);
                if (i >= len - 1) continue;
                sb.append(".");
            }
            return sb.toString();
        }
    }

    public static class TimeField
    implements Comparable<TimeField>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Double time;
        private String timeStr;
        private final int hashCode;
        private static final String[] datePatterns = new String[]{"yyyy.MM.dd G 'at' HH:mm:ss z", "EEE, MMM d, ''yy", "h:mm a", "hh 'o''clock' a, zzzz", "K:mm a, z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "EEE, d MMM yyyy HH:mm:ss Z", "yyMMddHHmmssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "YYYY-'W'ww-u", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm zzzz", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSzzzz", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd", "yyyyMMdd", "dd/MM/yy", "dd/MM/yyyy", "dd/MM/yyyy:HH:mm:ss", "dd/MM/yyyy HH:mm:ss"};

        private TimeField(Double time, String timeStr, int hashCode) {
            this.time = time;
            this.timeStr = timeStr;
            this.hashCode = hashCode;
        }

        public TimeField(String timeStr) {
            this.timeStr = timeStr;
            if (timeStr != null) {
                timeStr = timeStr.trim();
            }
            if (timeStr == null || timeStr.isEmpty()) {
                this.time = -1.0;
                this.hashCode = this.time.hashCode();
                return;
            }
            try {
                this.time = Double.valueOf(timeStr);
            }
            catch (NumberFormatException nex) {
                for (String format : datePatterns) {
                    try {
                        Date date = DateUtils.parseDate((String)timeStr, (String[])datePatterns);
                        this.time = date.getTime();
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
            if (this.time == null) {
                throw new IllegalArgumentException("Unable to parse " + timeStr);
            }
            this.hashCode = this.time.hashCode();
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof TimeField)) {
                return false;
            }
            TimeField rhsTime = (TimeField)rhs;
            return this.time.equals(rhsTime.time);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public Double getTime() {
            return this.time;
        }

        @Override
        public int compareTo(TimeField rhs) {
            return this.time.compareTo(rhs.time);
        }

        public String toString() {
            return this.timeStr;
        }
    }

    public static class NullField
    implements Comparable<NullField>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean unequal;

        public NullField(boolean unequal) {
            this.unequal = unequal;
        }

        @Override
        public int compareTo(NullField o) {
            return 0;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            return !this.unequal;
        }

        public String toString() {
            return "__null__";
        }

        public int hashCode() {
            if (this.unequal) {
                return super.hashCode();
            }
            return this.toString().hashCode();
        }
    }

    public static class StringField
    implements Comparable<StringField>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String str;

        StringField() {
        }

        StringField(String str) {
            this.str = str;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof StringField)) {
                return false;
            }
            StringField rhsStr = (StringField)rhs;
            return this.str.equals(rhsStr.str);
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        @Override
        public int compareTo(StringField rhs) {
            String rhsStr = rhs.str;
            return this.str.compareTo(rhsStr);
        }

        public String toString() {
            return this.str;
        }
    }

    private static enum ValueType {
        STRING,
        LONG,
        DOUBLE,
        INTEGER,
        AGGREGATOR,
        AGGREGATOR_VALUE,
        STRING_FIELD,
        PAIR,
        ARRAY_LIST,
        IP_ADDRESS,
        TIME_FIELD,
        NULL_FIELD,
        NULL_VALUE,
        FEDERATED_DEPLOYMENT_INFO_VALUE,
        FEDERATED_DATASET_INFO_VALUE,
        SPLUNK_SEARCH_ENDPOINT_VALUE,
        FEDERATED_DATASETINFO_LIST_VALUE,
        FSH_SID_TO_PEER_LIST_VALUE,
        FSH_METRICS_INFO,
        FSH_METRICS_INFO_LIST;

    }
}

