/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCCallable;
import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFSExecutorService;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.DFSSearchCoordinatorState;
import com.splunk.df.search.DFSSearchExecutor;
import com.splunk.df.search.SearchResultInfoUtils;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.DFSLogger;
import com.splunk.logging.HttpEventCollectorSender;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.json.JSONException;
import org.json.JSONObject;

public class DFSSearchCoordinator
implements DFSSearchConstants {
    static Logger logger = DFSLogger.getLogger(DFSSearchCoordinator.class);
    private final String dfcId;
    private int dfsCoordinatorPort;
    private final int dfsMasterPort;
    private final int dfwReceivingDataPort;
    private final int dfwReceivingDataPortCount;
    private JavaSparkContext[] jscs = new JavaSparkContext[1];
    private String initialSid;
    private final int dfcNumCores;
    private final int dfcNumExecutors;
    private final int dfcExecutorMemMbs;
    private final int dfcDriverMemMbs;
    private final int dfcNumConcurrentSearches;
    private final long maxSearchResultSize;
    private final long maxReducePartitionSize;
    private final SplunkReleaseVersion splunkVersion;
    private final String splunkConf;
    SearchResultInfoUtils searchResultInfoUtils;
    private Boolean shutdownInProgress = Boolean.FALSE;
    private boolean isDfsInstrumentationEnabled;
    private final boolean lowLatencyMode;
    private final DFCParams dfcParamsObj;
    private final DFSExecutorService searchExecutorSes;

    public DFSSearchCoordinator(DFCParams dfcParams) {
        this.dfcParamsObj = dfcParams;
        this.lowLatencyMode = dfcParams.getLowLatencyMode();
        this.dfcId = dfcParams.getDfcId();
        this.dfsCoordinatorPort = dfcParams.getDfcPort();
        this.dfsMasterPort = dfcParams.getDfmMasterPort();
        this.maxSearchResultSize = dfcParams.getMaxSearchResultSize();
        this.maxReducePartitionSize = dfcParams.getMaxReducePartitionSize();
        this.dfwReceivingDataPort = dfcParams.getDfwReceivingDataPort();
        this.dfwReceivingDataPortCount = dfcParams.getDfwReceivingDataPortCount();
        this.initialSid = dfcParams.getSid();
        this.dfcNumCores = dfcParams.getDfcNumCores();
        this.dfcNumExecutors = dfcParams.getDfcNumExecutors();
        this.dfcExecutorMemMbs = dfcParams.getDfcExecutorMemMbs();
        this.dfcDriverMemMbs = dfcParams.getDfcDriverMemMbs();
        this.dfcNumConcurrentSearches = dfcParams.getDfcNumConcurrentSearches();
        this.searchExecutorSes = new DFSExecutorService();
        this.splunkVersion = new SplunkReleaseVersion(dfcParams.getSplunkVersion());
        this.splunkConf = dfcParams.getSplunkConf();
        this.isDfsInstrumentationEnabled = dfcParams.isDfsInstrumentationEnabled();
        logger.info((Object)String.format("executor memory mbs: %d, driver memory mbs: %d, num concurrent searches: %d", this.dfcExecutorMemMbs, this.dfcDriverMemMbs, this.dfcNumConcurrentSearches));
        this.startComputeEngineStateMonitoring();
    }

    public SplunkReleaseVersion getSplunkVersion() {
        return this.splunkVersion;
    }

    private void startComputeEngineStateMonitoring() {
        this.searchExecutorSes.submit(new DFCCallable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object runInternal() throws Exception {
                while (true) {
                    JavaSparkContext sc;
                    if ((sc = DFSSearchCoordinator.this.jscs[0]) != null && sc.sc().isStopped()) {
                        Boolean bl = DFSSearchCoordinator.this.shutdownInProgress;
                        synchronized (bl) {
                            if (!DFSSearchCoordinator.this.shutdownInProgress.booleanValue()) {
                                logger.info((Object)String.format("since shutdown is not in progress will have to inform DFS master that DFC spark context is shutdown", new Object[0]));
                                DFSSearchCoordinator.this.informMasterDfcShutdown();
                            } else {
                                logger.info((Object)String.format("DFC spark context has been shutdown but there is shutdown already in progress hence not informing the DFM again", new Object[0]));
                            }
                        }
                        logger.warn((Object)String.format("dfc compute engine state is stopped hence will shutdown dfc for id: %s", DFSSearchCoordinator.this.dfcId));
                        System.exit(-1);
                    }
                    Thread.sleep(10000L);
                }
            }

            @Override
            public Object runOnFailure(Throwable throwable) throws Exception {
                return null;
            }
        });
    }

    private static long getMaxRdOutRecords() {
        long numRdoutRecs = 1000000000L;
        String temp = System.getenv("MAX_NUM_RDOUT_RECORDS");
        if (temp != null) {
            numRdoutRecs = Long.valueOf(temp);
        }
        return numRdoutRecs;
    }

    private static ServerSocket createListener(int port) {
        while (true) {
            if (port > 65535) {
                throw new DFSException("Max allowed port to start dfc listener is reached.");
            }
            try {
                return new ServerSocket(port, 0, InetAddress.getByName(null));
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Could not start dfc listener on port: %d, will retry with next available port", port));
                ++port;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ServerSocket listener = null;
        Socket socket = null;
        try {
            listener = DFSSearchCoordinator.createListener(this.dfsCoordinatorPort);
            this.dfsCoordinatorPort = listener.getLocalPort();
            logger.info((Object)String.format("Started DFC listener on: %s", listener.getLocalSocketAddress().toString()));
            this.informMasterDfcRunning();
            this.getSSLConfigFromDFM();
            while ((socket = listener.accept()) != null) {
                logger.debug((Object)String.format("Received connection on dfs search coordinator: %d", this.dfsCoordinatorPort));
                boolean keepalive = socket.getKeepAlive();
                if (!keepalive) {
                    socket.setKeepAlive(true);
                }
                final Socket temps = socket;
                final long startConnect = System.currentTimeMillis();
                this.searchExecutorSes.submit(new DFCCallable(){

                    @Override
                    protected Object runInternal() throws Exception {
                        StringBuilder input = new StringBuilder();
                        BufferedReader br = new BufferedReader(new InputStreamReader(temps.getInputStream(), StandardCharsets.UTF_8));
                        switch (DFSSearchCoordinator.this.checkRequest(br, input)) {
                            case PROTO_DFS_NEW_SEARCH_REQUEST: {
                                OutputStream rawos = temps.getOutputStream();
                                DFSSearchCoordinator.this.executeNewRequest(input, br, rawos, temps, startConnect);
                                break;
                            }
                            case PROTO_DFS_SHUTDOWN: {
                                DFSSearchCoordinator.this.executeShutDown(input);
                                break;
                            }
                            case PROTO_DFS_SEARCH_COORDINATOR_UPDATE: {
                                DFSSearchCoordinator.this.executeSearchUpdate();
                                break;
                            }
                            case PROTO_DFS_COORDINATOR_STATUS: {
                                DFSSearchCoordinator.this.executeCoordinatorStatusRequest(new BufferedWriter(new OutputStreamWriter(temps.getOutputStream())));
                                break;
                            }
                            case PROTO_DFS_MONITOR_REQ: {
                                break;
                            }
                            default: {
                                logger.error((Object)"Search sent incorrect message to DFS coordinator");
                                DFSSearchCoordinator.this.executeInvalidRequest();
                            }
                        }
                        return null;
                    }

                    @Override
                    protected Object runOnFailure(Throwable throwable) throws Exception {
                        SearchResultInfoUtils.sendAckError(Thread.currentThread(), temps.getOutputStream(), throwable);
                        DFSSearchCoordinator.this.informMasterDfcShutdown();
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Could not start dfc instance for id: %s", this.dfcId), t);
        }
        finally {
            try {
                if (listener != null) {
                    listener.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error Trying to close listener:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    private static boolean canShutdownDfc() {
        boolean shutdown = true;
        String shutdownStr = System.getenv("DFS_CAN_SHUTDOWN_DFC");
        if (shutdownStr != null) {
            try {
                shutdown = Boolean.valueOf(shutdownStr);
            }
            catch (Throwable t) {
                logger.info((Object)String.format("could not parse can shutdown envvar: %s, reason: %s", shutdownStr, t.getMessage()));
            }
        }
        return shutdown;
    }

    protected void executeShutDown(StringBuilder input) {
        boolean shutdownDfc = DFSSearchCoordinator.canShutdownDfc();
        if (shutdownDfc) {
            logger.info((Object)("DFC service shutdown requested:" + input));
            if (this.jscs[0] != null) {
                this.jscs[0].stop();
            }
        } else {
            logger.info((Object)String.format("received request to shutdown dfc but ignored: %s", input));
        }
    }

    private void informMasterDfcRunning() {
        logger.info((Object)("DFC has come up and notifying DFM --dfm port:" + this.dfsMasterPort));
        try {
            Socket toSend = new Socket("127.0.0.1", this.dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(toSend.getOutputStream()));
            String payload = String.format("%s,%s,%d,%s,%d\n", DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString(), this.dfcId, DFSSearchCoordinatorState.RUNNING.ordinal(), this.initialSid, this.dfsCoordinatorPort);
            bw.write(payload);
            bw.flush();
            toSend.close();
        }
        catch (Throwable t) {
            logger.error((Object)t);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informMasterDfcShutdown() {
        try {
            Boolean bl = this.shutdownInProgress;
            synchronized (bl) {
                this.shutdownInProgress = true;
            }
            logger.info((Object)String.format("marked shutdown in progress so that we don't re-inform DFM when we discover that the DFC spark context has gone down", new Object[0]));
            long start = System.currentTimeMillis();
            Socket toSend = new Socket("127.0.0.1", this.dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(toSend.getOutputStream()));
            String payload = String.format("%s,%s,%d,%s,%d\n", DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString(), this.dfcId, DFSSearchCoordinatorState.SHUTDOWN.ordinal(), this.initialSid, this.dfsCoordinatorPort);
            bw.write(payload);
            bw.flush();
            toSend.close();
            logger.info((Object)String.format("Informed DFS master that DFC will be shutdown: dfc id: %s, time taken: %d millis", this.dfcId, System.currentTimeMillis() - start));
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Could not inform master of dfc shutdown: %s", t.getMessage()), t);
        }
    }

    private void getSSLConfigFromDFM() {
        try {
            Socket socketToGetSSLConfig = new Socket("127.0.0.1", this.dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socketToGetSSLConfig.getOutputStream()));
            String payload = String.format("%s\n", DFSProtocolConstants.PROTO_DFS_SSL_CONFIG_REQ.toString());
            bw.write(payload);
            bw.flush();
            logger.info((Object)"Send SSLConfig Request");
            BufferedReader br = new BufferedReader(new InputStreamReader(socketToGetSSLConfig.getInputStream()));
            SSLConfig.getInstance(br.readLine());
            socketToGetSSLConfig.close();
            logger.info((Object)"Received SSLConfig Info");
        }
        catch (Throwable t) {
            logger.error((Object)"Cannot get SSLConfig from DFM", t);
            throw new RuntimeException(t);
        }
    }

    private void executeInvalidRequest() {
    }

    private void executeSearchUpdate() {
    }

    private void executeCoordinatorStatusRequest(BufferedWriter writeToSplunkSearchProces) {
        logger.info((Object)String.format("Received request for DFC status", new Object[0]));
        try {
            String payload = "dfc.running";
            if (this.jscs[0] != null && this.jscs[0].sc().isStopped()) {
                payload = "dfc.stopped";
                logger.warn((Object)String.format("Compute engine context is stopped hence this DFC should be shutdown", new Object[0]));
            }
            writeToSplunkSearchProces.write(String.format("%s\n", payload));
            writeToSplunkSearchProces.flush();
            writeToSplunkSearchProces.close();
            if (this.jscs[0] != null && this.jscs[0].sc().isStopped()) {
                logger.warn((Object)String.format("Shutting down dfc since compute engine is stopped", new Object[0]));
                System.exit(-1);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
            throw new RuntimeException(t);
        }
    }

    private void executeNewRequest(StringBuilder blob, BufferedReader br, OutputStream rawos, Socket connection, long startConnect) throws JSONException {
        JSONObject dfsObject = new JSONObject(blob.toString());
        String searchId = dfsObject.getString(DFSProtocolConstants.PROTO_DFS_SID.toString());
        logger.info((Object)("Received search id" + searchId));
        if (this.jscs[0] != null && this.isDfsInstrumentationEnabled) {
            String appId = this.jscs[0].sc().applicationId();
            String appName = this.jscs[0].appName();
            String sri = dfsObject.getString("sri").replace("\\\"", "\"");
            String dfsQuery = "";
            try {
                CSVParser csvParser = new CSVParser((Reader)new StringReader(sri), CSVFormat.DEFAULT.withHeader(new String[0]));
                List csvRecordList = csvParser.getRecords();
                dfsQuery = ((CSVRecord)csvRecordList.get(0)).get("_search");
                csvParser.close();
            }
            catch (Exception e) {
                logger.error((Object)"Exception Caught!!", (Throwable)e);
            }
            String url = this.jscs[0].sc().getConf().get("spark.metrics.conf.*.sink.splunk.url");
            String token = this.jscs[0].sc().getConf().get("spark.metrics.conf.*.sink.splunk.token");
            logger.info((Object)String.format("DFS Instrumentation HEC Endpoint: %s, DFS Instrumentation HEC token: %s", url, token));
            HttpEventCollectorSender splunkSender = new HttpEventCollectorSender(url, token, "", "", 10000L, 10L, 10240L, "sequential", this.getMetadata());
            splunkSender.disableCertificateValidation();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("appId", appId);
            fields.put("appName", appName);
            fields.put("searchId", searchId);
            fields.put("dfsQuery", dfsQuery);
            splunkSender.send("", "dfsJobInfo", "", "", fields, "", (Serializable)((Object)""));
            splunkSender.flush();
        }
        this.searchResultInfoUtils = new SearchResultInfoUtils(rawos, this.getSearchResultsInfo((String)dfsObject.get(DFSProtocolConstants.PROTO_DFS_SRI.toString())));
        long maxRdoutRecs = DFSSearchCoordinator.getMaxRdOutRecords();
        int numPars = Math.max(1, (int)(maxRdoutRecs / 150000L));
        logger.info((Object)String.format("Number of rdout records: %d, total number of rdin partitions: %d", maxRdoutRecs, numPars));
        DFSSearchExecutor searchExecutor = new DFSSearchExecutor(this, this.dfcParamsObj, searchId, dfsObject, br, rawos, this.jscs, connection, startConnect, this.dfcNumCores, this.dfcNumExecutors, this.dfcExecutorMemMbs, this.dfcDriverMemMbs, this.dfcNumConcurrentSearches, this.maxSearchResultSize, this.maxReducePartitionSize, this.dfwReceivingDataPort, this.dfwReceivingDataPortCount, this.splunkConf, this.searchExecutorSes, this.searchResultInfoUtils, this.lowLatencyMode);
        this.searchExecutorSes.submit(searchExecutor);
    }

    private SearchResult getSearchResultsInfo(String infocsv) {
        try {
            CSVParser parser = new CSVParser((Reader)new CharArrayReader(infocsv.toCharArray()), CSVFormat.DEFAULT);
            Iterator recs = parser.iterator();
            CSVRecord header = (CSVRecord)recs.next();
            CSVRecord data = (CSVRecord)recs.next();
            int size = header.size();
            SearchResult.SRHashMap<SearchResult.FieldMeta, Object> dataMap = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(size * 2);
            for (int i = 0; i < size; ++i) {
                String field = header.get(i);
                String val = data.get(i);
                dataMap.put(SearchResult.FieldMeta.newFieldMeta(field), val);
            }
            parser.close();
            return SearchResultFactory.getInstance().createSearchResult(dataMap, new SearchResult.FieldMeta[0], new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to deseralize searchResultsInfo");
        }
    }

    private Hashtable<String, String> getMetadata() {
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        try {
            String host = InetAddress.getLocalHost().getHostName();
            metadata.put("host", host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metadata;
    }

    private DFSProtocolConstants checkRequest(BufferedReader br, StringBuilder arguments) throws IOException {
        DFSProtocolConstants status = null;
        String input = br.readLine();
        if (input.startsWith(DFSProtocolConstants.PROTO_DFS_NEW_SEARCH_REQUEST.toString())) {
            input = input.substring(DFSProtocolConstants.PROTO_DFS_NEW_SEARCH_REQUEST.toString().length() + 1);
            status = DFSProtocolConstants.PROTO_DFS_NEW_SEARCH_REQUEST;
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString())) {
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString().length() + 1);
            status = DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE;
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SHUTDOWN;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_COORDINATOR_STATUS.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_COORDINATOR_STATUS;
        }
        if (status == null) {
            status = DFSProtocolConstants.PROTO_DFS_INVALID_REQUEST;
        }
        arguments.append(input);
        return status;
    }

    private static String printArgs(String[] args) {
        StringBuilder sb = new StringBuilder();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            String arg = args[i];
            sb.append(arg);
            if (i >= len - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static void main(String[] dfsArgs) {
        String argsStr = DFSSearchCoordinator.printArgs(dfsArgs);
        logger.info((Object)"Data Fabric Search (DFS) Version: 1.1.1");
        if (logger.isDebugEnabled()) {
            logger.info((Object)String.format("data fabric coordinator launched with params [ %s ]", argsStr));
        }
        System.setProperty("DFC_START_TIME_MILLIS", String.valueOf(System.currentTimeMillis()));
        if (dfsArgs.length < 1) {
            throw new RuntimeException(String.format("DFC launched without path to application arguments!", new Object[0]));
        }
        try {
            String dfcParamPath = dfsArgs[0];
            String dfcParams = new String(Files.readAllBytes(Paths.get(dfcParamPath, new String[0])));
            DFCParams dfcParamsObj = DFCParams.fromJson(dfcParams);
            if (!dfcParamsObj.getLowLatencyMode()) {
                logger.debug((Object)String.format("DFC parameters received from dfc search dispatcher: %s", dfcParamsObj.toString()));
            }
            long dfcLaunchTimeMillis = dfcParamsObj.getDfcLaunchTimeMillis();
            System.setProperty("DFC_LAUNCH_TIME_MILLIS", String.valueOf(dfcLaunchTimeMillis));
            System.setProperty("DFC_EXTRA_KRYO_CLASSES", dfcParamsObj.getExtraKryoClasses());
            DFSSearchCoordinator coord = new DFSSearchCoordinator(dfcParamsObj);
            coord.execute();
            if (coord.jscs[0] != null) {
                coord.jscs[0].stop();
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error starting DFC instance: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("Could not start DFC: %s", t.getMessage()));
        }
    }
}

