/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSSearchConstants;

public class DFSChunkToDispatch
implements DFSSearchConstants {
    private final String sid;
    private final String srSet;
    private final boolean queryFinished;

    public DFSChunkToDispatch(String sid, String srSet, boolean queryFinished) {
        this.sid = sid;
        this.srSet = srSet;
        this.queryFinished = queryFinished;
    }

    public int getSRSetSize() {
        return this.srSet.length();
    }

    public boolean isLastChunk() {
        return this.queryFinished;
    }

    public String getHeader() {
        int qf = this.queryFinished ? 1 : 0;
        return String.format("splunk %d,%s,%d,%d", 345622, this.sid, qf, this.getSRSetSize());
    }

    public static String getLastChunk(String currentSid) {
        return String.format("splunk %d,%s,%d,%d", 345622, currentSid, 1, 0);
    }

    public static String getErrorChunk(String sid) {
        return String.format("splunk %d,%s,%d,%d, %d", 345622, sid, 1, 0, 0);
    }

    public String getSrSet() {
        return this.srSet;
    }
}

