/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.security.DFSSecurityConstants;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;

public class DFCLauncherEmbedded
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFCLauncherEmbedded.class);
    static final String splunkHome = System.getenv("SPLUNK_HOME");
    static String sparkHome = null;
    private SparkAppHandle dfcHandle;
    private SparkLauncher launcher;
    private ArrayList<String> dfcJars = new ArrayList();
    private ArrayList<String> dfcArgs = new ArrayList();

    public DFCLauncherEmbedded(String sparkHome, int dfcCoresPerExecutor, int dfcNumExecutors, int dfcExecutorMemMbs, int dfcDriverMemMbs, int dfcDriverCores, String computeMasterUrl, String dfcMainClass, String dfsJar, final DFCParams dfcParams, final Runnable onFailure, int maxDfcs) {
        DFCLauncherEmbedded.sparkHome = sparkHome;
        String master = computeMasterUrl;
        if (dfcCoresPerExecutor < 1) {
            throw new RuntimeException(String.format("Invalid cores per executor: %d", dfcCoresPerExecutor));
        }
        logger.info((Object)("Using SPARK_HOME from env or splunk server configuration:" + sparkHome));
        if (sparkHome == null) {
            throw new RuntimeException(String.format("SPARK_HOME is not set, please check spark configuration from Splunk server or app configuration.", new Object[0]));
        }
        String executorLogDir = Paths.get("..", "..", dfcParams.getSid()).toString();
        String driverLogDir = Paths.get(System.getenv("SPLUNK_HOME"), "var", "run", "splunk", "dispatch", dfcParams.getSid()).toString();
        if (!new File(sparkHome).exists()) {
            throw new DFSException(logger, "SPARK_HOME is set incorrectly - " + sparkHome);
        }
        double jvmMemStartupRatio = Utils.getJvmStartupRatio();
        int executorStartMemMbs = (int)((double)dfcExecutorMemMbs * jvmMemStartupRatio);
        int driverStartMemMbs = (int)((double)dfcDriverMemMbs * jvmMemStartupRatio);
        logger.info((Object)String.format("executor start mem size: %d mbs, driver start mem size: %d mbs", executorStartMemMbs, driverStartMemMbs));
        String executorExtraJavaOpts = "";
        executorExtraJavaOpts = String.format("%s -XX:hashCode=0", executorExtraJavaOpts);
        executorExtraJavaOpts = String.format("%s -Xms%dm", executorExtraJavaOpts, executorStartMemMbs);
        executorExtraJavaOpts = String.format("%s -D%s=%s", executorExtraJavaOpts, "DISPATCH_DIR", executorLogDir);
        if (DFCLauncherEmbedded.enableRemoteProfiling()) {
            int remoteProfilingPort = DFCLauncherEmbedded.getRemoteProfilingPort();
            executorExtraJavaOpts = String.format("%s -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.port=%d", executorExtraJavaOpts, remoteProfilingPort);
        }
        logger.info((Object)String.format("using executor extra java opts: %s", executorExtraJavaOpts));
        String profilingJavaOpt = "";
        if (DFCLauncherEmbedded.enableDFCProfiling()) {
            int remoteProfilingPort = DFCLauncherEmbedded.getRemoteProfilingPort();
            profilingJavaOpt = String.format(" -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.port=%d", remoteProfilingPort);
        }
        String dfcExtraJavaOpts = String.format("-XX:+CMSClassUnloadingEnabled -XX:hashCode=0 -Xms%dm -D%s=%s%s", driverStartMemMbs, "DISPATCH_DIR", driverLogDir, profilingJavaOpt);
        logger.info((Object)String.format("using dfc extra java opts: %s", dfcExtraJavaOpts));
        try {
            String fileName = dfcParams.getSid() + "_dfc_args.txt";
            String filePath = Paths.get(splunkHome, "var", "run", "splunk", "dispatch", dfcParams.getSid(), fileName).toString();
            File argsFile = new File(filePath);
            argsFile.createNewFile();
            PrintWriter pw = new PrintWriter(argsFile);
            pw.println(dfcParams.toJson());
            pw.close();
            this.launcher = new SparkLauncher().setMainClass(dfcMainClass).setSparkHome(sparkHome).setMaster(master).setConf("spark.executor.cores", String.valueOf(dfcCoresPerExecutor)).setConf("spark.executor.memory", String.format("%dm", dfcExecutorMemMbs)).setConf("spark.driver.memory", String.format("%dm", dfcDriverMemMbs)).setConf("spark.driver.userClassPathFirst", String.valueOf(true)).setConf("spark.driver.cores", String.valueOf(dfcDriverCores)).setConf("spark.port.maxRetries", String.valueOf(maxDfcs * Utils.getDfcPortSpan())).setConf("spark.driver.extraJavaOptions", dfcExtraJavaOpts).setConf("spark.executor.extraJavaOptions", executorExtraJavaOpts).setConf("spark.executorEnv.DFS_SEARCH_LOG_CONFIG_ENABLED", String.valueOf(true));
            if (!Utils.isDfsElasticModeEnabled()) {
                this.launcher = this.launcher.setConf("spark.cores.max", String.valueOf(dfcCoresPerExecutor * dfcNumExecutors));
            }
            this.launcher = this.launcher.setVerbose(false).addAppArgs(new String[]{filePath});
            this.dfcArgs.add(filePath);
            if (dfcParams.isDfsInstrumentationEnabled()) {
                this.launcher.setConf("spark.metrics.conf.*.sink.splunk.url", dfcParams.getDfsInstrumentationHecEndpoint()).setConf("spark.metrics.conf.*.sink.splunk.token", dfcParams.getDfsInstrumentationHecToken()).setConf("spark.metrics.conf.master.source.jvm.class", "org.apache.spark.metrics.source.JvmSource").setConf("spark.metrics.conf.worker.source.jvm.class", "org.apache.spark.metrics.source.JvmSource").setConf("spark.metrics.conf.executor.source.jvm.class", "org.apache.spark.metrics.source.JvmSource").setConf("spark.metrics.conf.driver.source.jvm.class", "org.apache.spark.metrics.source.JvmSource").setConf("spark.metrics.conf.applications.source.jvm.class", "org.apache.spark.metrics.source.JvmSource").setConf("spark.metrics.conf.shuffleService.source.jvm.class", "org.apache.spark.metrics.source.JvmSource");
                DfsInstrumentationMode mode = DfsInstrumentationMode.values()[dfcParams.getDfsInstrumentationMode()];
                switch (mode) {
                    case ALL: {
                        this.launcher.setConf("spark.metrics.conf.*.sink.splunk.class", "com.splunk.df.metrics.SplunkSink").setConf("spark.extraListeners", "com.splunk.df.metrics.SparkMetricsListener");
                        break;
                    }
                    case METRICS: {
                        this.launcher.setConf("spark.metrics.conf.*.sink.splunk.class", "com.splunk.df.metrics.SplunkSink");
                        break;
                    }
                    case LISTENER: {
                        this.launcher.setConf("spark.extraListeners", "com.splunk.df.metrics.SparkMetricsListener");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error launching DFC: %s", e.getMessage()), (Throwable)e);
            throw new DFSException(String.format("Could not launch DFC: %s", e.getMessage()));
        }
        this.launcher.addFile(Paths.get(System.getenv("SPLUNK_HOME"), "etc", "log-dfs-search.cfg").toString());
        SSLConfig sslConfig = SSLConfig.getInstance();
        if (sslConfig.isTlsEnabled() && !sslConfig.isUseSparkSecurityConfigs() && !sslConfig.isUseNodeSpecificCertificates()) {
            if (sslConfig.isOverrideDefaultCertificate()) {
                if (sslConfig.getDFSKeystorePath() == null) {
                    logger.error((Object)"DFS keystore needs to be configured properly");
                    throw new DFSException("Invalid DFS keystore path");
                }
                File ksFile = new File(sslConfig.getDFSKeystorePath());
                if (!ksFile.exists() || !ksFile.isFile()) {
                    logger.error((Object)"DFS keystore needs to be configured properly");
                    throw new DFSException("Invalid DFS keystore path");
                }
                if (sslConfig.getDFSTruststorePath() == null) {
                    logger.error((Object)"DFS truststore needs to be configured properly");
                    throw new DFSException("Invalid DFS truststore path");
                }
                File tsFile = new File(sslConfig.getDFSTruststorePath());
                if (!tsFile.exists() || !tsFile.isFile()) {
                    logger.error((Object)"DFS truststore needs to be configured properly");
                    throw new DFSException("Invalid DFS truststore path");
                }
                this.launcher.addFile(sslConfig.getDFSKeystorePath());
                this.launcher.addFile(sslConfig.getDFSTruststorePath());
            } else {
                this.launcher.addFile(DFSSecurityConstants.DEFAULT_KEYSTORE_PATH);
                this.launcher.addFile(DFSSecurityConstants.DEFAULT_TRUSTSTORE_PATH);
            }
        }
        logger.info((Object)String.format("DFC instance started: cores per executor: %d, executor memory mbs: %s, driver memory mbs: %s, driver cores: %d, total executor cores: %d, num executors: %d", dfcCoresPerExecutor, dfcExecutorMemMbs, dfcDriverMemMbs, dfcDriverCores, dfcCoresPerExecutor * dfcNumExecutors, dfcNumExecutors));
        try {
            logger.debug((Object)"Get the main app resource and all the jar files to be submitted with the application.");
            this.setupLauncherJars(splunkHome);
            if (dfcParams.getLowLatencyMode()) {
                logger.info((Object)String.format("**** dfc with sid: %s will be executed in low latency mode", dfcParams.getSid()));
                DFCLauncherEmbedded.setupJars(String.format("%s/jars", sparkHome), this.dfcJars);
                StringBuilder dfcCmd = new StringBuilder();
                String javaHome = System.getenv("JAVA_HOME");
                if (javaHome == null) {
                    throw new RuntimeException("java home not set");
                }
                double maxMemMbs = dfcDriverMemMbs;
                double minMemMbs = maxMemMbs * 0.75;
                maxMemMbs = Math.ceil(maxMemMbs);
                minMemMbs = Math.ceil(minMemMbs);
                String profilingOpts = "";
                if (DFCLauncherEmbedded.enableRemoteProfiling()) {
                    int remoteProfilingPort = DFCLauncherEmbedded.getRemoteProfilingPort();
                    profilingOpts = String.format("%s -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.port=%d", profilingOpts, remoteProfilingPort);
                }
                dfcCmd.append(javaHome).append(String.format("/bin/java -server -Xmx%dm -Xms%dm %s", (int)maxMemMbs, (int)minMemMbs, profilingOpts)).append(" -cp ");
                logger.info((Object)String.format("initial part of the low latency dfc cmd: %s", dfcCmd.toString()));
                Iterator<String> dfcJarsIter = this.dfcJars.iterator();
                while (dfcJarsIter.hasNext()) {
                    String jarPath = dfcJarsIter.next();
                    dfcCmd.append(jarPath);
                    if (!dfcJarsIter.hasNext()) continue;
                    dfcCmd.append(":");
                }
                dfcCmd.append(String.format(" -D%s=%s ", "DISPATCH_DIR", driverLogDir));
                dfcCmd.append(" ").append(dfcMainClass).append(" ");
                Iterator<String> dfcArgsIter = this.dfcArgs.iterator();
                while (dfcArgsIter.hasNext()) {
                    String dfcArg = dfcArgsIter.next();
                    dfcCmd.append(dfcArg);
                    if (!dfcArgsIter.hasNext()) continue;
                    dfcCmd.append(" ");
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)String.format("about to execute dfc in low latency mode: %s", dfcCmd));
                }
                final Process dfcProc = Runtime.getRuntime().exec(dfcCmd.toString());
                final BufferedReader dfcStdout = new BufferedReader(new InputStreamReader(dfcProc.getInputStream()));
                final BufferedReader dfcStderr = new BufferedReader(new InputStreamReader(dfcProc.getErrorStream()));
                logger.info((Object)"dfc started in low latency mode");
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (dfcProc.isAlive()) {
                            try {
                                if (!dfcStdout.ready() && !dfcStderr.ready()) {
                                    Utils.sleep(10L);
                                }
                                if (dfcStdout.ready()) {
                                    DFCLauncherEmbedded.logStdout(dfcStdout);
                                }
                                if (!dfcStderr.ready()) continue;
                                DFCLauncherEmbedded.logStderr(dfcStderr);
                            }
                            catch (Throwable t) {
                                logger.warn((Object)String.format("error reading from dfc process: %s", t.getMessage()));
                            }
                        }
                        try {
                            if (dfcStdout.ready()) {
                                DFCLauncherEmbedded.logStdout(dfcStdout);
                            }
                            if (dfcStderr.ready()) {
                                DFCLauncherEmbedded.logStderr(dfcStderr);
                            }
                        }
                        catch (Throwable t) {
                            logger.warn((Object)String.format("could not read from dfc: %s", t.getMessage()));
                        }
                        logger.info((Object)String.format("dfc child process for sid: %s ended, ret code: %d", dfcParams.getSid(), dfcProc.exitValue()));
                    }
                });
                t.setDaemon(false);
                t.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            logger.info((Object)String.format("about to shutdown dfc (low latency mode): sid: %s", dfcParams.getSid()));
                            dfcProc.destroy();
                            logger.info((Object)String.format("requested dfc child process to shutdown: %s", dfcParams.getSid()));
                        }
                        catch (Throwable t) {
                            logger.warn((Object)String.format("could not destroy low latency dfc child process: %s", t.getMessage()));
                        }
                    }
                });
            } else {
                this.dfcHandle = this.launcher.startApplication(new SparkAppHandle.Listener[]{new SparkAppHandle.Listener(){

                    public void infoChanged(SparkAppHandle hdl) {
                        logger.info((Object)String.format("DFC launch info changed: %s", hdl.toString()));
                    }

                    public void stateChanged(SparkAppHandle hdl) {
                        SparkAppHandle.State state = hdl.getState();
                        logger.info((Object)String.format("DFC launch state changed: %s", state.name()));
                        if (state.equals((Object)SparkAppHandle.State.KILLED) || state.equals((Object)SparkAppHandle.State.FAILED)) {
                            logger.warn((Object)String.format("DFC state change reported: %s, could be because the engine is shutdown after the search is over", state.toString()));
                            onFailure.run();
                        }
                    }
                }});
                logger.info((Object)"launched dfs in high latency distributed mode");
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            logger.info((Object)String.format("about to kill dfc: %s", dfcParams.getSid()));
                            DFCLauncherEmbedded.this.dfcHandle.kill();
                            logger.info((Object)String.format("requested dfc for shutdown: %s", dfcParams.getSid()));
                        }
                        catch (Throwable t) {
                            logger.info((Object)String.format("could not kill dfc sid: %s, reason: %s", dfcParams.getSid(), t.getMessage()));
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error launching dfc instance: %s", t.getMessage()));
            throw new RuntimeException(t);
        }
    }

    private static void logStdout(BufferedReader stdout) throws IOException {
        String stdoutLine = null;
        while ((stdoutLine = stdout.readLine()) != null) {
            logger.info((Object)String.format("dfc child process stdout: %s", stdoutLine));
        }
    }

    private static void logStderr(BufferedReader stderr) throws IOException {
        String stderrLine = null;
        while ((stderrLine = stderr.readLine()) != null) {
            logger.info((Object)String.format("dfc child process stderr: %s", stderrLine));
        }
    }

    public void finalize() {
        try {
            if (this.dfcHandle != null) {
                this.dfcHandle.kill();
                logger.error((Object)String.format("Killed DFC process since DFC launcher is getting garbage collected, launcher: %s", this.launcher));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void setupJars(String folder, ArrayList<String> jars) {
        try {
            File dir = new File(folder);
            if (!dir.exists()) {
                logger.warn((Object)String.format("folder: %s does not exist", dir.getAbsolutePath()));
                throw new RuntimeException(String.format("dir %s does not exist", dir.getAbsolutePath()));
            }
            if (!dir.isDirectory()) {
                logger.warn((Object)String.format("%s is not a directory", dir.getAbsolutePath()));
                throw new RuntimeException(String.format("%s is not a directory", dir.getAbsolutePath()));
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String filePath = file.getAbsolutePath();
                if (!filePath.endsWith(".jar")) continue;
                jars.add(file.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("error getting list of jars under folder: %s", t.getMessage()));
            throw new RuntimeException(String.format("could not read jars under folder: %s", folder), t);
        }
    }

    private void setupLauncherJars(String splunkHome) throws IOException {
        try {
            Stream<String> stream = Files.lines(Paths.get(splunkHome, "bin", "jars", "dfs_packages.list"));
            stream.forEach(p -> {
                Path path = Paths.get(splunkHome, p);
                if (Files.isRegularFile(path, new LinkOption[0]) && p.endsWith("jar")) {
                    this.addWhiteListedJars(path);
                }
            });
            stream.close();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Error while loading jars from dfs_packages.list: %s", e.getMessage()));
            throw e;
        }
    }

    private void addWhiteListedJars(Path filePath) {
        String[] whiteListedPatterns = new String[]{"^bcpkix-jdk15on(.*)", "^bcprov-jdk15on(.*)", "^commons-ast(.*)", "^commons-csv(.*)", "^splunk(.*)", "^t-digest(.*)", "^json-20180130(.*)", "antlr4-runtime-4.7.jar", "antlr-runtime-3.4.jar", "antlr-2.7.7.jar", "^guava-(.*)"};
        String filename = filePath.getFileName().toString();
        if (filename.startsWith("dfs")) {
            this.launcher.setAppResource(filePath.toString());
            this.dfcJars.add(filePath.toString());
            logger.info((Object)String.format("DFC app resource to be used: %s", filename));
            return;
        }
        for (String pattern : whiteListedPatterns) {
            if (!Pattern.matches(pattern, filename)) continue;
            this.launcher.addJar(filePath.toString());
            this.dfcJars.add(filePath.toString());
            logger.debug((Object)("Included jar: " + filename));
            return;
        }
        logger.debug((Object)String.format("[skip] filename: %s", filename));
    }

    private static boolean enableRemoteProfiling() {
        boolean enable = false;
        String enableStr = System.getenv("DFS_ENABLE_REMOTE_PROFILING");
        if (enableStr != null) {
            try {
                enable = Boolean.valueOf(enableStr);
                logger.info((Object)String.format("enable remote profiling overridden via envvar: %s: %b", "DFS_ENABLE_REMOTE_PROFILING", enable));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s envvar value %s to boolean", "DFS_ENABLE_REMOTE_PROFILING", enableStr));
            }
        }
        logger.info((Object)String.format("using enable remote profiling level: %b", enable));
        return enable;
    }

    private static boolean enableDFCProfiling() {
        boolean enable = false;
        String enableStr = System.getenv("DFS_ENABLE_DFC_PROFILING");
        if (enableStr != null) {
            try {
                enable = Boolean.valueOf(enableStr);
                logger.info((Object)String.format("enable dfc profiling overridden via envvar: %s: %b", "DFS_ENABLE_DFC_PROFILING", enable));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s envvar value %s to boolean", "DFS_ENABLE_DFC_PROFILING", enableStr));
            }
        }
        logger.info((Object)String.format("using enable dfc profiling level: %b", enable));
        return enable;
    }

    private static int getRemoteProfilingPort() {
        int port = 1098;
        String portStr = System.getenv("DFS_EXECUTOR_REMOTE_PROFILING_PORT");
        if (portStr != null) {
            try {
                port = Integer.valueOf(portStr);
                logger.info((Object)String.format("overriding remote executor profiling port using envvar: %s: %d", "DFS_EXECUTOR_REMOTE_PROFILING_PORT", port));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse envvar %s to integer", "DFS_EXECUTOR_REMOTE_PROFILING_PORT"));
            }
        }
        logger.info((Object)String.format("using executor remote profiling port: %d", port));
        return port;
    }

    private static enum DfsInstrumentationMode {
        METRICS,
        LISTENER,
        ALL;

    }
}

