/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.mgmt;

import com.splunk.commons.search.HostPort;
import com.splunk.df.mgmt.DfmDriver;
import com.splunk.modularinput.Argument;
import com.splunk.modularinput.Event;
import com.splunk.modularinput.EventWriter;
import com.splunk.modularinput.InputDefinition;
import com.splunk.modularinput.MalformedDataException;
import com.splunk.modularinput.Scheme;
import com.splunk.modularinput.Script;
import com.splunk.modularinput.SingleValueParameter;
import com.splunk.modularinput.ValidationDefinition;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.storage.StorageLevel;

@Deprecated
public class DfmModularInput
extends Script {
    public static void main(String[] args) {
        new DfmModularInput().run(args);
    }

    public void launchDriverThread(final EventWriter ew, final int numNodes, final int startPort, final int endPort) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                DfmDriver driver = new DfmDriver();
                ew.log(EventWriter.INFO, "About to create Spark context");
                JavaSparkContext jsc = driver.createContext();
                ew.log(EventWriter.INFO, "About to launch monitoring nodes");
                JavaRDD<HostPort> nodes = driver.launchMonitoringNodes(jsc, startPort, endPort, numNodes);
                ew.log(EventWriter.INFO, "Nodes launched. Will now analyze results");
                nodes.persist(StorageLevel.MEMORY_ONLY());
                Iterator hostPorts = nodes.toLocalIterator();
                if (!hostPorts.hasNext()) {
                    ew.log(EventWriter.ERROR, "No monitoring executors were successfully launched. Exiting.");
                    return;
                }
                while (hostPorts.hasNext()) {
                    HostPort hp = (HostPort)hostPorts.next();
                    ew.log(EventWriter.INFO, "hp: " + hp.toString());
                    if (hp.getPort() == -1) {
                        ew.log(EventWriter.ERROR, "Unable to listen on any port in range [" + startPort + ", " + endPort + "] on host " + hp.getHost());
                        jsc.stop();
                        continue;
                    }
                    Event e = new Event();
                    e.setData("Running monitoring node on " + hp.toString());
                    try {
                        ew.synchronizedWriteEvent(e);
                    }
                    catch (MalformedDataException ex) {
                        ew.log(EventWriter.ERROR, "Something went wrong: " + ex.toString());
                    }
                }
                try {
                    Thread.sleep(180000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public Scheme getScheme() {
        Scheme scheme = new Scheme("DFM");
        scheme.setDescription("Data Fabric Monitoring service");
        scheme.setUseExternalValidation(true);
        Argument arg = new Argument("num_executors");
        arg.setDescription("The number of DFM exectuors that should be launched.");
        arg.setRequiredOnCreate(true);
        arg.setDataType(Argument.DataType.NUMBER);
        scheme.addArgument(arg);
        arg = new Argument("start_port");
        arg.setDescription("Beginning of port range to try listening on from worker nodes");
        arg.setRequiredOnCreate(true);
        arg.setDataType(Argument.DataType.NUMBER);
        scheme.addArgument(arg);
        arg = new Argument("end_port");
        arg.setDescription("End of port range to try listening on from worker nodes. May be the same as start_port, but may not be less.");
        arg.setRequiredOnCreate(true);
        arg.setDataType(Argument.DataType.NUMBER);
        scheme.addArgument(arg);
        return scheme;
    }

    public void validateInput(ValidationDefinition definition) throws Exception {
        int numExec = ((SingleValueParameter)definition.getParameters().get("num_executors")).getInt();
        if (numExec < 1) {
            throw new Exception("num_executors must be a positive integer");
        }
    }

    public void streamEvents(InputDefinition inputs, EventWriter ew) throws MalformedDataException, XMLStreamException, IOException {
        int numNodes = -1;
        int startPort = -1;
        int endPort = -1;
        try {
            int numDefs = inputs.getInputs().size();
            ew.log(EventWriter.INFO, "How many defs? " + numDefs);
            ew.log(EventWriter.INFO, "definitions: " + inputs.toString());
            if (numDefs > 1) {
                ew.log(EventWriter.WARN, "Found " + numDefs + " modular input definitions. Expected only one. Which gets used is undefined.");
            }
            for (Map.Entry entry : inputs.getInputs().entrySet()) {
                numNodes = ((SingleValueParameter)((Map)entry.getValue()).get("num_executors")).getInt();
                startPort = ((SingleValueParameter)((Map)entry.getValue()).get("start_port")).getInt();
                endPort = ((SingleValueParameter)((Map)entry.getValue()).get("end_port")).getInt();
            }
        }
        catch (Exception ex) {
            ew.log(EventWriter.ERROR, "Unable use this configuration data: " + inputs.getInputs());
            return;
        }
        Event startEvent = new Event();
        startEvent.setData("Starting DFM. num_nodes=" + numNodes + " start_port=" + startPort + " end_port=" + endPort);
        ew.writeEvent(startEvent);
        ew.log(EventWriter.INFO, "Starting up DfmDriver. Will use numNodes=" + numNodes);
        this.launchDriverThread(ew, numNodes, startPort, endPort);
        while (this.isSplunkRunning()) {
            Event e = new Event();
            e.setData("Heartbeat event sent from DFM modular input");
            ew.writeEvent(e);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    boolean isSplunkRunning() {
        return !System.out.checkError() && !System.err.checkError();
    }
}

