/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.visitors.CommandRebuilder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredFieldsOrderVisitor
extends CommandRebuilder {
    private static final Logger logger = LoggerFactory.getLogger(RequiredFieldsOrderVisitor.class);
    private final LinkedHashSet<String> requiredFields = new LinkedHashSet();
    private final CommandOrderInfo commandOrderInfo = new CommandOrderInfo();
    private final ArrayList<String> columnOrder = new ArrayList();

    private RequiredFieldsOrderVisitor() {
    }

    public LinkedHashSet<String> getRequiredFields() {
        return this.requiredFields;
    }

    public CommandOrderInfo getPipelineOrderInfo() {
        return this.commandOrderInfo;
    }

    public ArrayList<String> getColumnOrder() {
        return this.columnOrder;
    }

    @Override
    public CommandNode visit(CommandNode node) {
        CommandNode[] currentNode = node.getSources();
        if (node.getSources().length != 0) {
            for (int i = 0; i < currentNode.length; ++i) {
                this.visit(currentNode[i]);
            }
        }
        node.setRequiredFields(this.requiredFields);
        logger.debug("command={}, fields={}", (Object)node.getCommandName(), (Object)this.requiredFields.toString());
        node.setOrderInfo(this.commandOrderInfo);
        node.setColumnOrder(this.columnOrder);
        return node;
    }

    public void reset() {
        this.requiredFields.clear();
        this.commandOrderInfo.reset();
        this.columnOrder.clear();
    }
}

