/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.PredicateType;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.visitors.IndexModifierVisitor;
import java.util.HashSet;
import java.util.Set;

public class IndexQualifierVisitor
extends IndexModifierVisitor {
    private final IDatasetResolver resolver;
    private final String kind;
    private final Set<String> referencedDatasets = new HashSet<String>();

    public IndexQualifierVisitor(IDatasetResolver resolver, String kind) {
        this.resolver = resolver;
        if (!kind.equals("index") && !kind.equals("metric")) {
            throw new IllegalArgumentException("Module qualification is only supported for predicates that have indexes of kind \"index\" or \"metric\"");
        }
        this.kind = kind;
    }

    public final Set<String> getReferencedDatasets() {
        return this.referencedDatasets;
    }

    @Override
    protected Node modify(Node node) {
        if (node instanceof SearchComparisonNode) {
            return this.modify((SearchComparisonNode)node);
        }
        if (node instanceof ComparisonNode) {
            return this.modify((ComparisonNode)node);
        }
        return super.modify(node);
    }

    private Node modify(SearchComparisonNode node) {
        StringNode rhs = (StringNode)node.getRhs();
        if (rhs.getValue().contains("*")) {
            this.referencedDatasets.add(rhs.getValue());
            IPredicate predicate = Modules.resolveWildcardedIndexes(this.resolver, new Dataset(this.kind, rhs.getValue()), PredicateType.SEARCH);
            if (predicate == null) {
                return node;
            }
            return predicate.getNode();
        }
        String qualifiedName = Modules.getModuleQualifiedDataset(this.resolver, new Dataset(this.kind, rhs.getValue())).getModuleQualifiedName();
        this.referencedDatasets.add(qualifiedName);
        return new SearchComparisonNode(node.getOperator(), node.getLhs(), new StringNode(qualifiedName), node.is_negated(), node.is_lhs_quoted(), node.is_rhs_quoted(), node.is_indexed(), node.getModifier());
    }

    private Node modify(ComparisonNode node) {
        StringNode rhs = (StringNode)node.getRhs();
        if (rhs.getValue().contains("*")) {
            this.referencedDatasets.add(rhs.getValue());
            IPredicate predicate = Modules.resolveWildcardedIndexes(this.resolver, new Dataset(this.kind, rhs.getValue()), PredicateType.WHERE);
            if (predicate == null) {
                return node;
            }
            return predicate.getNode();
        }
        String qualifiedName = Modules.getModuleQualifiedDataset(this.resolver, new Dataset(this.kind, rhs.getValue())).getModuleQualifiedName();
        this.referencedDatasets.add(qualifiedName);
        return new ComparisonNode(node.getOperator(), node.getLhs(), new StringNode(qualifiedName));
    }
}

