/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.search;

import java.util.HashSet;
import java.util.Set;

public final class DFSSupportedProcessors {
    private static DFSSupportedProcessors instance;
    private final Set<String> supportedProcessors = new HashSet<String>();

    private DFSSupportedProcessors() {
        this.loadProcessors();
    }

    private void loadProcessors() {
        this.supportedProcessors.add("stats");
        this.supportedProcessors.add("join");
        this.supportedProcessors.add("sort");
        this.supportedProcessors.add("head");
        this.supportedProcessors.add("tail");
        this.supportedProcessors.add("filter");
        this.supportedProcessors.add("eval");
        this.supportedProcessors.add("fields");
        this.supportedProcessors.add("dedup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized DFSSupportedProcessors getInstance() {
        if (instance != null) return instance;
        Class<DFSSupportedProcessors> clazz = DFSSupportedProcessors.class;
        synchronized (DFSSupportedProcessors.class) {
            if (instance != null) return instance;
            instance = new DFSSupportedProcessors();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isProcessorSupported(String processorName) {
        return this.supportedProcessors.contains(processorName);
    }
}

