/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.datasets.BaseDataset;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetCallable;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.datasets.ImportDataset;
import com.splunk.commons.datasets.Properties;
import com.splunk.commons.util.SafeArgs;
import com.splunk.commons.visitors.SplFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedResolverWrapper
implements IDatasetResolver {
    private final IDatasetResolver resolver;
    private final Map<String, IDatasetInfo> cache = new HashMap<String, IDatasetInfo>();
    private final Set<String> wildcardNames = new HashSet<String>();
    private final Map<String, Set<String>> kindToNamesMap = new HashMap<String, Set<String>>();
    private final SplFormatter splFormatter = new SplFormatter();
    private static final String MODULE_SEP = ":";
    private static final Logger logger = LoggerFactory.getLogger(CachedResolverWrapper.class);

    public CachedResolverWrapper(IDatasetResolver resolver) {
        this.resolver = SafeArgs.valueIsNotNull(resolver, "\"resolver\" must not be null.");
    }

    @Override
    public IDatasetInfo resolveDataset(Dataset dataset) {
        return this.resolveDataset(dataset, null);
    }

    public IDatasetInfo resolveDataset(Dataset dataset, IDatasetCallable callable) {
        IDatasetInfo datasetInfo;
        String cacheKey = this.constructKey(dataset.getModule(), dataset.getName());
        if (!this.cache.containsKey(cacheKey)) {
            logger.debug("cache miss for dataset: " + dataset);
            CachedResolverWrapper.invokeCallable(callable, dataset);
            IWherePredicate predicate = Modules.buildWherePredicate(Arrays.asList(dataset), this.getModule());
            this.query(predicate);
        }
        if ((datasetInfo = this.cache.get(cacheKey)) == null) {
            logger.warn("dataset: " + dataset + " couldn't be resolved from backing resolver.");
            return datasetInfo;
        }
        return datasetInfo;
    }

    @Override
    public List<IDatasetInfo> query(IWherePredicate predicate) {
        return this.query(predicate, null);
    }

    public List<IDatasetInfo> query(IWherePredicate predicate, IDatasetCallable callable) {
        logger.debug("original predicate queried: " + predicate.getNode().accept(this.splFormatter));
        ArrayList<IDatasetInfo> datasetInfoList = new ArrayList<IDatasetInfo>();
        HashSet<Dataset> toBeResolved = new HashSet<Dataset>();
        Set<Dataset> deconstructedSet = Modules.deconstructWherePredicate(predicate);
        for (Dataset dataset : deconstructedSet) {
            String wcCacheKey;
            String cacheKey = this.constructKey(dataset.getModule(), dataset.getName());
            if (this.cache.containsKey(cacheKey)) {
                datasetInfoList.add(this.cache.get(cacheKey));
                continue;
            }
            if (dataset.getName().contains("*") && this.wildcardNames.contains(wcCacheKey = this.constructKey(dataset.getModule(), dataset.getQualifiedName()))) {
                TermMatcher matcher = new TermMatcher(this.constructKey(dataset.getModule(), dataset.getName()));
                String cacheKeyKind = this.constructKey(dataset.getModule(), dataset.getKind());
                boolean resolveImports = false;
                if (!this.kindToNamesMap.containsKey(cacheKeyKind)) {
                    cacheKeyKind = this.constructKey(dataset.getModule(), "import");
                    resolveImports = true;
                }
                if (this.kindToNamesMap.containsKey(cacheKeyKind)) {
                    for (String name : this.kindToNamesMap.get(cacheKeyKind)) {
                        if (!matcher.match(name)) continue;
                        IDatasetInfo info = this.cache.get(name);
                        datasetInfoList.add(info);
                        if (!resolveImports) continue;
                        datasetInfoList.add(Modules.resolveRecursive(this, new Dataset(info.getModule(), info.getKind(), info.getName())));
                    }
                    continue;
                }
            }
            toBeResolved.add(dataset);
        }
        if (!deconstructedSet.isEmpty() && toBeResolved.isEmpty()) {
            logger.debug("All the datasets requested can be served from cache.");
            return datasetInfoList;
        }
        IWherePredicate deltaPredicate = toBeResolved.isEmpty() ? predicate : Modules.buildWherePredicate(toBeResolved, this.getModule());
        logger.debug("delta predicate to be queried from backing resolver: " + deltaPredicate.getNode().accept(this.splFormatter));
        List<IDatasetInfo> deltaDatasetInfoList = this.resolver.query(deltaPredicate);
        CachedResolverWrapper.invokeCallable(callable, toBeResolved);
        if (deltaDatasetInfoList == null || deltaDatasetInfoList.isEmpty()) {
            logger.warn("couldn't resolve datasets from catalog using predicate: " + deltaPredicate.getNode().accept(this.splFormatter));
            return datasetInfoList;
        }
        datasetInfoList.addAll(deltaDatasetInfoList);
        this.loadAll(deltaDatasetInfoList);
        for (Dataset dataset : toBeResolved) {
            if (!dataset.getName().contains("*")) continue;
            this.wildcardNames.add(this.constructKey(dataset.getModule(), dataset.getQualifiedName()));
        }
        return datasetInfoList;
    }

    @Override
    public String getModule() {
        return this.resolver.getModule();
    }

    private static void invokeCallable(IDatasetCallable callable, Dataset dataset) {
        if (callable != null) {
            try {
                callable.setDataset(dataset);
                callable.call();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static void invokeCallable(IDatasetCallable callable, Iterable<Dataset> datasets) {
        for (Dataset dataset : datasets) {
            CachedResolverWrapper.invokeCallable(callable, dataset);
        }
    }

    private void loadAll(List<IDatasetInfo> infos) {
        HashMap<String, IDatasetInfo> infoById = new HashMap<String, IDatasetInfo>();
        for (IDatasetInfo info : infos) {
            infoById.put(info.getId().toString(), info);
        }
        for (IDatasetInfo info : infos) {
            IDatasetInfo newInfo = CachedResolverWrapper.constructDatasetInfo(info, infoById);
            this.cache.put(this.constructKey(newInfo.getModule(), newInfo.getName()), newInfo);
            this.updateKindToNameMap(newInfo);
        }
    }

    private void updateKindToNameMap(IDatasetInfo info) {
        String key = this.constructKey(info.getModule(), info.getKind());
        if (!this.kindToNamesMap.containsKey(key)) {
            this.kindToNamesMap.put(key, new HashSet());
        }
        this.kindToNamesMap.get(key).add(this.constructKey(info.getModule(), info.getName()));
    }

    private String constructKey(String module, String name) {
        if (!module.equals("")) {
            return module + MODULE_SEP + name;
        }
        if (this.getModule() == null || this.getModule().equals("")) {
            return name;
        }
        return this.getModule() + MODULE_SEP + name;
    }

    private static IDatasetInfo constructDatasetInfo(IDatasetInfo info, Map<String, IDatasetInfo> infoById) {
        if (info.getKind().equals("import")) {
            IDatasetInfo targetInfo;
            Properties props = SafeArgs.valueIsNotNull(info.getProperties(), "Import dataset doesn't have properties");
            String targetId = props.getProperty("originalDatasetId").getString().get();
            if (!infoById.containsKey(targetId)) {
                logger.warn("Couldn't fetch the target Dataset having ID: %s for Import dataset: %s", (Object)targetId, (Object)info.getQualifiedName());
            }
            if ((targetInfo = infoById.get(targetId)) == null) {
                logger.warn("Couldn't fetch the target Dataset having ID: %s for Import dataset: %s", (Object)targetId, (Object)info.getQualifiedName());
            }
            return new ImportDataset(info, targetInfo.getModule(), targetInfo.getName());
        }
        return new BaseDataset(info);
    }

    @Override
    public void setModule(String module) {
        this.resolver.setModule(module);
    }
}

