/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class HeadCommand
extends CommandNode {
    public static final int DEFAULT_LIMIT = 10;
    public static final boolean DEFAULT_KEEPLAST = false;
    public static final boolean DEFAULT_NULL_IS_MATCH = false;
    private static final boolean DEFAULT_PREHEAD_MODE = false;
    private final NumberNode limitNode;
    private final IWherePredicate predicate;
    private final BooleanNode keeplastNode;
    private final BooleanNode nullIsMatchNode;
    private final boolean mapMode;

    public HeadCommand(CommandNode source, int limit) {
        this(source, new NumberNode(limit), null, null, null, false);
    }

    public HeadCommand(CommandNode source, IWherePredicate predicate) {
        this(source, new NumberNode(0), predicate, BooleanNode.load(false), BooleanNode.load(false), false);
    }

    public HeadCommand(CommandNode source, int limit, IWherePredicate predicate, boolean keeplast, boolean nullIsMatch) {
        this(source, limit, predicate, keeplast, nullIsMatch, false);
    }

    private HeadCommand(CommandNode source, int limit, IWherePredicate predicate, boolean keeplast, boolean nullIsMatch, boolean isPreHead) {
        this(source, new NumberNode(limit), predicate, BooleanNode.load(keeplast), BooleanNode.load(nullIsMatch), isPreHead);
    }

    public HeadCommand(CommandNode source, NumberNode limit, IWherePredicate predicate, BooleanNode keeplast, BooleanNode nullIsMatch, boolean isPreHead) {
        super(source, isPreHead ? "prehead" : "head", isPreHead ? CommandType.SP_STREAM : CommandType.SP_STATEFUL, new FieldsAndProperties().where(predicate).array());
        this.limitNode = limit;
        this.predicate = predicate;
        this.keeplastNode = keeplast;
        this.nullIsMatchNode = nullIsMatch;
        this.mapMode = isPreHead;
    }

    public NumberNode getLimit() {
        return this.limitNode;
    }

    public IWherePredicate getPredicate() {
        return this.predicate;
    }

    public BooleanNode getKeeplast() {
        return this.keeplastNode;
    }

    public BooleanNode getNullIsMatch() {
        return this.nullIsMatchNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new HeadCommand(source, this.limitNode, this.predicate, this.keeplastNode, this.nullIsMatchNode, this.mapMode);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }

    public boolean isMapMode() {
        return this.mapMode;
    }

    public CommandNode convertToPreHead(CommandNode source) {
        return new HeadCommand(source, this.limitNode, this.predicate, this.keeplastNode, this.nullIsMatchNode, true);
    }
}

