/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.NodeParser;
import com.splunk.commons.ast.SPLParseError;
import com.splunk.commons.ast.SPLParseErrorType;
import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.antlr.CommandApplyVisitor;
import com.splunk.commons.ast.antlr.CommandBinVisitor;
import com.splunk.commons.ast.antlr.CommandDedupVisitor;
import com.splunk.commons.ast.antlr.CommandEvalVisitor;
import com.splunk.commons.ast.antlr.CommandFieldsVisitor;
import com.splunk.commons.ast.antlr.CommandFitVisitor;
import com.splunk.commons.ast.antlr.CommandFromVisitor;
import com.splunk.commons.ast.antlr.CommandHeadVisitor;
import com.splunk.commons.ast.antlr.CommandIntoVisitor;
import com.splunk.commons.ast.antlr.CommandJoinVisitor;
import com.splunk.commons.ast.antlr.CommandLookupVisitor;
import com.splunk.commons.ast.antlr.CommandMcatalogVisitor;
import com.splunk.commons.ast.antlr.CommandMvexpandVisitor;
import com.splunk.commons.ast.antlr.CommandRenameVisitor;
import com.splunk.commons.ast.antlr.CommandRexVisitor;
import com.splunk.commons.ast.antlr.CommandSearchVisitor;
import com.splunk.commons.ast.antlr.CommandSendalertVisitor;
import com.splunk.commons.ast.antlr.CommandSortVisitor;
import com.splunk.commons.ast.antlr.CommandStatsVisitor;
import com.splunk.commons.ast.antlr.CommandTimechartVisitor;
import com.splunk.commons.ast.antlr.CommandUnionVisitor;
import com.splunk.commons.ast.antlr.CommandWhereVisitor;
import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.antlr.SPLVisitor;
import com.splunk.commons.ast.antlr.SplErrorListener;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.spl.parser.SplunkCommandLexer;
import com.splunk.spl.parser.SplunkCommandParser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Triple;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CompleteSPLParser
extends NodeParser<String> {
    public static final int COMPLETE_SPL = 0;
    public static final int EXPRESSION_ONLY_WHERE = -1;
    public static final int EXPRESSION_ONLY_EVAL = -2;
    public static final int EXPRESSION_ONLY_SEARCH = -3;
    private boolean tokenValidation;
    private static final Logger logger = LoggerFactory.getLogger(CompleteSPLParser.class);

    public boolean getTokenValidation() {
        return this.tokenValidation;
    }

    public void setTokenValidation(boolean enabled) {
        this.tokenValidation = enabled;
    }

    public Node parseWherePredicate(String spl) throws SPLParseException {
        return this.parse(spl, -1);
    }

    public Node parseSearchPredicate(String spl) throws SPLParseException {
        return this.parse(spl, -3);
    }

    @Override
    public Node parse(String spl) throws SPLParseException {
        return this.parse(spl, 0);
    }

    public Node parse(String spl, int command) throws SPLParseException {
        SplErrorListener lexListener = new SplErrorListener("CompleteSPLLexer");
        SPLParseError parseError = null;
        String modifiedSpl = CompleteSPLParser.fixupSPL(spl, command);
        SplunkCommandLexer lexer = new SplunkCommandLexer((CharStream)CharStreams.fromString((String)modifiedSpl));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)lexListener);
        CompleteSPLParser.setLexerMode(lexer, command);
        if (this.tokenValidation) {
            parseError = CompleteSPLParser.validateTokens(modifiedSpl, command, lexListener, lexer);
        }
        logger.info("lexer=SplunkCommandLexer, spl={}, error={}", (Object)spl, parseError);
        if (parseError != null) {
            throw new SPLParseException("SPL syntax failure", "Lexer", parseError);
        }
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        Node splAstNode = this.parseFromTokenStream(tokenStream, command, spl, modifiedSpl);
        return splAstNode;
    }

    Node parseFromTokenStream(CommonTokenStream tokenStream, int command, String spl, String modifiedSpl) {
        SplErrorListener parseListener = new SplErrorListener("CompleteSPLParser");
        Node splAstNode = null;
        String errorMsg = null;
        RuntimeException errorEx = null;
        String commandName = null;
        SplunkCommandParser parser = new SplunkCommandParser((TokenStream)tokenStream);
        if (logger.isDebugEnabled()) {
            parser.setTrace(this.tokenValidation);
        }
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parseListener);
        try {
            switch (command) {
                case 126: {
                    commandName = "apply";
                    splAstNode = (Node)new CommandApplyVisitor().visit((ParseTree)parser.applyParse());
                    break;
                }
                case 109: {
                    commandName = "bin";
                    splAstNode = (Node)new CommandBinVisitor().visit((ParseTree)parser.binParse());
                    break;
                }
                case 111: {
                    commandName = "dedup";
                    splAstNode = (Node)new CommandDedupVisitor().visit((ParseTree)parser.dedupParse());
                    break;
                }
                case 112: {
                    commandName = "eval";
                    splAstNode = (Node)new CommandEvalVisitor().visit((ParseTree)parser.evalParse());
                    break;
                }
                case 114: {
                    commandName = "fields";
                    splAstNode = (Node)new CommandFieldsVisitor().visit((ParseTree)parser.fieldsParse());
                    break;
                }
                case 127: {
                    commandName = "fit";
                    splAstNode = (Node)new CommandFitVisitor().visit((ParseTree)parser.fitParse());
                    break;
                }
                case 128: {
                    commandName = "from";
                    splAstNode = (Node)new CommandFromVisitor().visit((ParseTree)parser.fromParse());
                    break;
                }
                case 113: {
                    commandName = "head";
                    splAstNode = (Node)new CommandHeadVisitor().visit((ParseTree)parser.headParse());
                    break;
                }
                case 134: {
                    commandName = "into";
                    splAstNode = (Node)new CommandIntoVisitor().visit((ParseTree)parser.intoParse());
                    break;
                }
                case 129: {
                    commandName = "join";
                    splAstNode = (Node)new CommandJoinVisitor().visit((ParseTree)parser.joinParse());
                    break;
                }
                case 115: {
                    commandName = "lookup";
                    splAstNode = (Node)new CommandLookupVisitor().visit((ParseTree)parser.lookupParse());
                    break;
                }
                case 116: {
                    commandName = "mcatalog";
                    splAstNode = (Node)new CommandMcatalogVisitor().visit((ParseTree)parser.mcatalogParse());
                    break;
                }
                case 119: {
                    commandName = "rex";
                    splAstNode = (Node)new CommandRexVisitor().visit((ParseTree)parser.rexParse());
                    break;
                }
                case 118: {
                    commandName = "rename";
                    splAstNode = (Node)new CommandRenameVisitor().visit((ParseTree)parser.renameParse());
                    break;
                }
                case 120: {
                    commandName = "search";
                    splAstNode = (Node)new CommandSearchVisitor().visit((ParseTree)parser.searchParse());
                    break;
                }
                case 121: {
                    commandName = "sendalert";
                    splAstNode = (Node)new CommandSendalertVisitor().visit((ParseTree)parser.sendalertParse());
                    break;
                }
                case 122: {
                    commandName = "sort";
                    splAstNode = (Node)new CommandSortVisitor().visit((ParseTree)parser.sortParse());
                    break;
                }
                case 123: {
                    commandName = "stats";
                    splAstNode = (Node)new CommandStatsVisitor().visit((ParseTree)parser.statsParse());
                    break;
                }
                case 131: {
                    commandName = "where";
                    splAstNode = (Node)new CommandWhereVisitor().visit((ParseTree)parser.whereParse());
                    break;
                }
                case 130: {
                    commandName = "union";
                    splAstNode = (Node)new CommandUnionVisitor().visit((ParseTree)parser.unionParse());
                    break;
                }
                case 117: {
                    commandName = "mvexpand";
                    splAstNode = (Node)new CommandMvexpandVisitor().visit((ParseTree)parser.mvexpandParse());
                    break;
                }
                case -1: {
                    commandName = "where";
                    splAstNode = (Node)new ExpressionVisitor().visit((ParseTree)parser.boolExpression());
                    break;
                }
                case -2: {
                    commandName = "eval";
                    splAstNode = (Node)new ExpressionVisitor().visit((ParseTree)parser.nonboolExpression());
                    break;
                }
                case -3: {
                    commandName = "search";
                    splAstNode = (Node)new CommandSearchVisitor().visit((ParseTree)parser.searchExpressionParse());
                    break;
                }
                case 124: {
                    splAstNode = (Node)new CommandTimechartVisitor().visit((ParseTree)parser.timechartParse());
                    break;
                }
                case 0: {
                    commandName = "SPL";
                    splAstNode = (Node)new SPLVisitor().visit((ParseTree)parser.search());
                    break;
                }
                default: {
                    commandName = "unsupported";
                    errorMsg = "Unsupported command ID: " + command;
                    break;
                }
            }
        }
        catch (NullPointerException e) {
            errorEx = e;
            logger.error("spl={}", (Object)spl, (Object)e);
        }
        catch (IllegalArgumentException e) {
            errorEx = e;
            logger.error("spl={}", (Object)spl, (Object)e);
        }
        catch (UnsupportedOperationException e) {
            errorEx = e;
            logger.error("spl={}", (Object)spl, (Object)e);
        }
        catch (RuntimeException e) {
            errorEx = e;
            logger.warn("spl={}", (Object)spl, (Object)e);
        }
        SPLParseError parseError = parseListener.getError();
        if (parseError == null) {
            if (errorEx != null) {
                errorMsg = errorEx.getMessage();
            }
            if (errorMsg != null) {
                Token errorToken = parser.getCurrentToken();
                parseError = new SPLParseError(SPLParseErrorType.ERROR_AST_GENERATE, errorMsg, commandName, errorToken.getLine(), errorToken.getCharPositionInLine(), errorToken.getText());
            }
        }
        logger.info("parser=SplunkCommandParser, spl={}, error={}", (Object)modifiedSpl, (Object)parseError);
        if (parseError != null) {
            SPLParseException splEx = new SPLParseException(errorMsg, errorEx);
            splEx.setCommand(commandName);
            splEx.setError(parseError);
            throw splEx;
        }
        return splAstNode;
    }

    private static SPLParseError validateTokens(String spl, int command, SplErrorListener lexListener, SplunkCommandLexer lexer) {
        ArrayList<Triple> tokenList = new ArrayList<Triple>();
        do {
            Token token;
            try {
                token = lexer.nextToken();
            }
            catch (LexerNoViableAltException e) {
                logger.warn("spl={}", (Object)spl, (Object)e);
                token = e.getOffendingToken();
                String tokenType = lexer.getVocabulary().getSymbolicName(token.getType());
                SPLParseError lexerError = new SPLParseError(SPLParseErrorType.ERROR_SPL_LEX, e.getMessage(), tokenType, token.getLine(), token.getCharPositionInLine(), token.getText());
                return lexerError;
            }
            String[] modeStack = new String[lexer._modeStack.size()];
            for (int i = 0; i < lexer._modeStack.size(); ++i) {
                modeStack[i] = lexer.getModeNames()[lexer._modeStack.get(i)];
            }
            tokenList.add(new Triple((Object)token, (Object)lexer.getModeNames()[lexer._mode], (Object)modeStack));
        } while (!lexer._hitEOF);
        SPLParseError lexerError = lexListener.getError();
        if (lexerError != null) {
            return lexerError;
        }
        logger.debug("token size={}", (Object)tokenList.size());
        int n = 0;
        for (Triple t : tokenList) {
            String tokenType = lexer.getVocabulary().getSymbolicName(((Token)t.a).getType());
            ++n;
            StringBuilder outputString = new StringBuilder();
            if (tokenType == null || ((Token)t.a).getChannel() == 2) {
                outputString.append("Invalid token: ");
                lexerError = new SPLParseError(SPLParseErrorType.ERROR_SPL_LEX, "Invalid token", tokenType, ((Token)t.a).getLine(), ((Token)t.a).getCharPositionInLine(), ((Token)t.a).getText());
                return lexerError;
            }
            outputString.append("Valid token: ");
            outputString.append(n).append(": type= ").append(tokenType).append(", value=").append(((Token)t.a).getText()).append(", line=").append(((Token)t.a).getLine()).append(", pos=").append(((Token)t.a).getCharPositionInLine()).append(", channel=").append(((Token)t.a).getChannel()).append(", index=").append(((Token)t.a).getTokenIndex()).append(", start=").append(((Token)t.a).getStartIndex()).append(", stop=").append(((Token)t.a).getStopIndex()).append(", mode=").append((String)t.b).append(", modeStack=[").append(String.join((CharSequence)",", (CharSequence[])t.c)).append(']');
            logger.debug("{}", (Object)outputString);
        }
        lexer.setInputStream((IntStream)CharStreams.fromString((String)spl));
        CompleteSPLParser.setLexerMode(lexer, command);
        return lexerError;
    }

    private static String fixupSPL(String input, int command) {
        String output = input = input.trim();
        if (command == 0) {
            if (input.startsWith("search")) {
                output = "| " + input;
            } else if (!input.startsWith("|")) {
                output = "| search " + input;
            }
        }
        return output;
    }

    private static void setLexerMode(SplunkCommandLexer lexer, int command) {
        switch (command) {
            case -3: {
                lexer.mode(3);
                break;
            }
            case 120: {
                lexer.mode(2);
                break;
            }
        }
    }

    static {
        if (MDC.get((String)"service") == null) {
            MDC.put((String)"service", (String)"commons.ast");
        }
        if (MDC.get((String)"hostname") == null) {
            String hostname;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "unknown";
            }
            MDC.put((String)"hostname", (String)hostname);
        }
    }
}

