/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.antlr.StatsAndChartVisitor;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class CommandStatsVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private static final String ID = "STATS";
    private BooleanNode allnum;
    private StringNode delim;
    private NumberNode paritions;
    private final List<IGroupBy> byFields = new ArrayList<IGroupBy>();
    private final List<AggregateNode> aggregates = new ArrayList<AggregateNode>();
    private final ExpressionVisitor expressionVisitor = new ExpressionVisitor();
    private final StatsAndChartVisitor statsAndChartVisitor = new StatsAndChartVisitor(true);

    @Override
    public Node visitStatsParse(SplunkCommandParser.StatsParseContext ctx) {
        Node node = (Node)this.visit((ParseTree)ctx.statsCommand());
        for (SplunkCommandParser.StatsOptsContext optsContext : ctx.statsOpts()) {
            node = (Node)this.visit((ParseTree)optsContext);
            if (node != null) continue;
            throw new IllegalArgumentException("STATS has an invalid option: " + optsContext.getText());
        }
        for (SplunkCommandParser.StatsExpressionContext exprContext : ctx.statsExpression()) {
            node = (Node)this.visit((ParseTree)exprContext);
            if (node != null) continue;
            throw new IllegalArgumentException("STATS has an invalid expression: " + exprContext.getText());
        }
        SplunkCommandParser.StatsByContext byContext = ctx.statsBy();
        if (byContext != null && (node = (Node)this.visit((ParseTree)byContext)) == null) {
            throw new IllegalArgumentException("STATS has an invalid BY clause: " + byContext.getText());
        }
        return new StatsCommand((CommandNode)new SearchCommand(), this.aggregates, this.byFields, this.paritions, this.allnum, this.delim, false);
    }

    @Override
    public Node visitStatsCommand(SplunkCommandParser.StatsCommandContext ctx) {
        return (Node)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Node visitStatsBy(SplunkCommandParser.StatsByContext ctx) {
        FieldNode node = null;
        for (SplunkCommandParser.StatsByFieldContext byFieldContext : ctx.statsByField()) {
            SplunkCommandParser.FieldContext fieldContext = byFieldContext.field();
            SplunkCommandParser.TimeSpanContext timeSpanContext = byFieldContext.timeSpan();
            if (fieldContext != null) {
                node = (FieldNode)this.expressionVisitor.visit((ParseTree)fieldContext);
                this.byFields.add(node);
            } else if (timeSpanContext != null) {
                if (timeSpanContext instanceof SplunkCommandParser.TimeSpanFieldContext) {
                    SplunkCommandParser.TimeSpanFieldContext timeSpanFieldContext = (SplunkCommandParser.TimeSpanFieldContext)timeSpanContext;
                    node = (FieldNode)this.expressionVisitor.visit((ParseTree)timeSpanFieldContext.field());
                    BinNode span = (BinNode)this.statsAndChartVisitor.visit((ParseTree)timeSpanFieldContext);
                    this.byFields.add(span);
                } else {
                    throw new IllegalArgumentException("STATS has invalid time span: " + timeSpanContext.getText());
                }
            }
            if (node != null) continue;
            throw new IllegalArgumentException("STATS has an invalid BY field: " + fieldContext.getText());
        }
        return node;
    }

    @Override
    public Node visitStatsOpts(SplunkCommandParser.StatsOptsContext ctx) {
        Token fieldToken = ctx.statsOptField;
        switch (fieldToken.getType()) {
            case 142: {
                BooleanNode bNode = (BooleanNode)this.expressionVisitor.visit((ParseTree)ctx.boolValue());
                this.allnum = (BooleanNode)CommandStatsVisitor.setArgIfNull(this.allnum, bNode, fieldToken.getText(), ctx.getText());
                return this.allnum;
            }
            case 145: {
                StringNode sNode = (StringNode)this.expressionVisitor.visit((ParseTree)ctx.genericstring());
                this.delim = (StringNode)CommandStatsVisitor.setArgIfNull(this.delim, sNode, fieldToken.getText(), ctx.getText());
                return this.delim;
            }
            case 156: {
                Integer n = Integer.valueOf(ctx.INTEGER().getText());
                this.paritions = (NumberNode)CommandStatsVisitor.setArgIfNull(this.paritions, new NumberNode(n), fieldToken.getText(), ctx.getText());
                return this.paritions;
            }
        }
        return null;
    }

    @Override
    public Node visitStatsAggregation(SplunkCommandParser.StatsAggregationContext ctx) {
        AggregateNode aNode = this.statsAndChartVisitor.visitStatsAggregation(ctx);
        this.aggregates.add(aNode);
        return aNode;
    }

    @Override
    public Node visitSparklineAggregation(SplunkCommandParser.SparklineAggregationContext ctx) {
        SparklineAggregateNode aNode = (SparklineAggregateNode)this.statsAndChartVisitor.visitSparklineAggregation(ctx);
        this.aggregates.add(aNode);
        return aNode;
    }

    private static Object setArgIfNull(Object dest, Object src, String arg, String text) {
        if (dest == null) {
            dest = src;
            return dest;
        }
        throw new IllegalArgumentException("STATS has a duplicate option '" + arg + "': " + text);
    }
}

