/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.ManifestLine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ManifestLineParser {
    private final File splunkHome;

    public ManifestLineParser(File splunkHome) {
        this.splunkHome = splunkHome;
    }

    public List<ManifestLine> parseLines(InputStream in) throws IOException {
        ArrayList<ManifestLine> lines = new ArrayList<ManifestLine>();
        for (String line : IOUtils.readLines((InputStream)in)) {
            lines.add(this.parseLine(line));
        }
        return lines;
    }

    public ManifestLine parseLine(String line) {
        String[] s = line.split(" ");
        ManifestLine.Type type = ManifestLine.Type.createByLetter(s[0]);
        if (type.equals((Object)ManifestLine.Type.COMMENT)) {
            return new ManifestLine.CommentLine();
        }
        String mode = this.adjustModeOnDirectories(s[1], type);
        int parseAsOctal = Integer.parseInt(mode, 8);
        String path = this.createPathFromSplit(type, s);
        return new ManifestLine(type, parseAsOctal, s[2], s[3], path, this.pathToFile(path));
    }

    private String adjustModeOnDirectories(String mode, ManifestLine.Type type) {
        return type == ManifestLine.Type.DIR ? "7" + mode.substring(1) : mode;
    }

    private String createPathFromSplit(ManifestLine.Type type, String[] s) {
        int pathEnd = type.equals((Object)ManifestLine.Type.LINK) ? s.length : s.length - 1;
        int pathStartIndex = 4;
        return StringUtils.join((Object[])Arrays.copyOfRange(s, pathStartIndex, pathEnd), (String)" ");
    }

    public File pathToFile(String path) {
        return new File(this.splunkHome, ManifestLineParser.getPathWithoutFirstDir(path));
    }

    public static String getPathWithoutFirstDir(String path) {
        return path.substring(path.indexOf("/") + 1);
    }
}

