/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.EventWriterUtil;
import com.splunk.s2s.Event;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.log4j.Logger;

public class PlainTextEventWriter
extends AbstractEventWriter {
    private static Logger gLogger = Logger.getLogger(PlainTextEventWriter.class);
    private OutputStream out;
    private boolean closed = false;
    private Path baseDir;
    private Path currentFile;
    private Configuration conf;
    private String name;
    private CompressionCodec codec;
    private String extension;
    private boolean renameOnClose;

    public PlainTextEventWriter(Configuration conf, Path baseDir, String codecName, boolean renameOnClose) {
        super(false);
        this.conf = conf;
        this.baseDir = baseDir;
        this.renameOnClose = renameOnClose;
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        this.codec = EventWriterUtil.getCompressionCodec(codecName, factory);
        if (null == this.codec) {
            gLogger.info((Object)"Creating plain-text writer with no compression");
        } else {
            gLogger.info((Object)("Creating plain-text writer using compression codec: " + this.codec.getClass().getName()));
            this.extension = EventWriterUtil.getExtension(codecName);
        }
    }

    private void init(Event e) throws IOException {
        if (this.out != null) {
            return;
        }
        if (this.closed) {
            throw new IllegalStateException("Cannot init after close()");
        }
        this.name = (e.isParsedEvent() ? "hunk_pv1_" : "hunk_rv1_") + System.currentTimeMillis() + ".txt";
        if (null != this.extension) {
            this.name = this.name + this.extension;
        }
        if (this.renameOnClose) {
            this.name = this.name + ".tmp";
        }
        this.currentFile = new Path(this.baseDir, this.name);
        this.out = this.currentFile.getFileSystem(this.conf).create(this.currentFile);
        if (null != this.codec) {
            this.out = this.codec.createOutputStream(this.out);
        }
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Opening stream to " + this.currentFile));
        }
    }

    @Override
    protected void commitImpl() {
        try {
            gLogger.debug((Object)"Flushing events");
            this.out.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void addEventImpl(Event e) throws IOException {
        this.init(e);
        byte[] rawBytes = e.getRaw().getBytes();
        this.out.write(rawBytes);
        this.out.write(10);
    }

    @Override
    public String getName() {
        return "plain-text";
    }

    @Override
    public void close() throws IOException {
        if (null != this.out) {
            this.out.close();
        }
        EventWriterUtil.postCloseCleanup(this.conf, this.currentFile, this.getRawEventBytes(), this.getEventCount(), this.renameOnClose);
    }
}

