/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.io.SearchOutputStream;
import com.splunk.mr.DispatchReaper;
import com.splunk.mr.ResultFileReader;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.SplunkdProcess;
import com.splunk.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.log4j.Logger;

public class SearchReducer
extends Reducer<Text, Text, Text, Text> {
    private static Logger gLogger = Logger.getLogger(SearchReducer.class);
    protected SplunkdProcess _splunkProcess = null;
    protected String _searchId = null;

    protected void startSplunkProcess(Reducer.Context context, Writer stdout, Writer stderr) throws IOException {
        Configuration conf = context.getConfiguration();
        String search2run = "stdin";
        String reduceSearch = conf.get("splunk.search.reduce");
        String splunk_home = SplunkMR.getDNSplunkHome(conf).toString();
        ArrayList<String> args = new ArrayList<String>(10);
        args.add("search");
        args.add("--streaming");
        if (reduceSearch != null) {
            args.add("--runReduce=true");
        }
        args.add("--annotateMessages=true");
        args.add("--outCsv");
        args.add("--pro");
        args.add("--user=admin");
        args.add("--app=search");
        args.add("--roles=admin");
        args.add("--maxout=0");
        args.add("--maxbuckets=0");
        args.add("--id=" + this._searchId);
        args.add("--search=" + search2run);
        args.add("--reduceSearch=" + reduceSearch);
        Random random = new Random();
        if (random.nextDouble() < 0.05) {
            DispatchReaper.cleanupLocalDispatchDir(SplunkdProcess.getDispatchDir(splunk_home, ""), 0L);
        }
        gLogger.info((Object)("starting splunk search with reduce search=" + reduceSearch));
        this._splunkProcess = new SplunkdProcess(splunk_home, stdout, stderr, args.toArray(new String[0]));
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this._searchId = "SplunkMR_" + context.getTaskAttemptID().toString();
    }

    public void run(Reducer.Context context) throws IOException, InterruptedException {
        this.setup(context);
        try {
            this.runImpl(context);
        }
        finally {
            this.cleanup(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Path outputPath = SplunkMR.getHDFSDispatchHome(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int tid = context.getTaskAttemptID().getTaskID().getId();
        Path resultPath = new Path(outputPath, SplunkMR.getJobFilename("r", tid));
        Path errorPath = new Path(outputPath, SplunkMR.getJobFilename("err-r", tid));
        Path resultPathTmp = new Path(resultPath.getParent(), resultPath.getName() + "." + context.getTaskAttemptID().getId() + ".tmp");
        Path errorPathTmp = new Path(errorPath.getParent(), errorPath.getName() + "." + context.getTaskAttemptID().getId() + ".tmp");
        OutputStreamWriter searchStdout = new OutputStreamWriter(new GZIPOutputStream((OutputStream)fs.create(resultPathTmp), 65535));
        OutputStreamWriter searchStderr = new OutputStreamWriter((OutputStream)fs.create(errorPathTmp));
        HashSet<String> processedSet = new HashSet<String>();
        try {
            this.startSplunkProcess(context, searchStdout, searchStderr);
            SearchOutputStream out = new SearchOutputStream(this._splunkProcess.getStdin());
            HashMap<String, Object> header = new HashMap<String, Object>();
            header.put("process_events", "0");
            out.addHeader(header);
            searchStdout.write("reduce: " + resultPath.toString() + "\n");
            while (context.nextKey()) {
                Text key = (Text)context.getCurrentKey();
                Text val = (Text)context.getCurrentValue();
                ResultFileReader rfr = ResultFileReader.create(fs, new Path(val.toString()), out, processedSet, "events");
                rfr.setRemoveResultFile(false);
                rfr.run();
            }
            out.flush();
            int rv = this._splunkProcess.waitFor();
            ((Writer)searchStdout).close();
            ((Writer)searchStderr).close();
            fs.rename(resultPathTmp, resultPath);
        }
        catch (Exception ex) {
            gLogger.error((Object)ex);
        }
        finally {
            ((Writer)searchStdout).close();
            ((Writer)searchStderr).close();
            if (this._splunkProcess.getStderrBytesCopied() == 0L && !this._splunkProcess.hasStderrError()) {
                fs.delete(errorPathTmp, false);
            } else {
                fs.rename(errorPathTmp, errorPath);
            }
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        boolean collect;
        if (this._splunkProcess == null) {
            return;
        }
        Configuration conf = context.getConfiguration();
        this._splunkProcess.destroy();
        boolean bl = collect = this._splunkProcess.getExitCode() != 0 || StrUtil.parseBoolean(conf.get(SplunkMR.CONF_SEARCH_DEBUG), false);
        if (collect) {
            Path dispatchDirs;
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (!fs.exists(dispatchDirs = new Path(SplunkMR.getHDFSDispatchHome(conf), "dispatch_dirs"))) {
                fs.mkdirs(dispatchDirs);
            }
            try {
                FileUtil.copy((File)this._splunkProcess.getDispatchDir(this._searchId), (FileSystem)fs, (Path)dispatchDirs, (boolean)false, (Configuration)conf);
            }
            catch (Exception e) {
                gLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this._splunkProcess.cleanupDispatchDir(this._searchId);
        super.cleanup(context);
    }
}

