/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="round", value="_FUNC_(x[, d]) - round x to d decimal places", extended="Example:\n  > SELECT _FUNC_(12.3456, 1) FROM src LIMIT 1;\n  12.3'")
public class UDFRound
extends UDF {
    private final HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
    private final DoubleWritable doubleWritable = new DoubleWritable();
    private final LongWritable longWritable = new LongWritable();
    private final IntWritable intWritable = new IntWritable();
    private final ShortWritable shortWritable = new ShortWritable();
    private final ByteWritable byteWritable = new ByteWritable();

    private DoubleWritable evaluate(DoubleWritable n, int i) {
        double d = n.get();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.doubleWritable.set(d);
        } else {
            this.doubleWritable.set(BigDecimal.valueOf(d).setScale(i, RoundingMode.HALF_UP).doubleValue());
        }
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(DoubleWritable n) {
        if (n == null) {
            return null;
        }
        return this.evaluate(n, 0);
    }

    public DoubleWritable evaluate(DoubleWritable n, IntWritable i) {
        if (n == null || i == null) {
            return null;
        }
        return this.evaluate(n, i.get());
    }

    private HiveDecimalWritable evaluate(HiveDecimalWritable n, int i) {
        if (n == null) {
            return null;
        }
        HiveDecimal bd = n.getHiveDecimal();
        try {
            bd = n.getHiveDecimal().setScale(i, 4);
        }
        catch (NumberFormatException e) {
            return null;
        }
        this.decimalWritable.set(bd);
        return this.decimalWritable;
    }

    public HiveDecimalWritable evaluate(HiveDecimalWritable n) {
        return this.evaluate(n, 0);
    }

    public HiveDecimalWritable evaluate(HiveDecimalWritable n, IntWritable i) {
        if (i == null) {
            return null;
        }
        return this.evaluate(n, i.get());
    }

    public LongWritable evaluate(LongWritable n) {
        if (n == null) {
            return null;
        }
        this.longWritable.set(BigDecimal.valueOf(n.get()).setScale(0, RoundingMode.HALF_UP).longValue());
        return this.longWritable;
    }

    public IntWritable evaluate(IntWritable n) {
        if (n == null) {
            return null;
        }
        this.intWritable.set(BigDecimal.valueOf(n.get()).setScale(0, RoundingMode.HALF_UP).intValue());
        return this.intWritable;
    }

    public ShortWritable evaluate(ShortWritable n) {
        if (n == null) {
            return null;
        }
        this.shortWritable.set(BigDecimal.valueOf(n.get()).setScale(0, RoundingMode.HALF_UP).shortValue());
        return this.shortWritable;
    }

    public ByteWritable evaluate(ByteWritable n) {
        if (n == null) {
            return null;
        }
        this.byteWritable.set(BigDecimal.valueOf(n.get()).setScale(0, RoundingMode.HALF_UP).byteValue());
        return this.byteWritable;
    }
}

