/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.SparkFiles;

public class DFSLogger {
    static DFSLogger logger;

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger((Class)clazz);
    }

    static {
        String logCfg;
        logger = new DFSLogger();
        LogManager.resetConfiguration();
        if (Boolean.parseBoolean(System.getenv("DFS_SEARCH_LOG_CONFIG_ENABLED")) && new File(SparkFiles.get((String)"log-dfs-search.cfg")).exists()) {
            logCfg = Paths.get(SparkFiles.get((String)"log-dfs-search.cfg"), new String[0]).toString();
            PropertyConfigurator.configure((String)logCfg);
        } else if (!System.getenv("SPLUNK_HOME").isEmpty()) {
            logCfg = Paths.get(System.getenv("SPLUNK_HOME"), "etc", "log-dfs-search.cfg").toString();
            PropertyConfigurator.configure((String)logCfg);
        } else {
            ClassLoader loader = DFSLogger.class.getClassLoader();
            URL url = loader.getResource("log-dfs-search.cfg");
            PropertyConfigurator.configure((URL)url);
            logCfg = url.toString();
        }
        Logger.getLogger(DFSLogger.class).debug((Object)("Using logger " + logCfg));
    }
}

