/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.security;

import com.splunk.df.security.DFSSecurityConstants;
import com.splunk.df.security.SSLConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

public class DFSSecurityUtils {
    static final Logger logger = Logger.getLogger(DFSSecurityUtils.class);

    public static void generateDefaultCertificates() throws IOException, PKCSException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        SSLConfig sslConfig = SSLConfig.getInstance();
        PrivateKey serverPrivarteKey = DFSSecurityUtils.readEncryptedKey(sslConfig.getPrivateKeyPassword(), sslConfig.getPrivateKeyFile());
        X509Certificate serverCertificate = DFSSecurityUtils.readCertificate(sslConfig.getCertFile());
        X509Certificate caCertificate = DFSSecurityUtils.readCertificate(sslConfig.getCaCertFile());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        String password = DFSSecurityUtils.generateKeyStorePasswd();
        char[] cPassword = password.toCharArray();
        keyStore.load(null, cPassword);
        Certificate[] certChain = new X509Certificate[]{serverCertificate, caCertificate};
        keyStore.setKeyEntry("server", serverPrivarteKey, cPassword, certChain);
        FileOutputStream fos = new FileOutputStream(DFSSecurityConstants.DEFAULT_KEYSTORE_PATH);
        keyStore.store(fos, cPassword);
        fos.close();
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, cPassword);
        X500Name x500name = new JcaX509CertificateHolder(serverCertificate).getSubject();
        RDN cnRDN = x500name.getRDNs(BCStyle.CN)[0];
        String serverCN = IETFUtils.valueToString((ASN1Encodable)cnRDN.getFirst().getValue());
        trustStore.setCertificateEntry(serverCN, serverCertificate);
        x500name = new JcaX509CertificateHolder(caCertificate).getSubject();
        cnRDN = x500name.getRDNs(BCStyle.CN)[0];
        String caCN = IETFUtils.valueToString((ASN1Encodable)cnRDN.getFirst().getValue());
        trustStore.setCertificateEntry(caCN, caCertificate);
        X509Certificate[] oldCACerts = DFSSecurityUtils.readOldCACertificates();
        if (oldCACerts != null && oldCACerts.length > 0) {
            for (int i = 0; i < oldCACerts.length; ++i) {
                trustStore.setCertificateEntry("AdditionalCA" + i, oldCACerts[i]);
            }
        }
        fos = new FileOutputStream(DFSSecurityConstants.DEFAULT_TRUSTSTORE_PATH);
        trustStore.store(fos, cPassword);
        fos.close();
    }

    public static PrivateKey readEncryptedKey(String password, String pemFilePath) throws IOException, PKCSException {
        File file = new File(pemFilePath);
        PEMParser parser = new PEMParser((Reader)new FileReader(file));
        Object readObj = parser.readObject();
        while (!(readObj instanceof PKCS8EncryptedPrivateKeyInfo) && readObj != null) {
            readObj = parser.readObject();
        }
        PKCS8EncryptedPrivateKeyInfo encPrivKeyInfo = (PKCS8EncryptedPrivateKeyInfo)readObj;
        InputDecryptorProvider pkcs8Prov = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getPrivateKey(encPrivKeyInfo.decryptPrivateKeyInfo(pkcs8Prov));
    }

    public static X509Certificate[] readOldCACertificates() throws IOException, CertificateException {
        SSLConfig sslConfig = SSLConfig.getInstance();
        String path = sslConfig.getOldCaCertificateFolder();
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Stream<Path> stream = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);
        String[] certPaths = (String[])stream.filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".pem")).map(p -> p.toString()).toArray(String[]::new);
        if (certPaths == null || certPaths.length == 0) {
            return null;
        }
        X509Certificate[] caCerts = new X509Certificate[certPaths.length];
        for (int i = 0; i < caCerts.length; ++i) {
            caCerts[i] = DFSSecurityUtils.readCertificate(certPaths[i]);
        }
        return caCerts;
    }

    public static X509Certificate readCertificate(String pemFilePath) throws IOException, CertificateException {
        File file = new File(pemFilePath);
        PEMParser parser = new PEMParser((Reader)new FileReader(file));
        Object readObj = parser.readObject();
        while (!(readObj instanceof X509CertificateHolder) && readObj != null) {
            readObj = parser.readObject();
        }
        X509CertificateHolder certHolder = (X509CertificateHolder)readObj;
        return new JcaX509CertificateConverter().getCertificate(certHolder);
    }

    public static String generateKeyStorePasswd() throws IOException {
        FileReader fileReader = new FileReader(DFSSecurityConstants.SPLUNK_SECRET_PATH);
        BufferedReader bufferedReadereader = new BufferedReader(fileReader);
        String line = bufferedReadereader.readLine();
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            sb.append(line);
            line = bufferedReadereader.readLine();
        }
        String secret = sb.toString();
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(), 0, 32, "AES");
        byte[] encoded = key.getEncoded();
        String password = Base64.getEncoder().encodeToString(encoded);
        return password;
    }

    public static boolean checkX509CommonAlternativeNames(X509Certificate certificate, SSLConfig sslConfig) throws CertificateEncodingException {
        if (sslConfig.getSearchPeerToDFWCommonNameList() != null) {
            if (DFSSecurityUtils.commonNameCheck(certificate, sslConfig)) {
                return true;
            }
            return sslConfig.getSearchPeerToDFWAltNameList() != null && DFSSecurityUtils.altNamesCheck(certificate, sslConfig);
        }
        return sslConfig.getSearchPeerToDFWAltNameList() == null || DFSSecurityUtils.altNamesCheck(certificate, sslConfig);
    }

    private static boolean commonNameCheck(X509Certificate certificate, SSLConfig sslConfig) throws CertificateEncodingException {
        JcaX509CertificateHolder x509CertificateHolder = new JcaX509CertificateHolder(certificate);
        X500Name subjectX500name = x509CertificateHolder.getSubject();
        RDN cn = subjectX500name.getRDNs(BCStyle.CN)[0];
        String subjectCommonName = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        for (String cNameToCheck : sslConfig.getSearchPeerToDFWCommonNameList()) {
            if (!cNameToCheck.equals(subjectCommonName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static boolean altNamesCheck(X509Certificate certificate, SSLConfig sslConfig) throws CertificateEncodingException {
        JcaX509CertificateHolder x509CertificateHolder = new JcaX509CertificateHolder(certificate);
        HashSet<String> altNamesSet = sslConfig.getSearchPeerToDFWAltNameList();
        Extension subjectAltNamesExtension = x509CertificateHolder.getExtension(Extension.subjectAlternativeName);
        ASN1Encodable subjectAltNamesEncodable = subjectAltNamesExtension.getParsedValue();
        if (subjectAltNamesEncodable instanceof DLSequence) {
            DLSequence subjectAltNamesSequence = (DLSequence)subjectAltNamesEncodable;
            for (ASN1Encodable subjectAltNameEncodable : subjectAltNamesSequence) {
                DERUTF8String subjectAltNameDerutf8String;
                String subjectAltName;
                DERTaggedObject subjectAltNameDerTaggedObject;
                if (!(subjectAltNameEncodable instanceof DERTaggedObject) || (subjectAltNameDerTaggedObject = (DERTaggedObject)subjectAltNameEncodable).getTagNo() != 2 || !altNamesSet.contains((subjectAltName = (subjectAltNameDerutf8String = DERUTF8String.getInstance((ASN1TaggedObject)subjectAltNameDerTaggedObject, (boolean)false)).getString()).toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static void checkCertificateValidity(KeyStore keyStore) throws KeyStoreException, CertificateExpiredException, CertificateNotYetValidException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            Certificate cert = keyStore.getCertificate(alias);
            if (cert == null || !(cert instanceof X509Certificate)) continue;
            X509Certificate x509Cert = (X509Certificate)cert;
            x509Cert.checkValidity();
        }
    }

    public static boolean isCertificateInKeyStore(String storePath, String storePassword, X509Certificate certificate) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (FileInputStream inputStreamStore = new FileInputStream(storePath);){
            keyStore.load(inputStreamStore, storePassword.toCharArray());
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Cert;
            String alias = enumeration.nextElement();
            Certificate cert = keyStore.getCertificate(alias);
            if (cert == null || !(cert instanceof X509Certificate) || !(x509Cert = (X509Certificate)cert).equals(certificate)) continue;
            return true;
        }
        return false;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

