/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.Row;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.visitors.ExpressionEvaluator;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.search.compute.transformers.SortTransformer;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class HeadTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(HeadTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return HeadTransformer._transform(ctx, dd, (HeadCommand)qcmd, streaming);
    }

    private static long getMaxLimit() {
        long limit = 100000L;
        String limitStr = System.getenv("MAX_HEAD_LIMIT");
        if (limitStr != null) {
            try {
                limit = Long.parseLong(limitStr);
                logger.info((Object)String.format("setting head limit to: %d based envvar", limit));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("error parsing limit: %s", limitStr));
            }
        }
        return limit;
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, HeadCommand headCmd, boolean streaming) {
        boolean executeExternal;
        long maxLimit;
        final long limit = Long.parseLong(headCmd.getLimit().toString());
        if (limit > (maxLimit = HeadTransformer.getMaxLimit())) {
            throw new RuntimeException(String.format("max head limit set to: %d, can be increased through envvar", maxLimit));
        }
        DistributedDataset outputdd = dd;
        CommandNode source = headCmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)headCmd, source);
        if (executeExternal) {
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)headCmd, ctx);
            logger.debug((Object)" will execute base transformer to input create dataset");
        } else {
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(source);
            if (t instanceof SortTransformer) {
                ctx.addContext("headImposedLimit", (int)limit);
                logger.info((Object)String.format("since the source is a sort transformer setting the head imposed limit to: %d", limit));
            }
            logger.debug((Object)String.format("Using source transformer - %s", source.getCommandName()));
            outputdd = t.transform(outputdd, source, streaming, ctx);
            ctx.removeContext("headImposedLimit");
        }
        IWherePredicate wherePredicate = headCmd.getPredicate();
        if (wherePredicate != null) {
            final Node predicateNode = wherePredicate.getNode();
            final boolean fillNull = headCmd.getNullIsMatch().getValue();
            final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
            outputdd = outputdd.transform(new MapPartitioner(){
                private static final long serialVersionUID = 1L;
                private boolean stop = false;

                @Override
                public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                    LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                    while (iterator.hasNext()) {
                        Row row;
                        Object eval;
                        SearchResult searchResult = iterator.next();
                        if (this.stop || limit != 0L && (long)fifo.size() >= limit || !((eval = expressionEvaluator.evaluate(predicateNode, row = new Row(SearchResultFactory.convert(searchResult.getDataMap())), fillNull)) instanceof Boolean)) continue;
                        if (((Boolean)eval).booleanValue()) {
                            fifo.add(searchResult);
                            continue;
                        }
                        this.stop = true;
                        fifo.add(searchResult);
                    }
                    return fifo.iterator();
                }

                @Override
                public boolean repartition() {
                    return false;
                }

                @Override
                public FieldExtractor.ExtractionHint fieldExtractionHint() {
                    return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
                }
            });
            outputdd = outputdd.coalesce(1);
            final Boolean keeplast = headCmd.getKeeplast().getValue();
            outputdd = outputdd.transform(new MapPartitioner(){
                private static final long serialVersionUID = 1L;
                private boolean stop = false;

                @Override
                public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                    LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                    while (iterator.hasNext()) {
                        Row row;
                        Object eval;
                        SearchResult searchResult = iterator.next();
                        if (this.stop || limit != 0L && (long)fifo.size() >= limit || !((eval = expressionEvaluator.evaluate(predicateNode, row = new Row(SearchResultFactory.convert(searchResult.getDataMap())), fillNull)) instanceof Boolean)) continue;
                        if (((Boolean)eval).booleanValue()) {
                            fifo.add(searchResult);
                            continue;
                        }
                        this.stop = true;
                        if (!keeplast.booleanValue()) continue;
                        fifo.add(searchResult);
                    }
                    return fifo.iterator();
                }

                @Override
                public boolean repartition() {
                    return false;
                }

                @Override
                public FieldExtractor.ExtractionHint fieldExtractionHint() {
                    return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
                }
            });
        }
        if (limit > 0L) {
            outputdd = outputdd.limit(limit);
            logger.debug((Object)String.format("Limit set on dataset: %d", limit));
        }
        return outputdd;
    }

    @Override
    public String name() {
        return "HeadTransformer";
    }
}

