/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.Row;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.visitors.ExpressionEvaluator;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EvalTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(EvalTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return EvalTransformer._transform(ctx, dd, (EvalCommand)qcmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, EvalCommand evalCmd, final boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = evalCmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)evalCmd, srcCmd);
        if (executeExternal) {
            logger.debug((Object)"Will execute base transformer to input create dataset");
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)evalCmd, ctx);
        } else {
            String cmdName = srcCmd.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
            logger.debug((Object)String.format("Will apply eval expression processing on output of %s transformer", cmdName));
        }
        final AssignmentNode[] assigns = evalCmd.getAssignments();
        final SearchResult.FieldMeta[] assignFields = new SearchResult.FieldMeta[assigns.length];
        final int assignsLen = assigns.length;
        for (int i = 0; i < assignsLen; ++i) {
            AssignmentNode an = assigns[i];
            assignFields[i] = new SearchResult.FieldMeta(an.getFieldName(), i, SearchResult.FieldType.UNKNOWN);
        }
        final ExpressionEvaluator ee = new ExpressionEvaluator();
        outputdd = outputdd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                Row row = new Row(SearchResultFactory.convert(sr.getDataMap()));
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[sr.getFieldNames().length + assignsLen];
                Object[] vals = new Object[sr.getFieldNames().length + assignsLen];
                int fldsIndex = 0;
                SearchResult.FieldMeta[] fieldMetaArray = sr.getFieldNames();
                int n = fieldMetaArray.length;
                for (int i = 0; i < n; ++i) {
                    SearchResult.FieldMeta fieldName;
                    fields[fldsIndex] = fieldName = fieldMetaArray[i];
                    vals[fldsIndex] = sr.getFieldValue(fieldName);
                    ++fldsIndex;
                }
                ArrayList<SearchResult.FieldMeta> mvFieldsList = new ArrayList<SearchResult.FieldMeta>();
                ArrayList<Object> mvValuesList = new ArrayList<Object>();
                for (int i = 0; i < assignsLen; ++i) {
                    SearchResult.FieldMeta fieldName;
                    Object value;
                    AssignmentNode assign = assigns[i];
                    try {
                        value = ee.evaluate((Node)assign.getExpression(), row);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception caught while evaluating expression", (Throwable)e);
                        value = null;
                    }
                    fields[i + fldsIndex] = fieldName = assignFields[i];
                    if (value instanceof String[]) {
                        mvFieldsList.add(fieldName);
                        mvValuesList.add(value);
                        value = StringUtils.join((Object[])((String[])value), (String)",");
                    }
                    vals[i + fldsIndex] = value;
                    row.put(assign.getFieldName(), value);
                }
                if (mvFieldsList.size() > 0) {
                    SearchResult.FieldMeta[] retFields = new SearchResult.FieldMeta[fields.length + mvFieldsList.size()];
                    Object[] retVals = new Object[vals.length + mvFieldsList.size()];
                    System.arraycopy(fields, 0, retFields, 0, fields.length);
                    System.arraycopy(vals, 0, retVals, 0, fields.length);
                    for (int j = 0; j < mvFieldsList.size(); ++j) {
                        SearchResult.FieldMeta mvFieldName = (SearchResult.FieldMeta)mvFieldsList.get(j);
                        String[] aggrValueStrArray = (String[])mvValuesList.get(j);
                        StringBuilder sb = new StringBuilder();
                        for (String s : aggrValueStrArray) {
                            sb.append("$");
                            sb.append(s.replace("$", "$$"));
                            sb.append("$;");
                        }
                        if (sb.length() <= 0) continue;
                        retFields[fields.length + j] = mvFieldName.prepend("__mv_");
                        retVals[fields.length + j] = sb.toString();
                        row.put("__mv_" + mvFieldName, (Object)sb.toString());
                    }
                    fields = retFields;
                    vals = retVals;
                }
                return SearchResultFactory.getInstance().createSearchResult(SearchResultFactory.convert(row.getDataMap(), fields), fields, vals);
            }

            @Override
            public boolean repartition() {
                return !streaming;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }
        });
        return outputdd;
    }

    @Override
    public String name() {
        return "com.splunk.df.search.compute.transformers.EvalTransformer";
    }
}

