/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import org.apache.log4j.Logger;

public class DedupTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(DedupTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        boolean isPreDedup = false;
        DedupCommand dedupCmd = (DedupCommand)cmd;
        CommandNode srcCommand = cmd.getSource();
        if (srcCommand == null) {
            logger.error((Object)"Source for dedup command not present in the AST");
            throw new RuntimeException("Source for dedup command not present in the AST");
        }
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, srcCommand);
        if (executeExternal) {
            logger.info((Object)String.format("Looks like no reporting command is present in upstream command list: %s, hence triggering base transformer to read the initial srs", srcCommand.getCommandName()));
            DedupCommand customCommand = dedupCmd;
            if (BaseTransformerFactory.getInstance().isPreStaged(ctx)) {
                isPreDedup = true;
                customCommand = dedupCmd.convertToPreDedup(srcCommand);
            }
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)customCommand, ctx);
        } else {
            logger.info((Object)String.format("will invoke the source transformer since it appears reporting: %s", srcCommand.getCommandName()));
            String cmdName = srcCommand.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCommand);
            if (t == null) {
                logger.error((Object)("Source transformer not found for command " + cmdName));
                throw new RuntimeException("Source transformer not found for command " + cmdName);
            }
            outputdd = t.transform(dd, srcCommand, streaming, ctx);
        }
        FieldNode[] fields = dedupCmd.getFields();
        if (fields != null && fields.length > 0) {
            logger.debug((Object)String.format("will execute dedup operation since found: %d fields", fields.length));
            outputdd = outputdd.dedup(dedupCmd, executeExternal);
        } else {
            logger.debug((Object)String.format("no fields found inside dedup command hence not executing dedup operation", new Object[0]));
        }
        return outputdd;
    }

    @Override
    public String name() {
        return "DedupTransformer";
    }
}

