/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ExecutionHints;
import org.apache.log4j.Logger;

public class SparkExecutionHints
implements ExecutionHints,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SparkExecutionHints.class);
    private final double dfcExecutorMemMbs;
    private final double dfcDriverMemMbs;
    private final int dfcNumCores;
    private final double dfcCoresPerExecutor;
    private final double factor;
    private final long maxReducePartitionSize;

    public SparkExecutionHints(double dfcExecutorMemMbs, double dfcDriverMemMbs, int dfcNumCores, double dfcCoresPerExecutor, long maxReducePartitionSize) {
        this.dfcExecutorMemMbs = dfcExecutorMemMbs;
        this.dfcDriverMemMbs = dfcDriverMemMbs;
        this.dfcNumCores = dfcNumCores;
        this.dfcCoresPerExecutor = dfcCoresPerExecutor;
        this.factor = dfcExecutorMemMbs / 12288.0 * (5.0 / dfcCoresPerExecutor);
        this.maxReducePartitionSize = maxReducePartitionSize;
    }

    protected String getEnv(String name) {
        return System.getenv(name);
    }

    public long getMaxReducePartitionSize() {
        long parSize = this.maxReducePartitionSize;
        String parSizeStr = this.getEnv("MAX_REDUCE_PARTITION_SIZE");
        if (parSizeStr != null && !parSizeStr.trim().isEmpty()) {
            parSize = Long.valueOf(parSizeStr);
            logger.info((Object)String.format("Getting maximum reduce partition size from env variables: MAX_REDUCE_PARTITION_SIZE=%d", parSize));
        }
        logger.info((Object)String.format("Max overall reduce partition size capped at: %d", parSize));
        return parSize;
    }

    @Override
    public int reducePartitionCount(long recsCount, int numfields) {
        if (numfields == 0) {
            numfields = 1;
            logger.warn((Object)String.format("Num fields value was 0 defaulting to 1", new Object[0]));
        }
        double reduceParSizeDbl = this.getMaxReducePartitionSize();
        double numFieldsDbl = numfields;
        double fieldFactor = 6.0 / numFieldsDbl;
        long reduceParSize = (int)(reduceParSizeDbl * this.factor * fieldFactor);
        reduceParSize = Math.min(reduceParSize, this.getMaxReducePartitionSize());
        int numPars = (int)(recsCount / reduceParSize);
        numPars = Math.max(this.dfcNumCores, numPars);
        this.checkAllowedPartitions(numPars);
        logger.info((Object)String.format("Record count: %d, reduce partition count: %d, reduce par size: %d, cores per exec: %.2f, executor memory in mbs: %.2f, num fields: %d", recsCount, numPars, reduceParSize, this.dfcCoresPerExecutor, this.dfcExecutorMemMbs, numfields));
        return numPars;
    }

    private void checkAllowedPartitions(int numPars) {
        int maxPars = (int)(300000.0 * (this.dfcDriverMemMbs / 4096.0));
        if (numPars > (maxPars = Math.max(this.dfcNumCores, maxPars))) {
            throw new RuntimeException(String.format("maximum tasks which can be executed by this driver with mem: %.2f mbs is: %d, while the requested partitions: %d, pls increase driver memory", this.dfcDriverMemMbs, maxPars, numPars));
        }
    }

    private static double getSortParRatioToReduce() {
        double ratio = 1.0;
        String ratioStr = System.getenv("SORT_PARTITION_TO_REDUCE_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("sort partition ratio to reduce overridden by envvar: %.2f", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse sort partition ratio to reduce: %s as double", ratioStr));
            }
        }
        logger.info((Object)String.format("sort partition to reduce partition to be used: %.2f", ratio));
        return ratio;
    }

    @Override
    public int sortPartitionCount(long recsCount, int numfields) {
        int numPars = (int)((double)this.reducePartitionCount(recsCount, numfields) * SparkExecutionHints.getSortParRatioToReduce());
        numPars = Math.max(this.dfcNumCores, numPars);
        this.checkAllowedPartitions(numPars);
        logger.info((Object)String.format("sort partition count set to: %d", numPars));
        return numPars;
    }

    @Override
    public int lightJoinPartitionCount(long recsCount, int numfields) {
        int numPars = this.reducePartitionCount(recsCount, numfields) * 50;
        this.checkAllowedPartitions(numPars);
        numPars = Math.max(this.dfcNumCores, numPars);
        return numPars;
    }

    @Override
    public int joinPartitionCount(long recsCount, int numfields) {
        int numPars = this.reducePartitionCount(recsCount, numfields) * 50;
        this.checkAllowedPartitions(numPars);
        numPars = Math.max(this.dfcNumCores, numPars);
        return numPars;
    }

    @Override
    public int defaultPartitionCount(long recsCount, int numFields) {
        return this.reducePartitionCount(recsCount, numFields);
    }
}

