/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.SplunkEventChunk;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@Deprecated
public class SplunkEventReceiverManager {
    static final Logger logger = Logger.getLogger(SplunkEventReceiverManager.class);
    private static final int CHUNK_CACHE_SIZE = 20;
    static String recordingFolder = System.getenv("DFS_HOME") + "/recording/";
    private static SplunkEventReceiverManager singleton = null;
    private HashMap<String, SplunkEventReceivers> receiverMap = new HashMap();
    private ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    private SplunkEventReceiverManager() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplunkEventReceiverManager getInstance() {
        if (singleton != null) {
            return singleton;
        }
        Class<SplunkEventReceiverManager> clazz = SplunkEventReceiverManager.class;
        synchronized (SplunkEventReceiverManager.class) {
            singleton = new SplunkEventReceiverManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private void start() {
    }

    public void stopReceiver(String uuid, int port) {
        SplunkEventReceivers receivers = this.receiverMap.get(uuid);
        if (receivers == null) {
            logger.info((Object)("No receivers found for uuid: " + uuid));
            return;
        }
        receivers.stopReceiving(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRdInListener(final String uuid, final ServerSocket ss) {
        SplunkEventReceivers receivers;
        final int port = ss.getLocalPort();
        HashMap<String, SplunkEventReceivers> hashMap = this.receiverMap;
        synchronized (hashMap) {
            receivers = this.receiverMap.get(uuid);
            if (receivers == null) {
                receivers = new SplunkEventReceivers(uuid);
                this.receiverMap.put(uuid, receivers);
            }
        }
        final SplunkEventReceiver recv = receivers.addReceiver(ss);
        SplunkEventReceivers tempRecvs = receivers;
        final LinkedBlockingDeque<SplunkEventChunk> chunkCache = receivers.getChunkCache();
        this.ses.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    Socket tempS;
                    while ((tempS = ss.accept()) != null) {
                        final Socket s = tempS;
                        SplunkEventReceiverManager.this.ses.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                String senderHost = s.getInetAddress().getHostName();
                                int senderPort = s.getPort();
                                logger.info((Object)("Connected to sender: host: " + senderHost + ", port: " + senderPort));
                                BufferedReader br = null;
                                String line = null;
                                int numChunks = 0;
                                try {
                                    br = new BufferedReader(new InputStreamReader(s.getInputStream()));
                                    while (true) {
                                        if (!br.ready()) {
                                            Thread.sleep(100L);
                                            continue;
                                        }
                                        line = br.readLine();
                                        recv.pokeActivity();
                                        if (line.startsWith("<EOF>")) break;
                                        String header = line;
                                        String sparkLookupCode = br.readLine();
                                        String infoCsv = br.readLine();
                                        String data = br.readLine();
                                        SplunkEventChunk chunk = new SplunkEventChunk(header, data, infoCsv, sparkLookupCode);
                                        while (!chunkCache.offer(chunk, 1000L, TimeUnit.MILLISECONDS)) {
                                            try {
                                                logger.info((Object)"Chunk cache full capacity hence waiting before retrying");
                                                Thread.sleep(100L);
                                            }
                                            catch (Throwable t) {
                                                logger.error((Object)"Error while sleeping");
                                            }
                                        }
                                        ++numChunks;
                                    }
                                    logger.info((Object)("Sender: " + senderHost + ":" + senderPort + " has sent <EOF> hence will close the connection"));
                                    logger.debug((Object)("All events read from sender: " + s.getInetAddress().getHostName() + "; number of chunks: " + numChunks));
                                }
                                catch (Throwable t) {
                                    logger.error((Object)("Error while reading from sender: " + s.getRemoteSocketAddress()), t);
                                }
                                finally {
                                    if (br != null) {
                                        try {
                                            br.close();
                                            logger.debug((Object)("Closed reader for sender: " + s.getRemoteSocketAddress()));
                                        }
                                        catch (Throwable t) {
                                            logger.error((Object)"Error while closing sender reader", t);
                                        }
                                    }
                                    try {
                                        s.close();
                                        logger.debug((Object)("Closed sender: " + s.getRemoteSocketAddress()));
                                    }
                                    catch (Throwable t) {
                                        logger.error((Object)"Error while closing socket", t);
                                    }
                                }
                            }
                        }, 0L, TimeUnit.SECONDS);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)("Error in receiver: " + recv + " the receiver might have been closed: " + t.getMessage()));
                    SplunkEventReceiverManager.this.stopReceiver(uuid, port);
                }
            }
        }, 0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(final String uuid, final ServerSocket ss) {
        SplunkEventReceivers receivers;
        final int port = ss.getLocalPort();
        HashMap<String, SplunkEventReceivers> hashMap = this.receiverMap;
        synchronized (hashMap) {
            receivers = this.receiverMap.get(uuid);
            if (receivers == null) {
                receivers = new SplunkEventReceivers(uuid);
                this.receiverMap.put(uuid, receivers);
            }
        }
        final SplunkEventReceiver recv = receivers.addReceiver(ss);
        SplunkEventReceivers tempRecvs = receivers;
        final LinkedBlockingDeque<SplunkEventChunk> chunkCache = receivers.getChunkCache();
        this.ses.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    Socket tempS;
                    while ((tempS = ss.accept()) != null) {
                        final Socket s = tempS;
                        SplunkEventReceiverManager.this.ses.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                String senderHost = s.getInetAddress().getHostName();
                                int senderPort = s.getPort();
                                logger.info((Object)("Connected to sender: host: " + senderHost + ", port: " + senderPort));
                                BufferedReader br = null;
                                String line = null;
                                int numChunks = 0;
                                try {
                                    br = new BufferedReader(new InputStreamReader(s.getInputStream()));
                                    while (true) {
                                        if (!br.ready()) {
                                            Thread.sleep(100L);
                                            continue;
                                        }
                                        line = br.readLine();
                                        recv.pokeActivity();
                                        if (line.startsWith("<EOF>")) break;
                                        String header = line;
                                        String sparkLookupCode = br.readLine();
                                        String infoCsv = br.readLine();
                                        String data = br.readLine();
                                        SplunkEventChunk chunk = new SplunkEventChunk(header, data, infoCsv, sparkLookupCode);
                                        while (!chunkCache.offer(chunk, 1000L, TimeUnit.MILLISECONDS)) {
                                            try {
                                                logger.info((Object)"Chunk cache full capacity hence waiting before retrying");
                                                Thread.sleep(100L);
                                            }
                                            catch (Throwable t) {
                                                logger.error((Object)"Error while sleeping");
                                            }
                                        }
                                        ++numChunks;
                                    }
                                    logger.info((Object)("Sender: " + senderHost + ":" + senderPort + " has sent <EOF> hence will close the connection"));
                                    logger.debug((Object)("All events read from sender: " + s.getInetAddress().getHostName() + "; number of chunks: " + numChunks));
                                }
                                catch (Throwable t) {
                                    logger.error((Object)("Error while reading from sender: " + s.getRemoteSocketAddress()), t);
                                }
                                finally {
                                    if (br != null) {
                                        try {
                                            br.close();
                                            logger.error((Object)("Closed reader for sender: " + s.getRemoteSocketAddress()));
                                        }
                                        catch (Throwable t) {
                                            logger.error((Object)"Error while closing sender reader", t);
                                        }
                                    }
                                    try {
                                        s.close();
                                        logger.debug((Object)("Closed sender: " + s.getRemoteSocketAddress()));
                                    }
                                    catch (Throwable t) {
                                        logger.error((Object)"Error while closing socket", t);
                                    }
                                }
                            }
                        }, 0L, TimeUnit.SECONDS);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)("Error in receiver: " + recv + " the receiver might have been closed: " + t.getMessage()));
                    SplunkEventReceiverManager.this.stopReceiver(uuid, port);
                }
            }
        }, 0L, TimeUnit.SECONDS);
    }

    public SplunkEventChunk getNextEventChunk(String uuid) throws InterruptedException {
        SplunkEventReceivers receivers = this.receiverMap.get(uuid);
        if (receivers == null) {
            logger.info((Object)("No receiver found for uuid: " + uuid));
            return null;
        }
        LinkedBlockingDeque<SplunkEventChunk> chunkCache = receivers.getChunkCache();
        SplunkEventChunk chunk = null;
        chunk = chunkCache.poll(100L, TimeUnit.MILLISECONDS);
        if (chunk != null) {
            // empty if block
        }
        return chunk;
    }

    public boolean hasMoreChunks(String uuid) {
        SplunkEventReceivers recvs = this.receiverMap.get(uuid);
        return !recvs.getChunkCache().isEmpty();
    }

    static class SplunkEventReceivers {
        private LinkedBlockingDeque<SplunkEventChunk> chunkCache;
        private ArrayList<SplunkEventReceiver> receivers;
        private long startTime;
        private String uuid;

        SplunkEventReceivers(String uuid) {
            this.uuid = uuid;
            this.chunkCache = new LinkedBlockingDeque(20);
            this.receivers = new ArrayList();
            this.startTime = System.currentTimeMillis();
        }

        long getStartTime() {
            return this.startTime;
        }

        int getNoOfReceivers() {
            return this.receivers.size();
        }

        LinkedBlockingDeque<SplunkEventChunk> getChunkCache() {
            return this.chunkCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SplunkEventReceiver addReceiver(ServerSocket ss) {
            SplunkEventReceiver recv = new SplunkEventReceiver(this.uuid, ss);
            ArrayList<SplunkEventReceiver> arrayList = this.receivers;
            synchronized (arrayList) {
                this.receivers.add(recv);
            }
            return recv;
        }

        void removeReceiver(SplunkEventReceiver recv) {
            recv.close();
            this.receivers.remove(recv);
        }

        public boolean isEmpty() {
            return this.receivers.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopReceiving(int port) {
            ArrayList<SplunkEventReceiver> arrayList = this.receivers;
            synchronized (arrayList) {
                for (SplunkEventReceiver receiver : this.receivers) {
                    if (receiver.port != port) continue;
                    receiver.close();
                    this.receivers.remove(receiver);
                    logger.info((Object)("Stopped and removed receiver: " + receiver));
                    break;
                }
            }
        }
    }

    private static class SplunkEventReceiver {
        private ServerSocket ss;
        private int port;
        private String uuid;

        SplunkEventReceiver(String uuid, ServerSocket ss) {
            this.uuid = uuid;
            this.ss = ss;
            this.port = ss.getLocalPort();
        }

        void pokeActivity() {
        }

        public String toString() {
            return "receiver-at-port:" + this.port + " uuid: " + this.uuid;
        }

        void close() {
            if (this.ss == null) {
                logger.info((Object)("Receiver: " + this + " already closed"));
                return;
            }
            try {
                this.ss.close();
                this.ss = null;
                logger.debug((Object)("Closed receiver: " + this.toString()));
            }
            catch (Throwable t) {
                logger.error((Object)"Could not close server socket", t);
            }
        }
    }
}

