/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.Job;
import com.splunk.commons.search.HostPort;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.FSHSearchResultShuffler;
import com.splunk.df.search.FSHSplunkConnectionHandler;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FSHTriggerDDFactory
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(FSHTriggerDDFactory.class);

    public static HashMap<String, String> executeFSHTrigger(DistributedDataset fshTriggerDD, final HashMap<Integer, FederatedDataSetInfo> dataSetInfoMap, final HashMap<String, List<String>> dataSetToRemoteSid, List<HostPort> toIPList, final String originalUser) {
        StringBuilder sb = new StringBuilder();
        for (HostPort hp : toIPList) {
            sb.append(String.format("%s-", hp.toString()));
        }
        final String hpListString = sb.toString();
        DistributedDataset fshTriggerExecutor = fshTriggerDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                String connectionId = (String)sr.getFieldValue(ComputeEngineConstants.FSH_CONNECTION_ID);
                SplunkSearchEndpoint sse = (SplunkSearchEndpoint)sr.getFieldValue(ComputeEngineConstants.SPLUNK_SEARCH_HEAD);
                String remoteSidForRemote = null;
                ArrayList localSidList = new ArrayList();
                ArrayList<String> remoteSidList = new ArrayList<String>();
                HashSet<String> triggeredRemoteSid = new HashSet<String>();
                try {
                    for (FederatedDataSetInfo dataSetInfo : dataSetInfoMap.values()) {
                        if (!dataSetInfo.getDeploymentName().equalsIgnoreCase(dInfo.getDeploymentName())) continue;
                        for (Map.Entry entry : dataSetToRemoteSid.entrySet()) {
                            String[] kindAndName = ((String)entry.getKey()).split(":", 2);
                            String dataSetName = kindAndName[1];
                            if (!dataSetName.equalsIgnoreCase(dataSetInfo.getDatasetName())) continue;
                            String[] hpList = hpListString.split("-");
                            ArrayList<HostPort> toSendIPList = new ArrayList<HostPort>();
                            for (int j = 0; j < hpList.length; ++j) {
                                String[] hp = hpList[j].split(":");
                                HostPort hostPort = new HostPort(hp[0], Integer.parseInt(hp[1]));
                                toSendIPList.add(hostPort);
                            }
                            SplunkReleaseVersion currentSplunkVersion = dInfo.getDeploymentVersion();
                            logger.info((Object)String.format("The Splunk version for deployment=%s is %s", dInfo.getDeploymentName(), currentSplunkVersion.toString()));
                            for (int numSid = 0; numSid < ((List)entry.getValue()).size(); ++numSid) {
                                String remoteSid = (String)((List)entry.getValue()).get(numSid);
                                if (triggeredRemoteSid.contains(remoteSid)) continue;
                                triggeredRemoteSid.add(remoteSid);
                                if (currentSplunkVersion.compareTo(SplunkReleaseVersion.ORANGESWIRL) >= 0) {
                                    logger.info((Object)"Executing partitioned execution.");
                                    Pair<String, Job> pe = FSHSplunkConnectionHandler.triggerPartitionedQuery(remoteSid, originalUser, connectionId, dataSetInfo.getSearch(), toSendIPList);
                                    FSHSearchResultShuffler.getInstance().handlePartitionedExecution(connectionId, pe.first(), pe.second(), toSendIPList, sse, dataSetInfo.getSearch());
                                    remoteSidForRemote = pe.first();
                                } else {
                                    logger.info((Object)"Executing non-partitioned execution.");
                                    Pair<String, Job> npe = FSHSplunkConnectionHandler.triggerNonPartitionedQuery(remoteSid, connectionId, dataSetInfo.getSearch());
                                    FSHSearchResultShuffler.getInstance().handleNonPartitionedExecution(connectionId, npe.first(), npe.second(), toSendIPList, sse, dataSetInfo.getSearch());
                                    remoteSidForRemote = npe.first();
                                }
                                localSidList.add(((List)entry.getValue()).get(numSid));
                                remoteSidList.add(remoteSidForRemote);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH trigger execution, details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_LOCAL_SID_FOR_REMOTE, ComputeEngineConstants.FSH_REMOTE_SID_FOR_REMOTE};
                Object[] vals = new Object[]{localSidList, remoteSidList};
                SearchResult sidMap = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return sidMap;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }
        });
        HashMap<String, String> localToRemoteSidMap = new HashMap<String, String>();
        Iterator<SearchResult> resultsItr = fshTriggerExecutor.retrieve();
        while (resultsItr.hasNext()) {
            SearchResult sr = resultsItr.next();
            if (sr == null || sr.isEmpty()) continue;
            ArrayList localSid = (ArrayList)sr.getDataMap().get(ComputeEngineConstants.FSH_LOCAL_SID_FOR_REMOTE);
            if (localSid == null || localSid.size() == 0) {
                logger.warn((Object)"LocalSid is NULL");
                continue;
            }
            ArrayList remoteSid = (ArrayList)sr.getDataMap().get(ComputeEngineConstants.FSH_REMOTE_SID_FOR_REMOTE);
            if (remoteSid == null || remoteSid.size() == 0) {
                logger.warn((Object)"RemoteSid is NULL");
                continue;
            }
            assert (localSid.size() == remoteSid.size());
            for (int i = 0; i < localSid.size(); ++i) {
                localToRemoteSidMap.put((String)localSid.get(i), (String)remoteSid.get(i));
            }
        }
        return localToRemoteSidMap;
    }

    public static HashMap<String, String> executeFSHPartitioningAndTrigger(DistributedDataset root, HashMap<Integer, FederatedDataSetInfo> dataSetInfoMap, HashMap<String, FederatedDeploymentInfo> deploymentInfoMap, HashMap<String, List<String>> dataSetToRemoteSid, List<HostPort> toIPList, String originalUser) {
        List<SearchResult> fshPlaceHolder = FSHTriggerDDFactory.getFSHPlaceHolders(dataSetInfoMap, deploymentInfoMap, dataSetToRemoteSid, toIPList);
        DistributedDataset fshPlaceHolderDD = root.resetSearchResults(fshPlaceHolder, fshPlaceHolder.size());
        DistributedDataset fshTriggerDD = FSHTriggerDDFactory.triggerAndGetSID(originalUser, fshPlaceHolderDD);
        fshTriggerDD = fshTriggerDD.cacheMem();
        long numTriggers = fshTriggerDD.count();
        HashMap<String, String> localToRemoteSidForFSH = FSHTriggerDDFactory.getSidMap(fshTriggerDD);
        logger.info((Object)("Number of remote deployments triggered:" + numTriggers));
        return localToRemoteSidForFSH;
    }

    private static HashMap<String, String> getSidMap(DistributedDataset fshTriggerDD) {
        fshTriggerDD = fshTriggerDD.repartition(1);
        Iterator<SearchResult> srItr = fshTriggerDD.retrieve();
        logger.info((Object)"Creating the Logical-Physical sid map.");
        HashMap<String, String> localToRemoteSidMap = new HashMap<String, String>();
        while (srItr.hasNext()) {
            String remoteSid;
            SearchResult sr = srItr.next();
            if (sr.isEmpty()) continue;
            String localSid = (String)sr.getDataMap().get(ComputeEngineConstants.FSH_LOCAL_SID_FOR_REMOTE);
            if (localSid == null) {
                logger.warn((Object)"LocalSid is NULL");
            }
            if ((remoteSid = (String)sr.getDataMap().get(ComputeEngineConstants.FSH_REMOTE_SID_FOR_REMOTE)) == null) {
                logger.warn((Object)"RemoteSid is NULL");
            }
            localToRemoteSidMap.put(localSid, remoteSid);
        }
        return localToRemoteSidMap;
    }

    private static List<SearchResult> getFSHPlaceHolders(HashMap<Integer, FederatedDataSetInfo> dataSetInfoMap, HashMap<String, FederatedDeploymentInfo> deploymentInfoMap, HashMap<String, List<String>> dataSetToRemoteSid, List<HostPort> toIPList) {
        ArrayList<SearchResult> fshPlaceHolder = new ArrayList<SearchResult>();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_LOCAL_SID_FOR_REMOTE, ComputeEngineConstants.SPLUNK_SEARCH_HEAD, ComputeEngineConstants.FSH_IP_LIST_TO_DISTRIBUTE};
        for (Map.Entry<String, List<String>> entry : dataSetToRemoteSid.entrySet()) {
            ListIterator<String> litr = entry.getValue().listIterator();
            while (litr.hasNext()) {
                String lsid = litr.next();
                String[] kindAndName = entry.getKey().split(":", 2);
                String dataSetName = kindAndName[1];
                FederatedDataSetInfo dataSetInfo = dataSetInfoMap.get(dataSetName);
                FederatedDeploymentInfo deploymentInfo = deploymentInfoMap.get(dataSetInfo.getDeploymentName());
                SplunkSearchEndpoint sidssh = new SplunkSearchEndpoint(deploymentInfo.getIP(), deploymentInfo.getPort(), deploymentInfo.getServiceAccount(), deploymentInfo.getPassword(), dataSetInfo.getSearch(), deploymentInfo.getDeploymentVersion());
                Object[] vals = new Object[]{lsid, sidssh, toIPList};
                fshPlaceHolder.add(SearchResultFactory.getInstance().createSearchResult(fields, vals));
            }
        }
        return fshPlaceHolder;
    }

    private static DistributedDataset triggerAndGetSID(final String originalUser, DistributedDataset fshPlaceHoldersdd) {
        DistributedDataset triggerDD = fshPlaceHoldersdd.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                if (sr.getDataMap().isEmpty()) {
                    return SearchResultFactory.getInstance().emptyResult();
                }
                SplunkSearchEndpoint sse = (SplunkSearchEndpoint)sr.getFieldValue(ComputeEngineConstants.SPLUNK_SEARCH_HEAD);
                List toSendIPList = (List)sr.getFieldValue(ComputeEngineConstants.FSH_IP_LIST_TO_DISTRIBUTE);
                String localSidForRemote = (String)sr.getFieldValue(ComputeEngineConstants.FSH_LOCAL_SID_FOR_REMOTE);
                String remoteSidForRemote = null;
                try {
                    String connectionId = FSHSplunkConnectionHandler.getNewConnection(sse);
                    SplunkReleaseVersion testSplunkVersion = new SplunkReleaseVersion(FSHSplunkConnectionHandler.getVersion(connectionId));
                    SplunkReleaseVersion currentSplunkVersion = sse.getVersion();
                    if (currentSplunkVersion.compareTo(SplunkReleaseVersion.ORANGESWIRL) >= 0) {
                        logger.info((Object)"Executing partitioned execution.");
                        Pair<String, Job> pe = FSHSplunkConnectionHandler.triggerPartitionedQuery(null, originalUser, connectionId, connectionId, toSendIPList);
                        FSHSearchResultShuffler.getInstance().handlePartitionedExecution(connectionId, pe.first(), pe.second(), toSendIPList, sse);
                        remoteSidForRemote = pe.first();
                    } else {
                        logger.info((Object)"Executing non-partitioned execution.");
                        Pair<String, Job> npe = FSHSplunkConnectionHandler.triggerNonPartitionedQuery(null, connectionId, connectionId);
                        FSHSearchResultShuffler.getInstance().handleNonPartitionedExecution(connectionId, npe.first(), npe.second(), toSendIPList, sse);
                        remoteSidForRemote = npe.first();
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH trigger execution, details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_LOCAL_SID_FOR_REMOTE, ComputeEngineConstants.FSH_REMOTE_SID_FOR_REMOTE};
                Object[] vals = new Object[]{localSidForRemote, remoteSidForRemote};
                SearchResult sidMap = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return sidMap;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }
        });
        return triggerDD;
    }
}

