/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCLauncherEmbedded;
import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFExecutionType;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSResourceManager;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.DFSSearchCoordinatorState;
import com.splunk.df.search.compute.ComputeEngineClusterInfo;
import com.splunk.df.search.compute.ComputeEngineClusterManagerFactory;
import com.splunk.df.util.DFSException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DFSearchDispatcher
extends DFCRunnable
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFSearchDispatcher.class);
    public static final int MAX_ALLOWED_PORT = 65535;
    private BufferedWriter writeToSplunk = null;
    private String dfcId;
    private String dfsSid;
    private int dfsMasterPort;
    private DFExecutionType executionType;
    private DFSResourceManager dfsResourceManager;
    private int coordinatorControlPort;
    private int coordinatorNumSlots;
    private int executorNumSlots;
    private boolean executorNumSlotsEnabled;
    private long maxReducePartitionSize;
    private int workerReceivingDataPort;
    private int workerReceivingDataPortCount;
    private static String sparkMasterWebUrl;
    private static int sparkMasterConnectTimeout;
    private String splunkVersion;
    private String extraKryoClasses;
    private String splunkConf;
    private String searchHeadName;

    public DFSearchDispatcher(StringBuilder input, int dfsPort, BufferedReader br, BufferedWriter bw, DFSResourceManager dfsResourceManager) {
        JSONObject obj = new JSONObject(input.toString());
        this.writeToSplunk = bw;
        this.dfsSid = obj.getString("sid");
        try {
            this.coordinatorControlPort = DFSearchDispatcher.getCoordinatorControlPort(obj);
            this.coordinatorNumSlots = DFSearchDispatcher.getCoordinatorNumSlots(obj);
            this.executorNumSlotsEnabled = DFSearchDispatcher.isExecutorNumSlotsEnabled(obj);
            this.executorNumSlots = this.executorNumSlotsEnabled ? DFSearchDispatcher.getExecutorNumSlots(obj) : this.coordinatorNumSlots;
            this.maxReducePartitionSize = DFSearchDispatcher.getMaxReducePartitionSize(obj);
            this.workerReceivingDataPort = DFSearchDispatcher.getWorkerReceivingDataPort(obj);
            this.workerReceivingDataPortCount = DFSearchDispatcher.getWorkerReceivingDataPortCount(obj);
            this.dfcId = this.dfsSid;
            logger.debug((Object)String.format("will use sid as dfc id: %s, hence each search would run in a separate dfc instance", this.dfcId));
            this.dfsMasterPort = dfsPort;
            this.executionType = DFExecutionType.BATCH;
            this.dfsResourceManager = dfsResourceManager;
            this.splunkVersion = obj.getString("splunkVersion");
            this.extraKryoClasses = obj.has("extraKryoRegisteredClasses") ? obj.getString("extraKryoRegisteredClasses") : null;
            this.splunkConf = obj.getJSONObject("splunkConf").toString();
            this.searchHeadName = obj.getString("SplunkServerName");
            sparkMasterWebUrl = DFSearchDispatcher.getSparkMasterWebURL(obj);
            sparkMasterConnectTimeout = DFSearchDispatcher.getSparkMasterTimeout(obj);
        }
        catch (Exception t) {
            logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)t));
            DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, "Error while trying to process request to start Data Fabric Coordinator from splunk search process. Refer to Data Fabric Master logs(SPLUNK_HOME/var/log/splunk/dfs.log) for details.");
            throw new RuntimeException("Unable to process request");
        }
    }

    protected static int getCoordinatorControlPort(JSONObject obj) {
        int port = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfc_control_port");
        logger.debug((Object)String.format("DFC control port (dfc_control_port): %d", port));
        return port;
    }

    protected static int getCoordinatorNumSlots(JSONObject obj) {
        int numSlots = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfc_num_slots");
        logger.debug((Object)String.format("# of DFCs per Search Head (dfc_num_slots): %d", numSlots));
        return numSlots;
    }

    protected static int getExecutorNumSlots(JSONObject obj) {
        int numSlots = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfw_num_slots");
        logger.debug((Object)String.format("(dfw_num_slots) (or) # of DFCs across Search Head Cluster : %d", numSlots));
        return numSlots;
    }

    protected static boolean isExecutorNumSlotsEnabled(JSONObject obj) {
        boolean isExecutorNumSlotsEnabled = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getBoolean("dfw_num_slots_enabled");
        logger.debug((Object)String.format("executor num slots enabled:" + isExecutorNumSlotsEnabled, new Object[0]));
        return isExecutorNumSlotsEnabled;
    }

    protected static long getMaxReducePartitionSize(JSONObject obj) {
        long maxReducePartitionSize = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getLong("dfs_max_reduce_partition_size");
        logger.debug((Object)String.format("Maximum reduce partition size (dfs_max_reduce_partition_size): %d", maxReducePartitionSize));
        return maxReducePartitionSize;
    }

    protected static int getWorkerReceivingDataPort(JSONObject obj) {
        int port = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfw_receiving_data_port");
        logger.debug((Object)String.format("DFW receiving data port (dfw_receiving_data_port): %d", port));
        return port;
    }

    protected static int getWorkerReceivingDataPortCount(JSONObject obj) {
        int count = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfw_receiving_data_port_count");
        logger.debug((Object)String.format("DFW receiving data port count (dfw_receiving_data_port_count): %d", count));
        return count;
    }

    protected static JSONObject getDFSExecutionFromThePayload(JSONObject obj) {
        return obj.getJSONObject("splunkConf").getJSONObject("limits").getJSONObject("dfs");
    }

    protected static String getSparkMasterHost(JSONObject obj) {
        String host = obj.getJSONObject("splunkConf").getJSONObject("server").getString("spark_master_host");
        logger.debug((Object)String.format("Spark Master Host (spark_master_host): %s", host));
        return host;
    }

    protected static int getSparkMasterTimeout(JSONObject obj) {
        int sparkMasterTimeout = obj.getJSONObject("splunkConf").getJSONObject("server").getInt("spark_master_connect_timeout");
        logger.debug((Object)String.format("Spark Master Timeout (spark_master_host): %s", sparkMasterTimeout));
        return sparkMasterTimeout;
    }

    protected static int getSparkMasterWebUIPort(JSONObject obj) {
        int port = obj.getJSONObject("splunkConf").getJSONObject("server").getInt("spark_master_webui_port");
        logger.debug((Object)String.format("Spark Master WebUI Port (spark_master_webui_port): %d", port));
        return port;
    }

    protected static String getSparkMasterWebURL(JSONObject obj) {
        String url;
        String protocol = "http";
        String auth = null;
        String host = DFSearchDispatcher.getSparkMasterHost(obj);
        int port = DFSearchDispatcher.getSparkMasterWebUIPort(obj);
        String path = null;
        String query = null;
        String fragment = null;
        try {
            URI uri = new URI("http", auth, host, port, path, query, fragment);
            url = uri.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        logger.info((Object)String.format("Spark Master Web URL: %s", url));
        return url;
    }

    private static void sendDfcInfoToSplunkd(BufferedWriter writeToSplunk, DFSResourceManager.DFSResourceInfo dri, String sid) {
        try {
            String payload = String.format("%s,127.0.0.1:%d\n", DFSProtocolConstants.PROTO_DFS_ACK.toString(), dri.getDfcPort());
            writeToSplunk.write(payload);
            writeToSplunk.flush();
            logger.info((Object)String.format("Informed splunk about the state of the coordinator: %s, for sid: %s", payload, sid));
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private static void sendDfcFailureToSplunkd(BufferedWriter writeToSplunk, String sid, String errMsg) {
        try {
            logger.error((Object)String.format("Informing splunk that Data Fabric Coordinator could not be started for sid=%s .%s", sid, errMsg));
            String payload = String.format("%s,%s\n", DFSProtocolConstants.PROTO_DFS_FAILED.toString(), errMsg);
            writeToSplunk.write(payload);
            writeToSplunk.flush();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private static int totalMemoryMbs() {
        try {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            if (Class.forName("com.sun.management.OperatingSystemMXBean").isInstance(os)) {
                Method memorySize = os.getClass().getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                memorySize.setAccessible(true);
                return (int)((Long)memorySize.invoke((Object)os, new Object[0]) / 0x100000L);
            }
            throw new RuntimeException(String.format("could not get the total physical memory of the search head member", new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("error getting the total ram size of the search head member: %s", e.getMessage()));
        }
    }

    private static int getMaxSupportedWorkers() {
        int numWorkers = 50;
        String maxWorkersStr = System.getenv("DFC_MAX_WORKERS");
        if (maxWorkersStr != null && !maxWorkersStr.trim().isEmpty()) {
            numWorkers = Integer.valueOf(maxWorkersStr);
        }
        return numWorkers;
    }

    private static int getMaxExecutorCores() {
        int maxCores = 4;
        String maxCoresStr = System.getenv("DFC_MAX_EXECUTOR_CORES");
        if (maxCoresStr != null) {
            try {
                maxCores = Integer.valueOf(maxCoresStr);
                logger.info((Object)String.format("max cores set to: %d based on envvar", maxCores));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s envvar into int, value: ", "DFC_MAX_EXECUTOR_CORES", maxCoresStr));
            }
        }
        logger.info((Object)String.format("max dfc executor cores set to: %d", maxCores));
        return maxCores;
    }

    private static int getNumExecutorLayers() {
        int layers = 1;
        String layersStr = System.getenv("DFS_WORKER_LAYERS");
        if (layersStr != null) {
            try {
                layers = Integer.parseInt(layersStr);
                logger.info((Object)String.format("dfs worker layers set to: %d through envvar", layers));
            }
            catch (Throwable t) {
                logger.error((Object)String.format("could not parse envvar for dfs worker layers: %s", layersStr));
            }
        }
        logger.info((Object)String.format("dfs worker layers set to: %d", layers));
        return layers;
    }

    private static double getMaxDfcExecutorMemoryMbs() {
        double maxMemMbs = 24576.0;
        String maxMemMbsStr = System.getenv("DFC_MAX_EXECUTOR_MEMORY_MBS");
        if (maxMemMbsStr != null && !maxMemMbsStr.trim().isEmpty()) {
            maxMemMbs = Double.valueOf(maxMemMbsStr);
        }
        return maxMemMbs;
    }

    private static double getMaxDfcDriverMemoryMbs() {
        double maxMemMbs = 102400.0;
        String maxMemMbsStr = System.getenv("DFC_MAX_DRIVER_MEMORY_MBS");
        if (maxMemMbsStr != null && !maxMemMbsStr.trim().isEmpty()) {
            maxMemMbs = Double.valueOf(maxMemMbsStr);
            logger.debug((Object)String.format("dfc max driver memory has been set through envvar: %d", (int)maxMemMbs));
        }
        return maxMemMbs;
    }

    private static double getWorkerCoresRatio() {
        double ratio = 1.0;
        String ratioStr = System.getenv("DFC_WORKER_CORES_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("cluster core breater ratio per dfs worker node: %.2f overridden by envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse cluster cores breather ratio: %s into double", ratioStr));
            }
        }
        logger.info((Object)String.format("cluster breather cores ratio: %.2f", ratio));
        return ratio;
    }

    private static double getWorkerMemRatio() {
        double ratio = 0.8;
        String ratioStr = System.getenv("DFC_WORKER_MEM_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("cluster memory breather ratio per dfs worker node: %.2f overridden by envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse cluster memory breather ratio: %s into double", ratioStr));
            }
        }
        logger.info((Object)String.format("cluster memory breather ratio per dfs worker node: %.2f", ratio));
        return ratio;
    }

    private static void startDfc(final String dfcId, int dfsMasterPort, String dfsSid, DFSResourceManager.DFSResourceInfo dri, final DFSResourceManager resourceMgr, final DFExecutionType executionType, int maxNumberOfDFCperSH, int dfExecutorNumSlots, int coordinatorControlPort, long maxReducePartitionSize, int workerReceivingDataPort, int workerReceivingDataPortCount, String splunkVersion, String extraKryoClasses, String splunkConf, String searchHeadName) {
        logger.info((Object)String.format("Starting new dfc instance with id: %s", dfcId));
        logger.info((Object)String.format("Splunk_conf: %s", splunkConf));
        ComputeEngineClusterInfo clusterInfo = ComputeEngineClusterManagerFactory.getInstance().getClusterManager(sparkMasterWebUrl, sparkMasterConnectTimeout).getClusterInfo();
        int numWorkers = clusterInfo.numWorkers();
        int maxWorkers = DFSearchDispatcher.getMaxSupportedWorkers();
        numWorkers = Math.min(numWorkers, maxWorkers);
        logger.info((Object)String.format("Number of dfc workers to be used: %d, total available cluster workers: %d", numWorkers, clusterInfo.numWorkers()));
        int totalMemoryInSHMbs = DFSearchDispatcher.totalMemoryMbs();
        logger.info((Object)String.format("Total available memory in the search head: %d mb", totalMemoryInSHMbs));
        int usableMemory = (int)((double)totalMemoryInSHMbs * 0.75);
        logger.info((Object)String.format("Total usable memory in the search head: %d mb", usableMemory));
        int dfcDriverMemMbs = Math.max(1024, usableMemory / maxNumberOfDFCperSH);
        dfcDriverMemMbs = Math.min(dfcDriverMemMbs, (int)DFSearchDispatcher.getMaxDfcDriverMemoryMbs());
        logger.info((Object)String.format("Memory assigned to the dfc driver is: %d mb", dfcDriverMemMbs));
        int totalCoresInSH = Runtime.getRuntime().availableProcessors();
        int dfcDriverCores = Math.max(1, totalCoresInSH / maxNumberOfDFCperSH);
        logger.info((Object)String.format("Cores assigned to the dfc driver is: %d", dfcDriverCores));
        double minWorkerCores = clusterInfo.minWorkerCores();
        int usableCores = (int)(minWorkerCores * DFSearchDispatcher.getWorkerCoresRatio());
        int dfcCoresPerExecutor = Math.max(1, usableCores / dfExecutorNumSlots);
        dfcCoresPerExecutor = Math.min(dfcCoresPerExecutor, DFSearchDispatcher.getMaxExecutorCores());
        logger.info((Object)String.format("Cores assigned to each dfc executor: %d", dfcCoresPerExecutor));
        int coresAvailable = clusterInfo.totalCores() - clusterInfo.coresUsed();
        int layers = DFSearchDispatcher.getNumExecutorLayers();
        int totalCoresRequired = dfcCoresPerExecutor * numWorkers * layers;
        logger.info((Object)String.format("Total cores required by the dfc: %d", totalCoresRequired));
        if (coresAvailable < totalCoresRequired) {
            throw new RuntimeException(String.format("Cannot start dfc since not enough cores available in cluster: %d cores available, %d dfc cores required", coresAvailable, totalCoresRequired));
        }
        int dfcNumCores = totalCoresRequired;
        int usableWorkerMemMbs = (int)((double)clusterInfo.minWorkerMemMbs() * DFSearchDispatcher.getWorkerMemRatio());
        logger.info((Object)String.format("Total usable memory on a dfc worker: %d mb", usableWorkerMemMbs));
        int dfcExecutorMemMbs = Math.max(1024, usableWorkerMemMbs / dfExecutorNumSlots);
        dfcExecutorMemMbs = Math.min((int)DFSearchDispatcher.getMaxDfcExecutorMemoryMbs(), dfcExecutorMemMbs);
        logger.info((Object)String.format("Memory assigned to a dfc executor: %d mb", dfcExecutorMemMbs));
        int memoryAvailableMbs = clusterInfo.totalMemoryMbs() - clusterInfo.usedMemoryMbs();
        int requiredTotalMemMbs = dfcExecutorMemMbs * numWorkers * layers;
        logger.info((Object)String.format("Total memory required by dfc: %d mb", requiredTotalMemMbs));
        if (memoryAvailableMbs < dfcExecutorMemMbs) {
            throw new RuntimeException(String.format("Cannot start dfc since no more memory available: required: %d mb, available: %d mb", requiredTotalMemMbs, memoryAvailableMbs));
        }
        int dfcNumExecutors = numWorkers * layers;
        if (coordinatorControlPort > 65535) {
            throw new DFSException(logger, String.format("Invalid dfc_control_port: %d specified in limits.conf.", coordinatorControlPort));
        }
        String masterUrl = clusterInfo.masterUrl();
        DFCParams dfcParams = new DFCParams(DFSearchDispatcher.getDfcTitle(searchHeadName, dfsSid), dfcId, coordinatorControlPort, maxReducePartitionSize, workerReceivingDataPort, workerReceivingDataPortCount, dfsMasterPort, dfsSid, dfcNumCores, dfcNumExecutors, dfcExecutorMemMbs, dfcDriverMemMbs, dfcCoresPerExecutor, maxNumberOfDFCperSH, splunkVersion, extraKryoClasses, splunkConf);
        final boolean[] abort = new boolean[1];
        DFCLauncherEmbedded dfcLauncher = new DFCLauncherEmbedded(dfcCoresPerExecutor, dfcNumExecutors, dfcExecutorMemMbs, dfcDriverMemMbs, dfcDriverCores, masterUrl, "com.splunk.df.search.DFSSearchCoordinator", "dfs-0.0.1.jar", dfcParams, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                abort[0] = true;
                logger.error((Object)String.format("DFC launch failed: dfc id: %s", dfcId));
                DFSResourceManager dFSResourceManager = resourceMgr;
                synchronized (dFSResourceManager) {
                    resourceMgr.removeResourceInfo(dfcId, executionType);
                }
            }
        });
        dri.setLauncher(dfcLauncher);
        long start = System.currentTimeMillis();
        while (!dri.getState().equals(DFSSearchCoordinatorState.RUNNING)) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (abort[0]) {
                throw new RuntimeException(String.format("DFC failed to start: dfs id: %s", dfcId));
            }
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed <= 60000L) continue;
            throw new RuntimeException(String.format("DFC start timeout exceeded: %d millis", elapsed));
        }
        logger.info((Object)String.format("DFC instance started on port: %d, dfs d: %s", dri.getDfcPort(), dfcId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal() throws Exception {
        logger.info((Object)String.format("Dispatching search execution: sid: %s, dfs id: %s", this.dfsSid, this.dfcId));
        if (this.dfsResourceManager.getResourceInfo(this.dfcId, this.executionType) == null) {
            logger.info((Object)String.format("DFC id not yet registered: %s", this.dfcId));
            DFSResourceManager dFSResourceManager = this.dfsResourceManager;
            synchronized (dFSResourceManager) {
                if (this.dfsResourceManager.numDfcs() >= this.coordinatorNumSlots) {
                    String errMsg = "Cannot start any more DFCs, since number of active data fabric searches have exceeded limit for search head. limit=" + this.coordinatorNumSlots;
                    DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, errMsg);
                    return;
                }
                try {
                    int activeDataFabricAppls = ComputeEngineClusterManagerFactory.getInstance().getActiveDataFabricApps(sparkMasterWebUrl, sparkMasterConnectTimeout);
                    if (this.executorNumSlotsEnabled && activeDataFabricAppls >= this.executorNumSlots) {
                        String errMsg = "Cannot start any more DFCs, since number of active data fabric searches have exceeded maximum number for cluster (or) searchhead. limit=" + this.executorNumSlots;
                        DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, errMsg);
                        return;
                    }
                }
                catch (Throwable t) {
                    DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, String.format("Error Communicating with DFM : %s ", t.getMessage()));
                }
            }
        }
        while (true) {
            DFSResourceManager.DFSResourceInfo dri;
            if ((dri = this.dfsResourceManager.getResourceInfo(this.dfcId, this.executionType)) != null && dri.getState().equals(DFSSearchCoordinatorState.RUNNING)) {
                DFSearchDispatcher.sendDfcInfoToSplunkd(this.writeToSplunk, dri, this.dfsSid);
                logger.info((Object)String.format("DFC running and ready to receive search request from splunkd: sid: %s", this.dfsSid));
                return;
            }
            DFSResourceManager t = this.dfsResourceManager;
            synchronized (t) {
                dri = this.dfsResourceManager.getResourceInfo(this.dfcId, this.executionType);
                if (dri != null) {
                    continue;
                }
                dri = new DFSResourceManager.DFSResourceInfo(this.dfsSid, this.executionType, -1);
                this.dfsResourceManager.addDri(this.dfcId, this.executionType, dri);
                logger.info((Object)String.format("Added dfs id: %s to resource manager", this.dfcId));
            }
            try {
                DFSearchDispatcher.startDfc(this.dfcId, this.dfsMasterPort, this.dfsSid, dri, this.dfsResourceManager, this.executionType, this.coordinatorNumSlots, this.executorNumSlots, this.coordinatorControlPort, this.maxReducePartitionSize, this.workerReceivingDataPort, this.workerReceivingDataPortCount, this.splunkVersion, this.extraKryoClasses, this.splunkConf, this.searchHeadName);
                continue;
            }
            catch (Throwable t2) {
                DFSResourceManager dFSResourceManager = this.dfsResourceManager;
                synchronized (dFSResourceManager) {
                    this.dfsResourceManager.removeResourceInfo(this.dfcId, this.executionType);
                }
                logger.error((Object)String.format("Error starting dfc: %s", ExceptionUtils.getFullStackTrace((Throwable)t2)), t2);
                DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, "Error occurred while trying to start Data Fabric Coordinator. Refer to Data Fabric Master logs(SPLUNK_HOME/var/log/splunk/dfs.log) for details.");
                continue;
            }
            break;
        }
    }

    private static String getDfcTitle(String serverName, String dfsSid) {
        String AppName = "DATA_FABRIC_1.0.0_" + serverName + "_" + dfsSid;
        return AppName;
    }
}

