/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSMonitoringDFSearchExecutors;
import com.splunk.df.search.DFSearchRequestListerner;
import com.splunk.df.search.ShutdownType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class DFSMaster {
    static Logger logger = null;
    private final ScheduledExecutorService dfsScheduledExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    public void start(int port) {
        logger.info((Object)"Data Fabric Search (DFS) Version: 1.0.0");
        logger.info((Object)"Master Starting up");
        final DFSearchRequestListerner dfSearchRequestListerner = new DFSearchRequestListerner(this.dfsScheduledExecutorService, port);
        final ShutdownType shutdownTypeAll = ShutdownType.ALL;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info((Object)"Shutdown hook started running!");
                dfSearchRequestListerner.shutdownDFSSearchExecutors(shutdownTypeAll);
                logger.info((Object)"Shutdown hook finished running!");
            }
        });
        Thread listenerThread = new Thread((Runnable)dfSearchRequestListerner, "SearchRequestListener");
        listenerThread.start();
        this.dfsScheduledExecutorService.scheduleAtFixedRate(new DFSMonitoringDFSearchExecutors(), 0L, 1L, TimeUnit.SECONDS);
        try {
            listenerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dfsScheduledExecutorService.shutdown();
        while (!this.dfsScheduledExecutorService.isShutdown()) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void stop() {
        if (!this.dfsScheduledExecutorService.isShutdown()) {
            this.dfsScheduledExecutorService.shutdown();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            logger.error((Object)"Usage: DFSMaster port");
            System.exit(1);
        }
        DFSMaster master = new DFSMaster();
        master.start(Integer.valueOf(args[0]));
        master.stop();
    }

    static {
        Path logCfg = Paths.get(System.getenv("SPLUNK_HOME"), "etc", "log-dfs.cfg");
        System.setProperty("SPLUNK_HOME", System.getenv("SPLUNK_HOME"));
        PropertyConfigurator.configure((String)logCfg.toString());
        logger = Logger.getLogger(DFSMaster.class);
    }
}

