/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.security.DFSSecurityConstants;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.DFSException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;

public class DFCLauncherEmbedded
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFCLauncherEmbedded.class);
    static final String splunkHome = System.getenv("SPLUNK_HOME");
    static String sparkHome = System.getProperty("SPARK_HOME");
    private SparkAppHandle dfcHandle;
    private SparkLauncher launcher;

    public DFCLauncherEmbedded(int dfcCoresPerExecutor, int dfcNumExecutors, int dfcExecutorMemMbs, int dfcDriverMemMbs, int dfcDriverCores, String computeMasterUrl, String dfcMainClass, String dfsJar, DFCParams dfcParams, final Runnable onFailure) {
        String master = computeMasterUrl;
        if (dfcCoresPerExecutor < 1) {
            throw new RuntimeException(String.format("Invalid cores per executor: %d", dfcCoresPerExecutor));
        }
        if (sparkHome == null) {
            sparkHome = System.getenv("SPARK_HOME");
        }
        if (sparkHome == null) {
            throw new RuntimeException(String.format("SPARK_HOME is not set, pls check server.conf", new Object[0]));
        }
        String executorLogDir = Paths.get("..", "..", dfcParams.getSid()).toString();
        String driverLogDir = Paths.get(System.getenv("SPLUNK_HOME"), "var", "run", "splunk", "dispatch", dfcParams.getSid()).toString();
        if (!new File(sparkHome).exists()) {
            throw new DFSException(logger, "SPARK_HOME is set incorrectly - " + sparkHome);
        }
        int executorStartMemMbs = (int)((double)dfcExecutorMemMbs * 0.75);
        logger.info((Object)String.format("executor start mem size in mbs: %d", executorStartMemMbs));
        logger.info((Object)("Using SPARK_HOME=" + sparkHome));
        try {
            String fileName = dfcParams.getSid() + "_dfc_args.txt";
            String filePath = Paths.get(splunkHome, "var", "run", "splunk", "dispatch", dfcParams.getSid(), fileName).toString();
            File argsFile = new File(filePath);
            argsFile.createNewFile();
            PrintWriter pw = new PrintWriter(argsFile);
            pw.println(dfcParams.toJson());
            pw.close();
            this.launcher = new SparkLauncher().setMainClass(dfcMainClass).setSparkHome(sparkHome).setMaster(master).setConf("spark.cores.max", String.valueOf(dfcCoresPerExecutor * dfcNumExecutors)).setConf("spark.executor.cores", String.valueOf(dfcCoresPerExecutor)).setConf("spark.executor.memory", String.format("%dm", dfcExecutorMemMbs)).setConf("spark.driver.memory", String.format("%dm", dfcDriverMemMbs)).setConf("spark.driver.userClassPathFirst", String.valueOf(true)).setConf("spark.driver.cores", String.valueOf(dfcDriverCores)).setConf("spark.driver.extraJavaOptions", String.format("-XX:+CMSClassUnloadingEnabled -D%s=%s", "DISPATCH_DIR", driverLogDir)).setConf("spark.executor.extraJavaOptions", String.format("-Xms%dm -D%s=%s", executorStartMemMbs, "DISPATCH_DIR", executorLogDir)).setConf("spark.executorEnv.DFS_SEARCH_LOG_CONFIG_ENABLED", String.valueOf(true)).setVerbose(false).addAppArgs(new String[]{filePath});
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error launching DFC: %s", e.getMessage()), (Throwable)e);
            throw new DFSException(String.format("Could not launch DFC: %s", e.getMessage()));
        }
        this.launcher.addFile(Paths.get(System.getenv("SPLUNK_HOME"), "etc", "log-dfs-search.cfg").toString());
        SSLConfig sslConfig = SSLConfig.getInstance();
        if (sslConfig.isTlsEnabled() && !sslConfig.isUseSparkSecurityConfigs() && !sslConfig.isUseNodeSpecificCertificates()) {
            if (sslConfig.isOverrideDefaultCertificate()) {
                if (sslConfig.getDFSKeystorePath() == null) {
                    logger.error((Object)"DFS keystore needs to be configured properly");
                    throw new DFSException("Invalid DFS keystore path");
                }
                File ksFile = new File(sslConfig.getDFSKeystorePath());
                if (!ksFile.exists() || !ksFile.isFile()) {
                    logger.error((Object)"DFS keystore needs to be configured properly");
                    throw new DFSException("Invalid DFS keystore path");
                }
                if (sslConfig.getDFSTruststorePath() == null) {
                    logger.error((Object)"DFS truststore needs to be configured properly");
                    throw new DFSException("Invalid DFS truststore path");
                }
                File tsFile = new File(sslConfig.getDFSTruststorePath());
                if (!tsFile.exists() || !tsFile.isFile()) {
                    logger.error((Object)"DFS truststore needs to be configured properly");
                    throw new DFSException("Invalid DFS truststore path");
                }
                this.launcher.addFile(sslConfig.getDFSKeystorePath());
                this.launcher.addFile(sslConfig.getDFSTruststorePath());
            } else {
                this.launcher.addFile(DFSSecurityConstants.DEFAULT_KEYSTORE_PATH);
                this.launcher.addFile(DFSSecurityConstants.DEFAULT_TRUSTSTORE_PATH);
            }
        }
        logger.info((Object)String.format("DFC instance started: cores per executor: %d, executor memory mbs: %s, driver memory mbs: %s, driver cores: %d, total executor cores: %d, num executors: %d", dfcCoresPerExecutor, dfcExecutorMemMbs, dfcDriverMemMbs, dfcDriverCores, dfcCoresPerExecutor, dfcNumExecutors));
        try {
            logger.debug((Object)"Get the main app resource and all the jar files to be submitted with the application.");
            this.setupLauncherJars(splunkHome);
            this.dfcHandle = this.launcher.startApplication(new SparkAppHandle.Listener[]{new SparkAppHandle.Listener(){

                public void infoChanged(SparkAppHandle hdl) {
                    logger.info((Object)String.format("DFC launch info changed: %s", hdl.toString()));
                }

                public void stateChanged(SparkAppHandle hdl) {
                    SparkAppHandle.State state = hdl.getState();
                    logger.info((Object)String.format("DFC launch state changed: %s", state.name()));
                    if (state.equals((Object)SparkAppHandle.State.KILLED) || state.equals((Object)SparkAppHandle.State.FAILED)) {
                        logger.error((Object)String.format("DFC could not be started, state reported: %s", state.toString()));
                        onFailure.run();
                    }
                }
            }});
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error launching dfc instance: %s", t.getMessage()));
            throw new RuntimeException(t);
        }
    }

    public void finalize() {
        try {
            if (this.dfcHandle != null) {
                this.dfcHandle.kill();
                logger.error((Object)String.format("Killed DFC process since DFC launcher is getting garbage collected, launcher: %s", this.launcher));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setupLauncherJars(String splunkHome) throws IOException {
        try {
            Stream<String> stream = Files.lines(Paths.get(splunkHome, "bin", "jars", "dfs_packages.list"));
            stream.forEach(p -> {
                Path path = Paths.get(splunkHome, p);
                if (Files.isRegularFile(path, new LinkOption[0]) && p.endsWith("jar")) {
                    this.addWhiteListedJars(path);
                }
            });
            stream.close();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Error while loading jars from dfs_packages.list: %s", e.getMessage()));
            throw e;
        }
    }

    private void addWhiteListedJars(Path filePath) {
        String[] whiteListedPatterns = new String[]{"^bcpkix-jdk15on(.*)", "^bcprov-jdk15on(.*)", "^commons-ast(.*)", "^commons-csv(.*)", "^splunk(.*)", "^t-digest(.*)", "^json-20180130(.*)", "antlr4-runtime-4.7.jar", "antlr-runtime-3.4.jar", "antlr-2.7.7.jar", "^guava-(.*)"};
        String filename = filePath.getFileName().toString();
        if (filename.startsWith("dfs")) {
            this.launcher.setAppResource(filePath.toString());
            logger.info((Object)String.format("DFC app resource to be used: %s", filename));
            return;
        }
        for (String pattern : whiteListedPatterns) {
            if (!Pattern.matches(pattern, filename)) continue;
            this.launcher.addJar(filePath.toString());
            logger.debug((Object)("Included jar: " + filename));
            return;
        }
        logger.debug((Object)String.format("[skip] filename: %s", filename));
    }
}

