/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.util.ConfU;
import com.splunk.roll.util.OutputUtil;
import com.splunk.util.MapUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class ThrottledIO {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final long NO_LIMIT = 0L;
    private static final int BUCKET_FILLS_PER_SECOND = 100;
    public long chunk_size = 0xA00000L;
    private static final Logger gLogger = Logger.getLogger(ThrottledIO.class);
    private final Throttler throttler;
    private volatile boolean started = false;

    public ThrottledIO(Throttler throttler) {
        this.throttler = throttler;
        if (throttler instanceof SemaphoreThrottler) {
            SemaphoreThrottler semaphoreThrottler = (SemaphoreThrottler)throttler;
            this.chunk_size = Math.min((long)semaphoreThrottler.getCapacityPerSecond(), this.chunk_size);
        }
    }

    public void requestBytes(int bytes) throws InterruptedException {
        int acquired;
        for (int bytesLeft = bytes; bytesLeft > 0; bytesLeft -= acquired) {
            acquired = this.throttler.requestBytes(bytesLeft);
        }
    }

    public long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        long count = 0L;
        try {
            int bytesRead;
            long nextLoggingGoal = this.chunk_size;
            while (-1 != (bytesRead = in.read(buf))) {
                this.requestBytes(bytesRead);
                out.write(buf, 0, bytesRead);
                if (nextLoggingGoal > (count += (long)bytesRead)) continue;
                OutputUtil.writeMap(gLogger, "Copying stream with governed bandwidth. ", MapUtil.asMap("bytes_written", Long.toString(count)), true);
                nextLoggingGoal += this.chunk_size;
            }
            return count;
        }
        catch (InterruptedException e) {
            throw ThrottledIO.wrappedInterrupt(e);
        }
    }

    public int available() {
        return this.throttler.available();
    }

    public synchronized ThrottledIO start() {
        if (this.started) {
            throw new IllegalStateException("ThrottledIO should not be started more than once");
        }
        this.started = true;
        this.throttler.start();
        return this;
    }

    public void stop() {
        this.throttler.stop();
    }

    static ThrottledIO noLimits() {
        return new ThrottledIO(new Throttler(){

            @Override
            public int requestBytes(int bytes) throws InterruptedException {
                return bytes;
            }

            @Override
            public void start() {
            }

            @Override
            public void stop() {
            }

            @Override
            public int available() {
                return Integer.MAX_VALUE;
            }
        });
    }

    public static IOException wrappedInterrupt(InterruptedException e) {
        return new IOException("Interrupted while transfering", e);
    }

    static ThrottledIO withLimit(ThrottleLimit limit) {
        return new ThrottledIO(new SemaphoreThrottler(limit));
    }

    public static ThrottledIO create(Configuration conf) {
        long bitsPerSecond = ConfU.getRollThrottleTransferRate(conf);
        long bytesPerSecond = bitsPerSecond / 8L;
        if (bytesPerSecond == 0L) {
            return ThrottledIO.noLimits();
        }
        return ThrottledIO.withLimit(new ThrottleLimit(bytesPerSecond, 1L, TimeUnit.SECONDS));
    }

    public static class SemaphoreThrottler
    implements Throttler {
        private final AtomicBoolean shouldReleaseBytes = new AtomicBoolean(true);
        private final Semaphore availableBytes;
        private final int capacityPerSecond;

        public SemaphoreThrottler(ThrottleLimit limit) {
            this.capacityPerSecond = limit.getBytesPerMillisecond() * 1000;
            this.availableBytes = new Semaphore(this.capacityPerSecond, true);
        }

        @Override
        public int requestBytes(int bytes) throws InterruptedException {
            int request = Math.min(this.capacityPerSecond, bytes);
            this.availableBytes.acquire(request);
            return request;
        }

        @Override
        public int available() {
            return this.availableBytes.availablePermits();
        }

        @Override
        public void start() {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SemaphoreThrottler.this.shouldReleaseBytes.get()) {
                        try {
                            Thread.sleep(10L);
                            SemaphoreThrottler.this.releaseBytes();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }

        private void releaseBytes() {
            this.availableBytes.release(Math.min(this.capacityPerSecond / 100, this.capacityPerSecond - this.availableBytes.availablePermits()));
        }

        @Override
        public void stop() {
            this.shouldReleaseBytes.set(false);
        }

        public int getCapacityPerSecond() {
            return this.capacityPerSecond;
        }
    }

    public static class ThrottleLimit {
        private final int bytesPerMillisecond;

        public ThrottleLimit(long bytes, long time, TimeUnit unit) {
            this.bytesPerMillisecond = (int)(bytes / time / TimeUnit.MILLISECONDS.convert(1L, unit));
        }

        public int getBytesPerMillisecond() {
            return this.bytesPerMillisecond;
        }
    }

    public static interface Throttler {
        public int requestBytes(int var1) throws InterruptedException;

        public int available();

        public void start();

        public void stop();
    }
}

