/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.mr.SplunkMR;
import com.splunk.roll.util.ConfU;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class RollerCli {
    public static final String BUCKETDIRS_OPTION = "-d";
    public static final String COPYTIME_OPTION = "-ct";
    public static final String SERVERID_OPTION = "-sid";
    public static final String LOCALHOME_OPTION = "-lh";
    public static final String REMOTEHOME_OPTION = "-rh";
    public static final String NAMENODE_OPTION = "-nn";
    public static final String INDEX_OPTION = "-i";
    static final String DEFAULT_HUNKROLL_LOCAL_TEMP_PATH_RELATIVE_SPLUNK = "var" + File.separator + "run" + File.separator + "hunk" + File.separator + "roll";
    static final String DEFAULT_HUNKROLL_LOCAL_TEMP_PATH = "$SPLUNK_HOME" + File.separator + DEFAULT_HUNKROLL_LOCAL_TEMP_PATH_RELATIVE_SPLUNK;
    public static Options options = new Options();
    private final Map<String, String> defined;
    private final Map<String, String> extras;

    private static String noDash(String optionName) {
        return optionName.replaceFirst("-", "");
    }

    public RollerCli(Map<String, String> definedOptions, Map<String, String> extras) {
        this.defined = definedOptions;
        this.extras = extras;
    }

    public long getCopyTime() {
        return Long.parseLong(this.defined.get(COPYTIME_OPTION));
    }

    public File getLocalHome() {
        if (this.defined.containsKey(LOCALHOME_OPTION)) {
            return new File(this.defined.get(LOCALHOME_OPTION));
        }
        String splunkHome = System.getenv("SPLUNK_HOME");
        if (splunkHome != null) {
            return new File(splunkHome, DEFAULT_HUNKROLL_LOCAL_TEMP_PATH_RELATIVE_SPLUNK);
        }
        throw new RuntimeException("Could not set local hunkroll home. SPLUNK_HOME was not set and option: -lh was not set.");
    }

    public Path getRemoteHome() {
        return new Path(this.defined.get(REMOTEHOME_OPTION));
    }

    public URI getNameNode() {
        return URI.create(this.defined.get(NAMENODE_OPTION));
    }

    public String getServerId() {
        return this.defined.get(SERVERID_OPTION);
    }

    public String getIndex() {
        return this.defined.get(INDEX_OPTION);
    }

    public List<String> getBucketDirs() {
        ArrayList<String> dirs = new ArrayList<String>();
        String value = this.defined.get(BUCKETDIRS_OPTION);
        for (String dir : value.split(",")) {
            dirs.add(dir.trim());
        }
        return dirs;
    }

    public Configuration getConf() {
        Configuration conf = new Configuration();
        ConfU.setRollRemoteHome(conf, this.getRemoteHome());
        ConfU.setRollLocalHome(conf, this.getLocalHome());
        ConfU.setRollIndex(conf, this.getIndex());
        ConfU.setRollOlderThanTime(conf, this.getCopyTime(), TimeUnit.SECONDS);
        ConfU.setSplunkServerUUID(conf, this.getServerId());
        ConfU.setFileSystemUri(conf, this.getNameNode());
        ConfU.setBucketDirs(conf, this.getBucketDirs());
        for (Map.Entry<String, String> e : this.getRawExtra().entrySet()) {
            conf.set(e.getKey(), e.getValue());
        }
        return conf;
    }

    public Map<String, String> getRawExtra() {
        return this.extras;
    }

    public static RollerCli create(String ... args) throws ParseException {
        Map<String, String> keyValues = RollerCli.getKeyValues(args);
        Map<String, String> defined = RollerCli.getDefinedOptions(keyValues);
        keyValues.keySet().removeAll(defined.keySet());
        return new RollerCli(defined, keyValues);
    }

    private static Map<String, String> getKeyValues(String ... args) {
        if (args.length % 2 != 0) {
            throw new RuntimeException("Argument list must contain an even number of arguments. Keys and values.");
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            keyValues.put(args[i], args[i + 1]);
        }
        return keyValues;
    }

    private static Map<String, String> getDefinedOptions(Map<String, String> keyValues) throws ParseException {
        HashMap<String, String> defined = new HashMap<String, String>();
        ArrayList<Option> missingRequiredOptions = new ArrayList<Option>();
        for (Object o : options.getOptions()) {
            String longOptionName;
            Option option = (Option)o;
            String optionName = "-" + option.getOpt();
            String optionValue = RollerCli.getOptionValue(keyValues, optionName, longOptionName = "--" + option.getLongOpt());
            if (optionValue != null) {
                defined.put(optionName, optionValue);
                continue;
            }
            if (!option.isRequired()) continue;
            missingRequiredOptions.add(option);
        }
        if (!missingRequiredOptions.isEmpty()) {
            RollerCli.throwMissingOptionException(missingRequiredOptions);
        }
        return defined;
    }

    private static String getOptionValue(Map<String, String> kvs, String opt, String longOpt) {
        String optionValue = RollerCli.doGetOptionValue(kvs, opt, longOpt);
        if (optionValue == null) {
            if (opt.equals(NAMENODE_OPTION)) {
                if (kvs.containsKey("fs.default.name")) {
                    return kvs.get("fs.default.name");
                }
            } else if (opt.equals(REMOTEHOME_OPTION) && kvs.containsKey(SplunkMR.CONF_HDFS_HOME)) {
                return ConfU.getRemoteHomeFromHdfsHome(kvs.get(SplunkMR.CONF_HDFS_HOME));
            }
        }
        return optionValue;
    }

    private static String doGetOptionValue(Map<String, String> kvs, String opt, String longOpt) {
        if (kvs.containsKey(opt)) {
            return kvs.get(opt);
        }
        if (kvs.containsKey(longOpt)) {
            return kvs.get(longOpt);
        }
        return null;
    }

    private static void throwMissingOptionException(List<Option> options) throws MissingOptionException {
        ArrayList<String> optionNames = new ArrayList<String>();
        for (Option o : options) {
            optionNames.add("--" + o.getLongOpt());
        }
        throw new MissingOptionException(optionNames);
    }

    static {
        OptionBuilder.withArgName((String)"uri");
        OptionBuilder.withLongOpt((String)"namenode-uri");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"URI to the remote file system where the bucket will be copied. Example: hdfs://namenode.domain.com:port");
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(NAMENODE_OPTION)));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withLongOpt((String)"remote-home-path");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Remote base path used to store temporary data and copied buckets. Example: /hdfsroot/test/hunk/buckets");
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(REMOTEHOME_OPTION)));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withLongOpt((String)"local-home-path");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)("Local temporary directory where we can store temporary data. Default: " + DEFAULT_HUNKROLL_LOCAL_TEMP_PATH));
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(LOCALHOME_OPTION)));
        OptionBuilder.withArgName((String)"id");
        OptionBuilder.withLongOpt((String)"server-id");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"ID that is unique for the Splunk server that created the bucket. It could be the servername, hostname or the servers UUID");
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(SERVERID_OPTION)));
        OptionBuilder.withArgName((String)"unixtime");
        OptionBuilder.withLongOpt((String)"copy-time");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Time in seconds for which to copy buckets from. All found buckets with a latest time later than this time will be copied. Example for 2014-06-23: 1403481600");
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(COPYTIME_OPTION)));
        OptionBuilder.withArgName((String)"index");
        OptionBuilder.withLongOpt((String)"index");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Splunk index the buckets belong to.");
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(INDEX_OPTION)));
        OptionBuilder.withArgName((String)"list");
        OptionBuilder.withLongOpt((String)"bucket-dirs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"List of directories that contain buckets. Example: \"/path/to/dir/one,/path/to/dir/two\"");
        options.addOption(OptionBuilder.create((String)RollerCli.noDash(BUCKETDIRS_OPTION)));
    }
}

