/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.FileSplitGenerator;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.ParquetInputFormat;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class ParquetSplitGenerator
extends FileSplitGenerator {
    private static Logger gLogger = Logger.getLogger(ParquetSplitGenerator.class);
    private ObjectMapper mapper = new ObjectMapper();

    public ParquetSplitGenerator() {
    }

    public ParquetSplitGenerator(boolean dmaSplit) {
        this.dmaSplit = dmaSplit;
    }

    @Override
    protected boolean sendSplitToAcceptor(ObjectAcceptor<VixInputSplit> acceptor, VixInputSplit split) throws IOException {
        split.setInputFormatClass(ParquetInputFormat.class);
        split.setDmaSplit(this.dmaSplit);
        if (split.isDmaSplit()) {
            this.modifyRequiredFieldsForDMASplit();
        }
        boolean simplifyResult = StrUtil.parseBoolean(this.getConfVar(split.getInputId(), "simplifyresult", null), true);
        split.putExtra("simplifyresult", Boolean.toString(simplifyResult));
        split.putExtra(SplunkMR.CONF_REQUIRED_FIELDS, this.mapper.writeValueAsString(this._requiredFields.getWildcardList()));
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Setting split with Id:: " + split.getSplitId() + " dma flag to " + this.dmaSplit));
        }
        return acceptor.accept(split);
    }

    @Override
    public String getName() {
        return "parquet";
    }
}

