/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.mr.SplunkMR;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.log4j.Logger;

public class ClusterInfo {
    private static Logger gLogger = Logger.getLogger(ClusterInfo.class);
    protected int taskTrackers;
    protected int mapTasks;
    protected int maxMapTasks;
    protected int reduceTasks;
    protected int maxReduceTasks;
    protected ClusterStatus cs;

    protected ClusterInfo(Configuration conf) throws IOException {
        JobClient jc = SplunkMR.getJobClient(conf);
        this.cs = jc.getClusterStatus(true);
        this.taskTrackers = this.cs.getTaskTrackers();
        this.mapTasks = this.cs.getMapTasks();
        this.maxMapTasks = this.cs.getMaxMapTasks();
        this.reduceTasks = this.cs.getReduceTasks();
        this.maxReduceTasks = this.cs.getMaxReduceTasks();
    }

    public static ClusterInfo getInstance(Configuration conf) throws IOException {
        return new ClusterInfo(conf);
    }

    public int getTaskTrackers() {
        return this.taskTrackers;
    }

    public void setTaskTrackers(int taskTrackers) {
        this.taskTrackers = taskTrackers;
    }

    public int getMapTasks() {
        return this.mapTasks;
    }

    public void setMapTasks(int mapTasks) {
        this.mapTasks = mapTasks;
    }

    public int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    public void setMaxMapTasks(int maxMapTasks) {
        this.maxMapTasks = maxMapTasks;
    }

    public int getReduceTasks() {
        return this.reduceTasks;
    }

    public void setReduceTasks(int reduceTasks) {
        this.reduceTasks = reduceTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    public void setMaxReduceTasks(int maxReduceTasks) {
        this.maxReduceTasks = maxReduceTasks;
    }
}

