/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.datasets.BaseDataset;
import com.splunk.commons.datasets.IField;
import com.splunk.commons.datasets.Properties;
import java.util.List;
import org.bson.types.ObjectId;
import org.json.JSONObject;

public class SavedSearchDataset
extends BaseDataset {
    public SavedSearchDataset(ObjectId id, String module, String name, String owner, Properties properties) {
        this(id, module, name, owner, properties, null);
    }

    public SavedSearchDataset(ObjectId id, String module, String name, String owner, Properties properties, List<IField> fields) {
        super(id, module, name, "savedsearch", owner, properties, fields);
        if (!this.validateProperties()) {
            throw new IllegalArgumentException("SavedSearch dataset needs to have a search query defined");
        }
    }

    private SavedSearchDataset(JSONObject jsonObject) {
        super(jsonObject);
        if (!this.validateProperties()) {
            throw new IllegalArgumentException("SavedSearch dataset needs to have a search query defined");
        }
    }

    public static SavedSearchDataset load(JSONObject jsonObject) {
        return new SavedSearchDataset(jsonObject);
    }

    @Override
    public boolean validateProperties() {
        return this.getSearchString() != null;
    }

    private String getSearchString() {
        return this.getProperties().getProperty("search").getString().get();
    }
}

