/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;

public class PercentageAggregateNode
extends AggregateNode {
    private final int percentage;
    private final boolean asFieldDefaulted;

    public PercentageAggregateNode(AggregateFunction function, FieldNode field, FieldNode asField, int percentage) {
        super(function, field, asField != null ? asField : PercentageAggregateNode.createDefaultAsField(function, field, percentage), null, null);
        this.asFieldDefaulted = this.asField.equals(PercentageAggregateNode.createDefaultAsField(function, field, percentage));
        if (percentage < 1 || percentage > 99) {
            throw new IllegalArgumentException("Invalid percentile number: " + percentage);
        }
        this.percentage = percentage;
        PercentageAggregateNode.assertFunctionIsValid(function);
    }

    public PercentageAggregateNode(AggregateFunction function, FieldNode field, int percentage) {
        this(function, field, (FieldNode)null, percentage);
    }

    public PercentageAggregateNode(AggregateFunction function, FieldNode field, String asName, int percentage) {
        this(function, field, new FieldNode(asName), percentage);
    }

    public static FieldNode createDefaultAsField(AggregateFunction function, FieldNode field, int percentage) {
        String asFieldName = String.format("%1$s%2$d(%3$s)", function.toString(), percentage, field.toString());
        return new FieldNode(asFieldName);
    }

    public static String createDefaultName(AggregateFunction function, FieldNode field, int percentage) {
        return PercentageAggregateNode.createDefaultAsField(function, field, percentage).getFieldName();
    }

    @Override
    public FieldNode getDefaultAsField() {
        return PercentageAggregateNode.createDefaultAsField(this.function, this.field, this.percentage);
    }

    @Override
    public String getDefaultName() {
        FieldNode defaultField = this.asFieldDefaulted ? this.asField : this.getDefaultAsField();
        return defaultField.getFieldName();
    }

    private static void assertFunctionIsValid(AggregateFunction function) {
        assert (function.equals((Object)AggregateFunction.PERC_X) || function.equals((Object)AggregateFunction.EXACTPERC_X) || function.equals((Object)AggregateFunction.UPPERPERC_X));
    }

    public int getPercentage() {
        return this.percentage;
    }

    @Override
    public boolean hasDefaultAsName() {
        return this.asFieldDefaulted;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

