/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.Predicate;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchInNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchPhraseNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchTermNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import java.util.List;

public final class Search {
    private Search() {
    }

    public static SearchTermNode term(String value) {
        return new SearchTermNode(value, false, false, SearchModifier.NONE);
    }

    public static SearchPhraseNode phrase(String value) {
        return new SearchPhraseNode(value, false, true, SearchModifier.NONE);
    }

    public static SearchComparisonNode equalEqual(String fieldName, String value) {
        return new SearchComparisonNode(Operator.EQUAL_EQUAL, Expression.field(fieldName), Expression.string(value));
    }

    public static SearchComparisonNode equalEqual(FieldNode field, TypeNode value) {
        return new SearchComparisonNode(Operator.EQUAL_EQUAL, field, value);
    }

    public static SearchComparisonNode equal(String fieldName, String value) {
        return new SearchComparisonNode(Operator.EQUAL, Expression.field(fieldName), Expression.string(value));
    }

    public static SearchComparisonNode equal(FieldNode field, TypeNode value) {
        return new SearchComparisonNode(Operator.EQUAL, field, value);
    }

    public static SearchComparisonNode notEqual(String fieldName, String value) {
        return new SearchComparisonNode(Operator.NOT_EQUAL, new FieldNode(fieldName), new StringNode(value));
    }

    public static SearchComparisonNode notEqual(FieldNode field, TypeNode value) {
        return new SearchComparisonNode(Operator.NOT_EQUAL, field, value);
    }

    public static SearchComparisonNode greaterThan(String fieldName, String value) {
        return new SearchComparisonNode(Operator.GREATER_THAN, new FieldNode(fieldName), new StringNode(value));
    }

    public static SearchComparisonNode greaterThanOrEqual(String fieldName, String value) {
        return new SearchComparisonNode(Operator.GREATER_THAN_OR_EQUAL, new FieldNode(fieldName), new StringNode(value));
    }

    public static SearchComparisonNode lessThan(String fieldName, String value) {
        return new SearchComparisonNode(Operator.LESS_THAN, new FieldNode(fieldName), new StringNode(value));
    }

    public static SearchComparisonNode lessThanNumeric(String fieldName, Number value) {
        return new SearchComparisonNode(Operator.LESS_THAN, Expression.field(fieldName), Expression.number(value));
    }

    public static SearchComparisonNode lessThanOrEqual(String fieldName, String value) {
        return new SearchComparisonNode(Operator.LESS_THAN_OR_EQUAL, new FieldNode(fieldName), new StringNode(value));
    }

    public static SearchAndNode and(SearchNode lhs) {
        return new SearchAndNode(lhs);
    }

    public static SearchAndNode and(SearchNode lhs, SearchNode rhs) {
        return new SearchAndNode(lhs, rhs);
    }

    public static SearchAndNode and(List<ISearchPredicate> args) {
        return new SearchAndNode(args);
    }

    public static SearchAndNode and(ISearchPredicate lhs, ISearchPredicate rhs) {
        return new SearchAndNode(lhs, rhs);
    }

    public static SearchAndNode and(IPredicate lhs, IPredicate rhs) {
        return Search.and(Predicate.search(lhs), Predicate.search(rhs));
    }

    public static SearchOrNode or(SearchNode lhs, SearchNode rhs) {
        return new SearchOrNode(lhs, rhs);
    }

    public static SearchOrNode or(List<ISearchPredicate> args) {
        return new SearchOrNode(args);
    }

    public static SearchOrNode or(ISearchPredicate lhs, ISearchPredicate rhs) {
        return new SearchOrNode(lhs, rhs);
    }

    public static SearchOrNode or(IPredicate lhs, IPredicate rhs) {
        return Search.or(Predicate.search(lhs), Predicate.search(rhs));
    }

    public static SearchXorNode xor(SearchNode lhs, SearchNode rhs) {
        return new SearchXorNode(lhs, rhs);
    }

    public static SearchXorNode xor(List<ISearchPredicate> args) {
        return new SearchXorNode(args);
    }

    public static SearchXorNode xor(ISearchPredicate lhs, ISearchPredicate rhs) {
        return new SearchXorNode(lhs, rhs);
    }

    public static SearchXorNode xor(IPredicate lhs, IPredicate rhs) {
        return Search.xor(Predicate.search(lhs), Predicate.search(rhs));
    }

    public static SearchSubSearchPredicateNode subsearch(CommandNode search) {
        return new SearchSubSearchPredicateNode(search);
    }

    public static SearchInNode in(FieldNode field, TypeNode[] rhs) {
        return new SearchInNode(field, rhs);
    }
}

