/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FitCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class CommandFitVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private final ExpressionVisitor expVisitor = new ExpressionVisitor();

    @Override
    public Node visitFitParse(SplunkCommandParser.FitParseContext ctx) {
        SplunkCommandParser.OutputfieldContext outfieldcontext;
        StringNode algorithm = (StringNode)this.visit((ParseTree)ctx.algorithm());
        FieldNode targetfield = (FieldNode)this.visit((ParseTree)ctx.targetfield());
        FieldNode[] featuredfields = null;
        StringNode modelname = null;
        FieldNode outputfield = null;
        SplunkCommandParser.ModelNameContext namecontext = ctx.modelName();
        if (namecontext != null) {
            modelname = (StringNode)this.visit((ParseTree)namecontext);
        }
        if ((outfieldcontext = ctx.outputfield()) != null) {
            outputfield = (FieldNode)this.visit((ParseTree)outfieldcontext);
        }
        ArrayList<ParamNode> paramNodes = new ArrayList<ParamNode>();
        for (SplunkCommandParser.ParamsContext childCtx : ctx.params()) {
            paramNodes.add((ParamNode)this.visit((ParseTree)childCtx));
        }
        ParamNode[] params = new ParamNode[paramNodes.size()];
        paramNodes.toArray(params);
        SplunkCommandParser.FeaturefieldsContext fieldListCtx = ctx.featurefields();
        if (fieldListCtx != null) {
            List<SplunkCommandParser.FieldContext> fieldCtx = fieldListCtx.field();
            featuredfields = new FieldNode[fieldCtx.size()];
            for (int i = 0; i < fieldCtx.size(); ++i) {
                featuredfields[i] = (FieldNode)this.expVisitor.visit((ParseTree)fieldCtx.get(i));
            }
        }
        return new FitCommand(new SearchCommand(), algorithm, targetfield, featuredfields, params, modelname, outputfield);
    }

    @Override
    public Node visitParams(SplunkCommandParser.ParamsContext ctx) {
        String value;
        String param;
        SplunkCommandParser.OptionnameContext optctx = ctx.optionname();
        SplunkCommandParser.OptionvalueContext valctx = ctx.optionvalue();
        if (optctx.ID() != null) {
            param = optctx.ID().getText();
        } else if (optctx.QSTRING() != null) {
            param = optctx.QSTRING().getText();
        } else {
            throw new IllegalArgumentException("Error parsing Option Name Context");
        }
        if (valctx.ID() != null) {
            value = valctx.ID().getText();
        } else if (valctx.INTEGER() != null) {
            value = valctx.INTEGER().getText();
        } else if (valctx.DECIMAL() != null) {
            value = valctx.DECIMAL().getText();
        } else if (valctx.QSTRING() != null) {
            value = valctx.QSTRING().getText();
        } else {
            throw new IllegalArgumentException("Error parsing Option Name Context");
        }
        return new ParamNode(param, value, false);
    }

    @Override
    public Node visitOutputfield(SplunkCommandParser.OutputfieldContext ctx) {
        return (Node)this.expVisitor.visit((ParseTree)ctx.field());
    }

    @Override
    public Node visitModelName(SplunkCommandParser.ModelNameContext ctx) {
        String regex;
        TerminalNode node = ctx.QSTRING();
        if (node == null) {
            return new Node();
        }
        String val = node.getText();
        if (!val.matches(regex = "^\"[a-zA-Z_][a-zA-Z0-9_]*\"$")) {
            throw new IllegalArgumentException("Model name Syntax is illegal!");
        }
        return new StringNode(val);
    }

    @Override
    public Node visitTargetfield(SplunkCommandParser.TargetfieldContext ctx) {
        return (Node)this.expVisitor.visit((ParseTree)ctx.field());
    }

    @Override
    public Node visitAlgorithm(SplunkCommandParser.AlgorithmContext ctx) {
        String regex;
        TerminalNode node = ctx.QSTRING();
        if (node == null) {
            throw new IllegalArgumentException("Algorithm name Syntax is illegal!");
        }
        String val = node.getText();
        if (!val.matches(regex = "^\"[a-zA-Z_][a-zA-Z0-9_]*\"$")) {
            throw new IllegalArgumentException("Algorithm name Syntax is illegal!");
        }
        return new StringNode(val);
    }
}

