/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinKey {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Object[] key;

    public MapJoinKey(Object[] key) {
        this.key = key;
    }

    public MapJoinKey() {
        this(EMPTY_OBJECT_ARRAY);
    }

    public Object[] getKey() {
        return this.key;
    }

    public boolean hasAnyNulls(boolean[] nullsafes) {
        if (this.key != null && this.key.length > 0) {
            for (int i = 0; i < this.key.length; ++i) {
                if (this.key[i] != null || nullsafes != null && nullsafes[i]) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapJoinKey other = (MapJoinKey)obj;
        return Arrays.equals(this.key, other.key);
    }

    public void read(MapJoinObjectSerDeContext context, ObjectInputStream in, Writable container) throws IOException, SerDeException {
        SerDe serde = context.getSerDe();
        container.readFields((DataInput)in);
        List value = (List)ObjectInspectorUtils.copyToStandardObject(serde.deserialize(container), serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.key = value == null ? EMPTY_OBJECT_ARRAY : value.toArray();
    }

    public void write(MapJoinObjectSerDeContext context, ObjectOutputStream out) throws IOException, SerDeException {
        SerDe serde = context.getSerDe();
        ObjectInspector objectInspector = context.getStandardOI();
        Writable container = serde.serialize(this.key, objectInspector);
        container.write((DataOutput)out);
    }
}

