/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import com.splunk.io.FastByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class StrUtil {
    public static Pattern ENV_VAR = Pattern.compile("(?i)\\$([a-z][a-z0-9_]*)");
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static byte[] string2Bytes(String s) {
        return s.getBytes(UTF8);
    }

    public static String expandEnvVars(String str) {
        return StrUtil.expandEnvVars(str, System.getenv());
    }

    public static String expandEnvVars(String str, Map<String, String> env) {
        String result = str;
        Matcher m = ENV_VAR.matcher(result);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            sb.setLength(0);
            sb.append(result, 0, m.start());
            String ev = env.get(m.group(1));
            if (ev != null) {
                sb.append(ev);
            }
            sb.append(result, m.end(), result.length());
            result = sb.toString();
            m = ENV_VAR.matcher(result);
        }
        return result;
    }

    public static String unescape(String s) {
        if (s == null || s.trim().length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i + 5 < s.length() && s.charAt(i + 1) == 'u') {
                String hexCode = s.substring(i + 2, i + 6);
                int codeUnit = Integer.parseInt(hexCode, 16);
                sb.append((char)codeUnit);
                i += 5;
                continue;
            }
            if (c == '\\' && i + 3 < s.length()) {
                char i1 = s.charAt(i + 1);
                char i2 = s.charAt(i + 2);
                char i3 = s.charAt(i + 3);
                if (i1 >= '0' && i1 <= '3' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    String octalCode = s.substring(i + 1, i + 4);
                    int codeUnit = Integer.parseInt(octalCode, 8);
                    sb.append((char)codeUnit);
                    i += 3;
                    continue;
                }
            }
            if (c == '\\' && i + 1 < s.length()) {
                char n = s.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    case 'f': {
                        sb.append("\f");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean parseBoolean(String v, boolean defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        if ((v = v.trim().toLowerCase()).length() == 1) {
            if (v.equals("1") || v.equals("t") || v.equals("y")) {
                return true;
            }
            if (v.equals("0") || v.equals("f") || v.equals("n")) {
                return false;
            }
        }
        if (v.equals("true") || v.equals("yes")) {
            return true;
        }
        if (v.equals("false") || v.equals("no")) {
            return false;
        }
        return defaultValue;
    }

    public static String readline(InputStream in, String charsetName) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(256);
        int b = in.read();
        while (b != -1 && b != 10) {
            ((ByteArrayOutputStream)baos).write(b);
            b = in.read();
        }
        return ((ByteArrayOutputStream)baos).toString(charsetName);
    }

    public static int readLine(InputStream in, OutputStream out) throws IOException {
        return StrUtil.readLine(in, out, '\"');
    }

    public static int readLine(InputStream in, OutputStream out, char quoteChar) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("OutputStream is null!");
        }
        int bytes = 0;
        int b = in.read();
        boolean quote = false;
        while (b != -1) {
            ++bytes;
            if (b == quoteChar) {
                quote = !quote;
            } else if (b == 10 && !quote) break;
            out.write(b);
            b = in.read();
        }
        return bytes;
    }

    public static char getEscapedSeqChar(char c) {
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
        }
        return c;
    }

    public static String[] parseCSVLine(String line, int fieldCountHint, char delimChar, char quoteChar, char escapeChar) {
        ArrayList<String> result = new ArrayList<String>(fieldCountHint);
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        boolean escaped = false;
        int fieldStart = 0;
        for (int i = 0; i < line.length(); ++i) {
            char nc;
            char c = line.charAt(i);
            char c2 = nc = i + 1 < line.length() ? line.charAt(i + 1) : (char)'\u0000';
            if (fieldStart == i) {
                if (c == quoteChar) {
                    quoted = true;
                    continue;
                }
                if (c == ' ' && delimChar != ' ') {
                    ++fieldStart;
                    continue;
                }
            }
            if (escaped) {
                if (escapeChar == '\\' && (c == 'n' || c == 'r' || c == 't')) {
                    sb.append(StrUtil.getEscapedSeqChar(c));
                    escaped = false;
                    continue;
                }
                if (c != quoteChar && c != escapeChar) {
                    if (quoted && quoteChar == escapeChar && c == delimChar) {
                        result.add(sb.toString());
                        sb.setLength(0);
                        quoted = false;
                        escaped = false;
                        fieldStart = i + 1;
                        continue;
                    }
                    sb.append(escapeChar);
                }
                sb.append(c);
                escaped = false;
                continue;
            }
            if (c == escapeChar) {
                escaped = true;
                continue;
            }
            if (c == '\\' && (nc == 'n' || nc == 'r' || nc == 't')) {
                sb.append(StrUtil.getEscapedSeqChar(nc));
                ++i;
                continue;
            }
            if (c == quoteChar) {
                if (quoted) {
                    if (nc != '\u0000' && nc != delimChar) {
                        sb.append(c);
                        continue;
                    }
                    quoted = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == delimChar) {
                if (quoted) {
                    sb.append(c);
                    continue;
                }
                result.add(sb.toString());
                sb.setLength(0);
                quoted = false;
                escaped = false;
                fieldStart = i + 1;
                continue;
            }
            sb.append(c);
        }
        result.add(sb.toString());
        return result.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCSVParse(String[] args) throws IOException {
        String line;
        BufferedReader in;
        char escape;
        char quote;
        char delim;
        block12: {
            String file = args[1];
            String dialect = args[2];
            InputStream is = System.in;
            delim = ',';
            quote = '\"';
            escape = '\\';
            if ("tsv".equals(dialect)) {
                delim = '\t';
                quote = '\"';
                escape = '\\';
            } else if ("excel".equals(dialect)) {
                delim = ',';
                quote = '\"';
                escape = '\"';
            } else if ("csv".equals(dialect)) {
                delim = ',';
                quote = '\"';
                escape = '\\';
            } else {
                throw new IOException("Unknown dialect=" + dialect);
            }
            if (!"-".equals(file)) {
                is = new FileInputStream(file);
            }
            in = null;
            in = new BufferedReader(new InputStreamReader(is));
            line = in.readLine();
            if (null != line) break block12;
            System.out.println("ERROR - Input was empty.");
            IOUtils.closeQuietly((Reader)in);
            return;
        }
        try {
            String[] header = StrUtil.parseCSVLine(line, 16, delim, quote, escape);
            System.out.println("delim='" + delim + "'");
            System.out.println("escape='" + escape + "'");
            System.out.println("quote='" + quote + "'");
            System.out.printf("header.length=%d\n", header.length);
            int lineNum = 0;
            line = in.readLine();
            while (line != null) {
                String[] data = StrUtil.parseCSVLine(line, header.length, delim, quote, escape);
                System.out.printf("data[%d].length=%d\n", ++lineNum, data.length);
                for (int i = 0; i < data.length && i < header.length; ++i) {
                    System.out.printf("%3d, %s=%s\n", i, header[i], data[i]);
                }
                System.out.println("---");
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
    }

    public static void main(String[] args) throws IOException {
        if ("csv".equals(args[0])) {
            StrUtil.testCSVParse(args);
        } else {
            System.err.println("Usage: java StrUtil csv [csv|tsv|excel] [ - | file] ");
            System.exit(1);
        }
    }

    public static boolean isAlphanumeric(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

