/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.log4j.Logger;

public class FileBasedCache {
    private static Logger gLogger = Logger.getLogger(FileBasedCache.class);
    File _baseDir;
    long _ttl;
    long _last_maint = 0L;
    String _ext;
    static final Pattern SAFE_FS_CHARS = Pattern.compile("^[a-zA-Z0-9\\-_.]+$");

    public FileBasedCache(File dir, String ext, long ttl_ms) {
        this._baseDir = dir;
        this._ttl = ttl_ms;
        this._baseDir.mkdirs();
        this._ext = ext;
        this.maintenance();
    }

    private File createTmpCacheFile(File dir, String fileName) throws IOException {
        int i = 0;
        dir.mkdirs();
        File f = null;
        while (!(f = new File(dir, fileName + "." + i++ + ".tmp")).createNewFile()) {
        }
        return f;
    }

    private String getCacheFilename(String key) {
        if (SAFE_FS_CHARS.matcher(key).matches()) {
            return key + this._ext;
        }
        return MD5Hash.digest((String)key) + this._ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String key, Serializable object) {
        boolean result;
        block7: {
            block6: {
                result = false;
                ObjectOutputStream out = null;
                File tmpFile = null;
                try {
                    String fileName = this.getCacheFilename(key);
                    tmpFile = this.createTmpCacheFile(this._baseDir, fileName);
                    out = new ObjectOutputStream(new FileOutputStream(tmpFile));
                    out.writeObject(object);
                    out.close();
                    result = tmpFile.renameTo(new File(this._baseDir, fileName));
                    IOUtils.closeQuietly((OutputStream)out);
                    if (tmpFile == null) break block6;
                    tmpFile.delete();
                }
                catch (IOException e) {
                    gLogger.warn((Object)("Failed to store object in cache, key=" + key), (Throwable)e);
                    break block7;
                }
                finally {
                    IOUtils.closeQuietly(out);
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    this.maintenance();
                }
            }
            this.maintenance();
        }
        return result;
    }

    private boolean isCacheExpired(File f) {
        return f.lastModified() < System.currentTimeMillis() - this._ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(String key) {
        Object object;
        File f = new File(this._baseDir, this.getCacheFilename(key));
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        if (this.isCacheExpired(f)) {
            f.delete();
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(f));
            object = in.readObject();
        }
        catch (Exception e) {
            try {
                gLogger.warn((Object)("Failed to read cluster description from cache. Deleting, file=" + f), (Throwable)e);
                f.delete();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return null;
        }
        IOUtils.closeQuietly((InputStream)in);
        return object;
    }

    private void maintenance() {
        try {
            if (this._last_maint < System.currentTimeMillis() - this._ttl) {
                for (File f : this._baseDir.listFiles()) {
                    if (!f.isFile() || !f.getName().endsWith(this._ext) || !this.isCacheExpired(f)) continue;
                    f.delete();
                }
                this._last_maint = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

