/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.spark_project.jetty.server.session.AbstractSession;
import org.spark_project.jetty.server.session.AbstractSessionManager;

public class MemSession
extends AbstractSession {
    private final Map<String, Object> _attributes = new HashMap<String, Object>();

    protected MemSession(AbstractSessionManager abstractSessionManager, HttpServletRequest request) {
        super(abstractSessionManager, request);
    }

    public MemSession(AbstractSessionManager abstractSessionManager, long created, long accessed, String clusterId) {
        super(abstractSessionManager, created, accessed, clusterId);
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this._attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAttributes() {
        MemSession memSession = this;
        synchronized (memSession) {
            this.checkValid();
            return this._attributes.size();
        }
    }

    @Override
    public Enumeration<String> doGetAttributeNames() {
        List<Object> names = this._attributes == null ? Collections.EMPTY_LIST : new ArrayList<String>(this._attributes.keySet());
        return Collections.enumeration(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getNames() {
        MemSession memSession = this;
        synchronized (memSession) {
            return new HashSet<String>(this._attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAttributes() {
        while (this._attributes != null && this._attributes.size() > 0) {
            ArrayList<String> keys2;
            MemSession memSession = this;
            synchronized (memSession) {
                keys2 = new ArrayList<String>(this._attributes.keySet());
            }
            for (String key : keys2) {
                Object value2;
                MemSession memSession2 = this;
                synchronized (memSession2) {
                    value2 = this.doPutOrRemove(key, null);
                }
                this.unbindValue(key, value2);
                ((AbstractSessionManager)this.getSessionManager()).doSessionAttributeListeners(this, key, value2, null);
            }
        }
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public void addAttributes(Map<String, Object> map2) {
        this._attributes.putAll(map2);
    }

    @Override
    public Object doPutOrRemove(String name2, Object value2) {
        return value2 == null ? this._attributes.remove(name2) : this._attributes.put(name2, value2);
    }

    @Override
    public Object doGet(String name2) {
        return this._attributes.get(name2);
    }
}

